/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal.config;

import co.decodable.sdk.pipeline.StartupMode;
import co.decodable.sdk.pipeline.util.Unmodifiable;
import java.util.Map;
import java.util.stream.Collectors;

public class StreamConfig {
    private static final String PROPERTIES_PREFIX = "properties.";
    private final String id;
    private final String name;
    private final String bootstrapServers;
    private final String topic;
    private final StartupMode startupMode;
    private final String transactionalIdPrefix;
    private final String deliveryGuarantee;
    @Unmodifiable
    private final Map<String, String> properties;

    public StreamConfig(String id, String name, Map<String, String> properties) {
        this.id = id;
        this.name = name;
        this.bootstrapServers = properties.get("properties.bootstrap.servers");
        this.topic = properties.get("topic");
        this.startupMode = StartupMode.fromString(properties.get("scan.startup.mode"));
        this.transactionalIdPrefix = properties.get("sink.transactional-id-prefix");
        this.deliveryGuarantee = properties.get("sink.delivery-guarantee");
        this.properties = properties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith("properties")).collect(Collectors.toUnmodifiableMap(e -> ((String)e.getKey()).substring(11), e -> (String)e.getValue()));
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String bootstrapServers() {
        return this.bootstrapServers;
    }

    public String topic() {
        return this.topic;
    }

    public StartupMode startupMode() {
        return this.startupMode;
    }

    public String transactionalIdPrefix() {
        return this.transactionalIdPrefix;
    }

    public String deliveryGuarantee() {
        return this.deliveryGuarantee;
    }

    public Map<String, String> kafkaProperties() {
        return this.properties;
    }
}

