/*
 * Decompiled with CFR 0.152.
 */
package co.decodable.sdk.pipeline.internal;

import co.decodable.sdk.pipeline.DecodableSecret;
import co.decodable.sdk.pipeline.exception.SecretNotFoundException;
import co.decodable.sdk.pipeline.util.VisibleForTesting;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;

public class DecodableSecretImpl
implements DecodableSecret {
    private static final Path SECRET_DIRECTORY = Path.of("/opt/pipeline-secrets/", new String[0]);
    @Deprecated(forRemoval=true)
    private static final Path LEGACY_SECRET_DIRECTORY = Path.of("/opt/flink/opt/secrets/", new String[0]);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final String value;
    private final SecretMetadata metadata;

    public DecodableSecretImpl(String name) {
        this(name, SECRET_DIRECTORY, LEGACY_SECRET_DIRECTORY);
    }

    @VisibleForTesting
    DecodableSecretImpl(String name, Path secretsDirectory, Path fallbackDirectory) {
        SecretDescriptor secret = DecodableSecretImpl.getSecret(secretsDirectory, name, false);
        if (secret == null) {
            secret = DecodableSecretImpl.getSecret(fallbackDirectory, name, true);
        }
        this.value = secret.value;
        this.metadata = secret.metadata;
    }

    private static SecretDescriptor getSecret(Path secretsDirectory, String secretName, boolean assertExistence) {
        Path secretFile = secretsDirectory.resolve(secretName);
        Path secretMetadataFile = secretsDirectory.resolve(secretName + ".metadata");
        if (!Files.exists(secretFile, new LinkOption[0]) || !Files.exists(secretMetadataFile, new LinkOption[0])) {
            if (assertExistence) {
                throw new SecretNotFoundException(String.format("Secret [%s] not found. Please make sure it is included in this pipeline's properties.", secretName));
            }
            return null;
        }
        try {
            String value = Files.readString(secretFile, StandardCharsets.UTF_8);
            SecretMetadata metadata = (SecretMetadata)objectMapper.readValue(secretMetadataFile.toFile(), SecretMetadata.class);
            return new SecretDescriptor(value, metadata);
        }
        catch (IOException e) {
            throw new SecretNotFoundException(String.format("Could not read secret [%s]. Please contact Decodable support.", secretName), e);
        }
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String name() {
        return this.metadata.name;
    }

    @Override
    public String description() {
        return this.metadata.description;
    }

    @Override
    public Instant createTime() {
        return this.metadata.createTime;
    }

    @Override
    public Instant updateTime() {
        return this.metadata.updateTime;
    }

    private static class SecretMetadata {
        private final String name;
        private final String description;
        private final Instant createTime;
        private final Instant updateTime;

        public SecretMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="create_time") Long createTime, @JsonProperty(value="update_time") Long updateTime) {
            this.name = name;
            this.description = description;
            this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime);
            this.updateTime = updateTime == null ? null : Instant.ofEpochMilli(updateTime);
        }
    }

    private static class SecretDescriptor {
        String value;
        SecretMetadata metadata;

        public SecretDescriptor(String value, SecretMetadata metadata) {
            this.value = value;
            this.metadata = metadata;
        }
    }
}

