/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.view;

import android.content.Context;
import android.graphics.Canvas;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import co.csadev.kellocharts.animation.ChartAnimationListener;
import co.csadev.kellocharts.animation.ChartDataAnimator;
import co.csadev.kellocharts.animation.ChartDataAnimatorV14;
import co.csadev.kellocharts.animation.ChartViewportAnimator;
import co.csadev.kellocharts.animation.ChartViewportAnimatorV14;
import co.csadev.kellocharts.computator.ChartComputator;
import co.csadev.kellocharts.gesture.ChartTouchHandler;
import co.csadev.kellocharts.gesture.ContainerScrollType;
import co.csadev.kellocharts.gesture.ZoomType;
import co.csadev.kellocharts.listener.ViewportChangeListener;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.renderer.AxesRenderer;
import co.csadev.kellocharts.renderer.ChartRenderer;
import co.csadev.kellocharts.renderer.InternalChartRendererBase;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020a2\u0006\u0010c\u001a\u00020<H\u0016J\u0010\u0010d\u001a\u00020,2\u0006\u0010e\u001a\u00020\bH\u0016J\b\u0010f\u001a\u00020aH\u0016J\b\u0010g\u001a\u00020aH\u0016J\u0018\u0010h\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<H\u0002J \u0010k\u001a\u00020\u001f2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<2\u0006\u0010W\u001a\u00020<H\u0002J\u0018\u0010l\u001a\u00020a2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<H\u0016J\u0018\u0010m\u001a\u00020a2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<H\u0016J\b\u0010n\u001a\u00020aH\u0004J\u0010\u0010o\u001a\u00020a2\u0006\u0010p\u001a\u00020qH\u0014J(\u0010r\u001a\u00020a2\u0006\u0010s\u001a\u00020\b2\u0006\u0010t\u001a\u00020\b2\u0006\u0010u\u001a\u00020\b2\u0006\u0010v\u001a\u00020\bH\u0014J\u0010\u0010w\u001a\u00020,2\u0006\u0010x\u001a\u00020yH\u0016J\b\u0010z\u001a\u00020aH\u0004J\b\u0010{\u001a\u00020aH\u0016J\u0018\u0010.\u001a\u00020a2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010|\u001a\u00020a2\b\u0010}\u001a\u0004\u0018\u00010\u001fH\u0016J\u001a\u0010|\u001a\u00020a2\b\u0010}\u001a\u0004\u0018\u00010\u001f2\u0006\u0010~\u001a\u00020\u007fH\u0016J\u0015\u0010\u0080\u0001\u001a\u00020a2\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H\u0016J\u0015\u0010\u0083\u0001\u001a\u00020a2\n\u0010\u0081\u0001\u001a\u0005\u0018\u00010\u0082\u0001H\u0016J\u0015\u0010\u0084\u0001\u001a\u00020a2\n\u0010\u0085\u0001\u001a\u0005\u0018\u00010\u0086\u0001H\u0016J \u0010Y\u001a\u00020a2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<2\u0006\u0010W\u001a\u00020<H\u0016J!\u0010\u0087\u0001\u001a\u00020a2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<2\u0006\u0010W\u001a\u00020<H\u0016J\t\u0010\u0088\u0001\u001a\u00020aH\u0016J\u0011\u0010\u0088\u0001\u001a\u00020a2\u0006\u0010~\u001a\u00020\u007fH\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020,X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010-\"\u0004\b1\u0010/R$\u00102\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u0010-\"\u0004\b3\u0010/R$\u00104\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b4\u0010-\"\u0004\b5\u0010/R$\u00106\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010-\"\u0004\b7\u0010/R$\u00108\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010-\"\u0004\b9\u0010/R$\u0010:\u001a\u00020,2\u0006\u0010\u0012\u001a\u00020,8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b:\u0010-\"\u0004\b;\u0010/R$\u0010=\u001a\u00020<2\u0006\u0010\u0012\u001a\u00020<8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR$\u0010B\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u001f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bC\u0010\"\"\u0004\bD\u0010$R$\u0010F\u001a\u00020E2\u0006\u0010\u0012\u001a\u00020E8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\u001a\u0010K\u001a\u00020LX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR$\u0010W\u001a\u00020<2\u0006\u0010\u0012\u001a\u00020<8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010?\"\u0004\bY\u0010AR(\u0010[\u001a\u0004\u0018\u00010Z2\b\u0010\u0012\u001a\u0004\u0018\u00010Z8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\\\u0010]\"\u0004\b^\u0010_\u00a8\u0006\u0089\u0001"}, d2={"Lco/csadev/kellocharts/view/AbstractChartView;", "Landroid/view/View;", "Lco/csadev/kellocharts/view/Chart;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "axesRenderer", "Lco/csadev/kellocharts/renderer/AxesRenderer;", "getAxesRenderer", "()Lco/csadev/kellocharts/renderer/AxesRenderer;", "chartComputator", "Lco/csadev/kellocharts/computator/ChartComputator;", "getChartComputator", "()Lco/csadev/kellocharts/computator/ChartComputator;", "value", "Lco/csadev/kellocharts/renderer/ChartRenderer;", "chartRenderer", "getChartRenderer", "()Lco/csadev/kellocharts/renderer/ChartRenderer;", "setChartRenderer", "(Lco/csadev/kellocharts/renderer/ChartRenderer;)V", "containerScrollType", "Lco/csadev/kellocharts/gesture/ContainerScrollType;", "getContainerScrollType", "()Lco/csadev/kellocharts/gesture/ContainerScrollType;", "setContainerScrollType", "(Lco/csadev/kellocharts/gesture/ContainerScrollType;)V", "Lco/csadev/kellocharts/model/Viewport;", "currentViewport", "getCurrentViewport", "()Lco/csadev/kellocharts/model/Viewport;", "setCurrentViewport", "(Lco/csadev/kellocharts/model/Viewport;)V", "dataAnimator", "Lco/csadev/kellocharts/animation/ChartDataAnimator;", "getDataAnimator", "()Lco/csadev/kellocharts/animation/ChartDataAnimator;", "setDataAnimator", "(Lco/csadev/kellocharts/animation/ChartDataAnimator;)V", "isContainerScrollEnabled", "", "()Z", "setContainerScrollEnabled", "(Z)V", "isInteractive", "setInteractive", "isScrollEnabled", "setScrollEnabled", "isValueSelectionEnabled", "setValueSelectionEnabled", "isValueTouchEnabled", "setValueTouchEnabled", "isViewportCalculationEnabled", "setViewportCalculationEnabled", "isZoomEnabled", "setZoomEnabled", "", "maxZoom", "getMaxZoom", "()F", "setMaxZoom", "(F)V", "maximumViewport", "getMaximumViewport", "setMaximumViewport", "Lco/csadev/kellocharts/model/SelectedValue;", "selectedValue", "getSelectedValue", "()Lco/csadev/kellocharts/model/SelectedValue;", "setSelectedValue", "(Lco/csadev/kellocharts/model/SelectedValue;)V", "touchHandler", "Lco/csadev/kellocharts/gesture/ChartTouchHandler;", "getTouchHandler", "()Lco/csadev/kellocharts/gesture/ChartTouchHandler;", "setTouchHandler", "(Lco/csadev/kellocharts/gesture/ChartTouchHandler;)V", "viewportAnimator", "Lco/csadev/kellocharts/animation/ChartViewportAnimator;", "getViewportAnimator", "()Lco/csadev/kellocharts/animation/ChartViewportAnimator;", "setViewportAnimator", "(Lco/csadev/kellocharts/animation/ChartViewportAnimator;)V", "zoomLevel", "getZoomLevel", "setZoomLevel", "Lco/csadev/kellocharts/gesture/ZoomType;", "zoomType", "getZoomType", "()Lco/csadev/kellocharts/gesture/ZoomType;", "setZoomType", "(Lco/csadev/kellocharts/gesture/ZoomType;)V", "animationDataFinished", "", "animationDataUpdate", "scale", "canScrollHorizontally", "direction", "cancelDataAnimation", "computeScroll", "computeScrollViewport", "x", "y", "computeZoomViewport", "moveTo", "moveToWithAnimation", "onChartDataChange", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "width", "height", "oldWidth", "oldHeight", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "resetRendererAndTouchHandler", "resetViewports", "setCurrentViewportWithAnimation", "targetViewport", "duration", "", "setDataAnimationListener", "animationListener", "Lco/csadev/kellocharts/animation/ChartAnimationListener;", "setViewportAnimationListener", "setViewportChangeListener", "viewportChangeListener", "Lco/csadev/kellocharts/listener/ViewportChangeListener;", "setZoomLevelWithAnimation", "startDataAnimation", "kellocharts_release"})
public abstract class AbstractChartView
extends View
implements Chart {
    @NotNull
    private final ChartComputator chartComputator;
    @NotNull
    private final AxesRenderer axesRenderer;
    @NotNull
    private ChartTouchHandler touchHandler;
    @NotNull
    private ChartRenderer chartRenderer;
    @NotNull
    private ChartDataAnimator dataAnimator;
    @NotNull
    private ChartViewportAnimator viewportAnimator;
    private boolean isInteractive;
    private boolean isContainerScrollEnabled;
    @NotNull
    private ContainerScrollType containerScrollType;

    @Override
    @NotNull
    public ChartComputator getChartComputator() {
        return this.chartComputator;
    }

    @Override
    @NotNull
    public AxesRenderer getAxesRenderer() {
        return this.axesRenderer;
    }

    @Override
    @NotNull
    public ChartTouchHandler getTouchHandler() {
        return this.touchHandler;
    }

    @Override
    public void setTouchHandler(@NotNull ChartTouchHandler chartTouchHandler) {
        Intrinsics.checkParameterIsNotNull((Object)chartTouchHandler, (String)"<set-?>");
        this.touchHandler = chartTouchHandler;
    }

    @Override
    @NotNull
    public ChartRenderer getChartRenderer() {
        return this.chartRenderer;
    }

    @Override
    public void setChartRenderer(@NotNull ChartRenderer value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.chartRenderer = value;
        this.resetRendererAndTouchHandler();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @NotNull
    public final ChartDataAnimator getDataAnimator() {
        return this.dataAnimator;
    }

    public final void setDataAnimator(@NotNull ChartDataAnimator chartDataAnimator) {
        Intrinsics.checkParameterIsNotNull((Object)chartDataAnimator, (String)"<set-?>");
        this.dataAnimator = chartDataAnimator;
    }

    @NotNull
    public final ChartViewportAnimator getViewportAnimator() {
        return this.viewportAnimator;
    }

    public final void setViewportAnimator(@NotNull ChartViewportAnimator chartViewportAnimator) {
        Intrinsics.checkParameterIsNotNull((Object)chartViewportAnimator, (String)"<set-?>");
        this.viewportAnimator = chartViewportAnimator;
    }

    @Override
    public boolean isInteractive() {
        return this.isInteractive;
    }

    @Override
    public void setInteractive(boolean bl) {
        this.isInteractive = bl;
    }

    @Override
    public boolean isContainerScrollEnabled() {
        return this.isContainerScrollEnabled;
    }

    public void setContainerScrollEnabled(boolean bl) {
        this.isContainerScrollEnabled = bl;
    }

    @NotNull
    public final ContainerScrollType getContainerScrollType() {
        return this.containerScrollType;
    }

    public final void setContainerScrollType(@NotNull ContainerScrollType containerScrollType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)containerScrollType), (String)"<set-?>");
        this.containerScrollType = containerScrollType;
    }

    @Override
    public boolean isZoomEnabled() {
        return this.getTouchHandler().isZoomEnabled();
    }

    @Override
    public void setZoomEnabled(boolean value) {
        this.getTouchHandler().setZoomEnabled(value);
    }

    @Override
    public boolean isScrollEnabled() {
        return this.getTouchHandler().isScrollEnabled();
    }

    @Override
    public void setScrollEnabled(boolean value) {
        this.getTouchHandler().setScrollEnabled(value);
    }

    @Override
    @Nullable
    public ZoomType getZoomType() {
        return this.getTouchHandler().getZoomType();
    }

    @Override
    public void setZoomType(@Nullable ZoomType value) {
        this.getTouchHandler().setZoomType(value);
    }

    @Override
    public float getMaxZoom() {
        return this.getChartComputator().getMaxZoom$kellocharts_release();
    }

    @Override
    public void setMaxZoom(float value) {
        this.getChartComputator().setMaxZoom$kellocharts_release(value);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public float getZoomLevel() {
        return Math.max(this.getMaximumViewport().width() / this.getCurrentViewport().width(), this.getMaximumViewport().height() / this.getCurrentViewport().height());
    }

    @Override
    public void setZoomLevel(float value) {
        this.setCurrentViewport(this.computeZoomViewport(this.getX(), this.getY(), value));
    }

    @Override
    public void setZoomLevel(float x, float y, float zoomLevel) {
        this.setX(x);
        this.setY(y);
        this.setZoomLevel(zoomLevel);
    }

    @Override
    public boolean isValueTouchEnabled() {
        return this.getTouchHandler().isValueTouchEnabled();
    }

    @Override
    public void setValueTouchEnabled(boolean value) {
        this.getTouchHandler().setValueTouchEnabled(value);
    }

    @Override
    @NotNull
    public Viewport getMaximumViewport() {
        return this.getChartRenderer().getMaximumViewport();
    }

    @Override
    public void setMaximumViewport(@NotNull Viewport value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getChartRenderer().setMaximumViewport(value);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    @NotNull
    public Viewport getCurrentViewport() {
        return this.getChartRenderer().getCurrentViewport();
    }

    @Override
    public void setCurrentViewport(@NotNull Viewport value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getChartRenderer().setCurrentViewport(value);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    @NotNull
    public SelectedValue getSelectedValue() {
        return this.getChartRenderer().getSelectedValue();
    }

    @Override
    public void setSelectedValue(@NotNull SelectedValue value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.getChartRenderer().setSelectedValue(value);
        this.callTouchListener();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public boolean isViewportCalculationEnabled() {
        return this.getChartRenderer().isViewportCalculationEnabled();
    }

    @Override
    public void setViewportCalculationEnabled(boolean value) {
        this.getChartRenderer().setViewportCalculationEnabled(value);
    }

    @Override
    public boolean isValueSelectionEnabled() {
        return this.getTouchHandler().isValueSelectionEnabled();
    }

    @Override
    public void setValueSelectionEnabled(boolean value) {
        this.getTouchHandler().setValueSelectionEnabled(value);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        super.onSizeChanged(width, height, oldWidth, oldHeight);
        this.getChartComputator().setContentRect(this.getWidth(), this.getHeight(), this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.getChartRenderer().onChartSizeChanged();
        this.getAxesRenderer().onChartSizeChanged();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.isEnabled()) {
            this.getAxesRenderer().drawInBackground(canvas);
            int clipRestoreCount = canvas.save();
            canvas.clipRect(this.getChartComputator().getContentRectMinusAllMargins());
            this.getChartRenderer().draw(canvas);
            canvas.restoreToCount(clipRestoreCount);
            this.getChartRenderer().drawUnclipped(canvas);
            this.getAxesRenderer().drawInForeground(canvas);
        } else {
            canvas.drawColor(ChartUtils.INSTANCE.getDEFAULT_COLOR());
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        super.onTouchEvent(event);
        if (this.isInteractive()) {
            boolean needInvalidate;
            boolean bl;
            if (this.isContainerScrollEnabled()) {
                ChartTouchHandler chartTouchHandler = this.getTouchHandler();
                ViewParent viewParent = this.getParent();
                Intrinsics.checkExpressionValueIsNotNull((Object)viewParent, (String)"parent");
                bl = chartTouchHandler.handleTouchEvent(event, viewParent, this.containerScrollType);
            } else {
                bl = needInvalidate = this.getTouchHandler().handleTouchEvent(event);
            }
            if (needInvalidate) {
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
            return true;
        }
        return false;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.isInteractive() && this.getTouchHandler().computeScroll()) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    @Override
    public void startDataAnimation() {
        this.dataAnimator.startAnimation(Long.MIN_VALUE);
    }

    @Override
    public void startDataAnimation(long duration) {
        this.dataAnimator.startAnimation(duration);
    }

    @Override
    public void cancelDataAnimation() {
        this.dataAnimator.cancelAnimation();
    }

    @Override
    public void animationDataUpdate(float scale) {
        this.getChartData().update(scale);
        this.getChartRenderer().onChartViewportChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void animationDataFinished() {
        this.getChartData().finish();
        this.getChartRenderer().onChartViewportChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setDataAnimationListener(@Nullable ChartAnimationListener animationListener) {
        this.dataAnimator.setChartAnimationListener(animationListener);
    }

    @Override
    public void setViewportAnimationListener(@Nullable ChartAnimationListener animationListener) {
        this.viewportAnimator.setChartAnimationListener(animationListener);
    }

    @Override
    public void setViewportChangeListener(@Nullable ViewportChangeListener viewportChangeListener) {
        this.getChartComputator().setViewportChangeListener$kellocharts_release(viewportChangeListener);
    }

    @Override
    public void moveTo(float x, float y) {
        Viewport scrollViewport = this.computeScrollViewport(x, y);
        this.setCurrentViewport(scrollViewport);
    }

    @Override
    public void moveToWithAnimation(float x, float y) {
        Viewport scrollViewport = this.computeScrollViewport(x, y);
        this.setCurrentViewportWithAnimation(scrollViewport);
    }

    private final Viewport computeScrollViewport(float x, float y) {
        Viewport maxViewport = this.getMaximumViewport();
        Viewport currentViewport = this.getCurrentViewport();
        Viewport scrollViewport = ViewportKt.copy(currentViewport);
        if (maxViewport.contains(x, y)) {
            float width = currentViewport.width();
            float height = currentViewport.height();
            float halfWidth = width / (float)2;
            float halfHeight = height / (float)2;
            float left = x - halfWidth;
            float top = y + halfHeight;
            left = Math.max(maxViewport.getLeft(), Math.min(left, maxViewport.getRight() - width));
            top = Math.max(maxViewport.getBottom() + height, Math.min(top, maxViewport.getTop()));
            ViewportKt.set(scrollViewport, Float.valueOf(left), Float.valueOf(top), Float.valueOf(left + width), Float.valueOf(top - height));
        }
        return scrollViewport;
    }

    @Override
    public void setZoomLevelWithAnimation(float x, float y, float zoomLevel) {
        Viewport zoomViewport = this.computeZoomViewport(x, y, zoomLevel);
        this.setCurrentViewportWithAnimation(zoomViewport);
    }

    private final Viewport computeZoomViewport(float x, float y, float zoomLevel) {
        float zoomLevel2 = zoomLevel;
        Viewport maxViewport = this.getMaximumViewport();
        Viewport zoomViewport = ViewportKt.copy(this.getMaximumViewport());
        if (maxViewport.contains(x, y)) {
            if (zoomLevel2 < 1.0f) {
                zoomLevel2 = 1.0f;
            } else if (zoomLevel2 > this.getMaxZoom()) {
                zoomLevel2 = this.getMaxZoom();
            }
            float newWidth = zoomViewport.width() / zoomLevel2;
            float newHeight = zoomViewport.height() / zoomLevel2;
            float halfWidth = newWidth / (float)2;
            float halfHeight = newHeight / (float)2;
            float left = x - halfWidth;
            float right = x + halfWidth;
            float top = y + halfHeight;
            float bottom = y - halfHeight;
            if (left < maxViewport.getLeft()) {
                left = maxViewport.getLeft();
                right = left + newWidth;
            } else if (right > maxViewport.getRight()) {
                right = maxViewport.getRight();
                left = right - newWidth;
            }
            if (top > maxViewport.getTop()) {
                top = maxViewport.getTop();
                bottom = top - newHeight;
            } else if (bottom < maxViewport.getBottom()) {
                bottom = maxViewport.getBottom();
                top = bottom + newHeight;
            }
            ZoomType zoomType = this.getZoomType();
            if (ZoomType.HORIZONTAL_AND_VERTICAL == zoomType) {
                ViewportKt.set(zoomViewport, Float.valueOf(left), Float.valueOf(top), Float.valueOf(right), Float.valueOf(bottom));
            } else if (ZoomType.HORIZONTAL == zoomType) {
                zoomViewport.setLeft(left);
                zoomViewport.setRight(right);
            } else if (ZoomType.VERTICAL == zoomType) {
                zoomViewport.setTop(top);
                zoomViewport.setBottom(bottom);
            }
        }
        return zoomViewport;
    }

    @Override
    public void setCurrentViewportWithAnimation(@Nullable Viewport targetViewport) {
        if (targetViewport != null) {
            this.viewportAnimator.cancelAnimation();
            this.viewportAnimator.startAnimation(this.getCurrentViewport(), targetViewport);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setCurrentViewportWithAnimation(@Nullable Viewport targetViewport, long duration) {
        if (targetViewport != null) {
            this.viewportAnimator.cancelAnimation();
            this.viewportAnimator.startAnimation(this.getCurrentViewport(), targetViewport, duration);
        }
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    @Override
    public void setContainerScrollEnabled(boolean isContainerScrollEnabled, @NotNull ContainerScrollType containerScrollType) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)containerScrollType), (String)"containerScrollType");
        this.setContainerScrollEnabled(isContainerScrollEnabled);
        this.containerScrollType = containerScrollType;
    }

    @Override
    public void resetViewports() {
        this.getChartRenderer().setMaximumViewport(new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
        this.getChartRenderer().setCurrentViewport(new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null));
    }

    protected final void onChartDataChange() {
        this.getChartComputator().resetContentRect();
        this.getChartRenderer().onChartDataChanged();
        this.getAxesRenderer().onChartDataChanged();
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    protected final void resetRendererAndTouchHandler() {
        this.getChartRenderer().resetRenderer();
        this.getAxesRenderer().resetRenderer();
        this.getTouchHandler().resetTouchHandler();
    }

    public boolean canScrollHorizontally(int direction) {
        if ((double)this.getZoomLevel() <= 1.0) {
            return false;
        }
        Viewport currentViewport = this.getCurrentViewport();
        Viewport maximumViewport = this.getMaximumViewport();
        return direction < 0 ? currentViewport.getLeft() > maximumViewport.getLeft() : currentViewport.getRight() < maximumViewport.getRight();
    }

    @JvmOverloads
    public AbstractChartView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.chartComputator = new ChartComputator();
        this.axesRenderer = new AxesRenderer(context, this);
        this.touchHandler = new ChartTouchHandler(context, this);
        this.chartRenderer = new InternalChartRendererBase(context, this);
        this.dataAnimator = new ChartDataAnimatorV14(this);
        this.viewportAnimator = new ChartViewportAnimatorV14(this);
        this.isInteractive = true;
        this.containerScrollType = ContainerScrollType.HORIZONTAL;
    }

    @JvmOverloads
    public /* synthetic */ AbstractChartView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public AbstractChartView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public AbstractChartView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }
}

