/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import co.csadev.kellocharts.model.Line;
import co.csadev.kellocharts.model.LineChartData;
import co.csadev.kellocharts.model.PointValue;
import co.csadev.kellocharts.model.SelectedValue;
import co.csadev.kellocharts.model.ValueShape;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.provider.LineChartDataProvider;
import co.csadev.kellocharts.renderer.AbstractChartRenderer;
import co.csadev.kellocharts.util.ChartUtils;
import co.csadev.kellocharts.view.Chart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0019\b\u0016\u0018\u0000 @2\u00020\u0001:\u0001@B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0019\u001a\u00020\fH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0015H\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010&\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\nH\u0002J\u0018\u0010,\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J8\u0010-\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010.\u001a\u00020\nH\u0002J(\u0010/\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0002J\u0018\u00102\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u00103\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u00104\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0015H\u0016J@\u00105\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u00100\u001a\u00020\f2\u0006\u00106\u001a\u00020\fH\u0002J\u0010\u00107\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020\u0015H\u0002J0\u00108\u001a\u00020\u001d2\u0006\u00109\u001a\u00020\n2\u0006\u0010:\u001a\u00020\n2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nH\u0002J\b\u0010<\u001a\u00020\u001bH\u0016J\b\u0010=\u001a\u00020\u001bH\u0016J\b\u0010>\u001a\u00020\u001bH\u0016J\u0010\u0010?\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lco/csadev/kellocharts/renderer/LineChartRenderer;", "Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "dataProvider", "Lco/csadev/kellocharts/provider/LineChartDataProvider;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;Lco/csadev/kellocharts/provider/LineChartDataProvider;)V", "baseValue", "", "checkPrecision", "", "linePaint", "Landroid/graphics/Paint;", "path", "Landroid/graphics/Path;", "pointPaint", "softwareBitmap", "Landroid/graphics/Bitmap;", "softwareCanvas", "Landroid/graphics/Canvas;", "tempMaximumViewport", "Lco/csadev/kellocharts/model/Viewport;", "touchToleranceMargin", "calculateContentRectInternalMargin", "calculateMaxViewport", "", "checkIfShouldDrawPoints", "", "line", "Lco/csadev/kellocharts/model/Line;", "checkTouch", "touchX", "touchY", "draw", "canvas", "drawArea", "drawLabel", "pointValue", "Lco/csadev/kellocharts/model/PointValue;", "rawX", "rawY", "offset", "drawPath", "drawPoint", "pointRadius", "drawPoints", "lineIndex", "mode", "drawSmoothPath", "drawSquarePath", "drawUnclipped", "highlightPoint", "valueIndex", "highlightPoints", "isInArea", "x", "y", "radius", "onChartDataChanged", "onChartSizeChanged", "onChartViewportChanged", "prepareLinePaint", "Companion", "kellocharts_release"})
public class LineChartRenderer
extends AbstractChartRenderer {
    private final int checkPrecision;
    private float baseValue;
    private final int touchToleranceMargin;
    private final Path path;
    private final Paint linePaint;
    private final Paint pointPaint;
    private Bitmap softwareBitmap;
    private final Canvas softwareCanvas;
    private final Viewport tempMaximumViewport;
    private final LineChartDataProvider dataProvider;
    private static final float LINE_SMOOTHNESS = 0.16f;
    private static final int DEFAULT_LINE_STROKE_WIDTH_DP = 3;
    private static final int DEFAULT_TOUCH_TOLERANCE_MARGIN_DP = 4;
    private static final int MODE_DRAW = 0;
    private static final int MODE_HIGHLIGHT = 1;
    public static final Companion Companion = new Companion(null);

    @Override
    public void onChartSizeChanged() {
        int internalMargin = this.calculateContentRectInternalMargin();
        this.getComputator().insetContentRectByInternalMargins(internalMargin, internalMargin, internalMargin, internalMargin);
        if (this.getComputator().getChartWidth() > 0 && this.getComputator().getChartHeight() > 0) {
            this.softwareBitmap = Bitmap.createBitmap((int)this.getComputator().getChartWidth(), (int)this.getComputator().getChartHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.softwareCanvas.setBitmap(this.softwareBitmap);
        }
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        int internalMargin = this.calculateContentRectInternalMargin();
        this.getComputator().insetContentRectByInternalMargins(internalMargin, internalMargin, internalMargin, internalMargin);
        this.baseValue = this.dataProvider.getLineChartData().getBaseValue();
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled()) {
            this.calculateMaxViewport();
            this.getComputator().setMaximumViewport$kellocharts_release(this.tempMaximumViewport);
            this.getComputator().setCurrentViewport$kellocharts_release(this.getComputator().getMaximumViewport());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Canvas canvas) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Canvas drawCanvas;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        LineChartData data = this.dataProvider.getLineChartData();
        if (this.softwareBitmap != null) {
            drawCanvas = this.softwareCanvas;
            drawCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
        } else {
            drawCanvas = canvas;
        }
        Iterable iterable = data.getLines();
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Line it = (Line)element$iv$iv;
            if (!it.getHasLines()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            Line it = (Line)element$iv;
            if (it.isCubic()) {
                this.drawSmoothPath(drawCanvas, it);
                continue;
            }
            if (it.isSquare()) {
                this.drawSquarePath(drawCanvas, it);
                continue;
            }
            this.drawPath(drawCanvas, it);
        }
        if (this.softwareBitmap != null) {
            Bitmap bitmap = this.softwareBitmap;
            if (bitmap == null) {
                Intrinsics.throwNpe();
            }
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
        }
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        LineChartData data = this.dataProvider.getLineChartData();
        int lineIndex = 0;
        for (Line line : data.getLines()) {
            if (this.checkIfShouldDrawPoints(line)) {
                this.drawPoints(canvas, line, lineIndex, LineChartRenderer.Companion.getMODE_DRAW());
            }
            ++lineIndex;
        }
        if (this.isTouched()) {
            this.highlightPoints(canvas);
        }
    }

    private final boolean checkIfShouldDrawPoints(Line line) {
        return line.getHasPoints() || line.getValues().size() == 1;
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        this.getSelectedValue().clear();
        LineChartData data = this.dataProvider.getLineChartData();
        int lineIndex = 0;
        for (Line line : data.getLines()) {
            if (this.checkIfShouldDrawPoints(line)) {
                int pointRadius = ChartUtils.INSTANCE.dp2px(this.getDensity(), line.getPointRadius());
                int valueIndex = 0;
                for (PointValue pointValue : line.getValues()) {
                    float rawValueY;
                    float rawValueX = this.getComputator().computeRawX(pointValue.getX());
                    if (this.isInArea(rawValueX, rawValueY = this.getComputator().computeRawY(pointValue.getY()), touchX, touchY, pointRadius + this.touchToleranceMargin)) {
                        this.getSelectedValue().set(lineIndex, valueIndex, SelectedValue.SelectedValueType.LINE);
                    }
                    ++valueIndex;
                }
            }
            ++lineIndex;
        }
        return this.isTouched();
    }

    private final void calculateMaxViewport() {
        ViewportKt.set(this.tempMaximumViewport, Float.valueOf(Float.MAX_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE));
        LineChartData data = this.dataProvider.getLineChartData();
        for (Line line : data.getLines()) {
            for (PointValue pointValue : line.getValues()) {
                if (pointValue.getX() < this.tempMaximumViewport.getLeft()) {
                    this.tempMaximumViewport.setLeft(pointValue.getX());
                }
                if (pointValue.getX() > this.tempMaximumViewport.getRight()) {
                    this.tempMaximumViewport.setRight(pointValue.getX());
                }
                if (pointValue.getY() < this.tempMaximumViewport.getBottom()) {
                    this.tempMaximumViewport.setBottom(pointValue.getY());
                }
                if (!(pointValue.getY() > this.tempMaximumViewport.getTop())) continue;
                this.tempMaximumViewport.setTop(pointValue.getY());
            }
        }
    }

    private final int calculateContentRectInternalMargin() {
        int contentAreaMargin = 0;
        LineChartData data = this.dataProvider.getLineChartData();
        for (Line line : data.getLines()) {
            int margin;
            if (!this.checkIfShouldDrawPoints(line) || (margin = line.getPointRadius() + LineChartRenderer.Companion.getDEFAULT_TOUCH_TOLERANCE_MARGIN_DP()) <= contentAreaMargin) continue;
            contentAreaMargin = margin;
        }
        return ChartUtils.INSTANCE.dp2px(this.getDensity(), contentAreaMargin);
    }

    private final void drawPath(Canvas canvas, Line line) {
        this.prepareLinePaint(line);
        int valueIndex = 0;
        for (PointValue pointValue : line.getValues()) {
            float rawX = this.getComputator().computeRawX(pointValue.getX());
            float rawY = this.getComputator().computeRawY(pointValue.getY());
            if (valueIndex == 0) {
                this.path.moveTo(rawX, rawY);
            } else {
                this.path.lineTo(rawX, rawY);
            }
            ++valueIndex;
        }
        canvas.drawPath(this.path, this.linePaint);
        if (line.isFilled()) {
            this.drawArea(canvas, line);
        }
        this.path.reset();
    }

    private final void drawSquarePath(Canvas canvas, Line line) {
        this.prepareLinePaint(line);
        int valueIndex = 0;
        float previousRawY = 0.0f;
        for (PointValue pointValue : line.getValues()) {
            float rawX = this.getComputator().computeRawX(pointValue.getX());
            float rawY = this.getComputator().computeRawY(pointValue.getY());
            if (valueIndex == 0) {
                this.path.moveTo(rawX, rawY);
            } else {
                this.path.lineTo(rawX, previousRawY);
                this.path.lineTo(rawX, rawY);
            }
            previousRawY = rawY;
            ++valueIndex;
        }
        canvas.drawPath(this.path, this.linePaint);
        if (line.isFilled()) {
            this.drawArea(canvas, line);
        }
        this.path.reset();
    }

    /*
     * WARNING - void declaration
     */
    private final void drawSmoothPath(Canvas canvas, Line line) {
        this.prepareLinePaint(line);
        int lineSize = line.getValues().size();
        float prePreviousPointX = Float.NaN;
        float prePreviousPointY = Float.NaN;
        float previousPointX = Float.NaN;
        float previousPointY = Float.NaN;
        float currentPointX = Float.NaN;
        float currentPointY = Float.NaN;
        float nextPointX = Float.NaN;
        float nextPointY = Float.NaN;
        int n = 0;
        int n2 = lineSize;
        while (n < n2) {
            PointValue linePoint;
            void valueIndex;
            if (Float.isNaN(currentPointX)) {
                linePoint = line.getValues().get((int)valueIndex);
                currentPointX = this.getComputator().computeRawX(linePoint.getX());
                currentPointY = this.getComputator().computeRawY(linePoint.getY());
            }
            if (Float.isNaN(previousPointX)) {
                if (valueIndex > 0) {
                    linePoint = line.getValues().get((int)(valueIndex - true));
                    previousPointX = this.getComputator().computeRawX(linePoint.getX());
                    previousPointY = this.getComputator().computeRawY(linePoint.getY());
                } else {
                    previousPointX = currentPointX;
                    previousPointY = currentPointY;
                }
            }
            if (Float.isNaN(prePreviousPointX)) {
                if (valueIndex > true) {
                    linePoint = line.getValues().get((int)(valueIndex - 2));
                    prePreviousPointX = this.getComputator().computeRawX(linePoint.getX());
                    prePreviousPointY = this.getComputator().computeRawY(linePoint.getY());
                } else {
                    prePreviousPointX = previousPointX;
                    prePreviousPointY = previousPointY;
                }
            }
            if (valueIndex < lineSize - 1) {
                linePoint = line.getValues().get((int)(valueIndex + true));
                nextPointX = this.getComputator().computeRawX(linePoint.getX());
                nextPointY = this.getComputator().computeRawY(linePoint.getY());
            } else {
                nextPointX = currentPointX;
                nextPointY = currentPointY;
            }
            if (valueIndex == false) {
                this.path.moveTo(currentPointX, currentPointY);
            } else {
                float firstDiffX = currentPointX - prePreviousPointX;
                float firstDiffY = currentPointY - prePreviousPointY;
                float secondDiffX = nextPointX - previousPointX;
                float secondDiffY = nextPointY - previousPointY;
                float firstControlPointX = previousPointX + LineChartRenderer.Companion.getLINE_SMOOTHNESS() * firstDiffX;
                float firstControlPointY = previousPointY + LineChartRenderer.Companion.getLINE_SMOOTHNESS() * firstDiffY;
                float secondControlPointX = currentPointX - LineChartRenderer.Companion.getLINE_SMOOTHNESS() * secondDiffX;
                float secondControlPointY = currentPointY - LineChartRenderer.Companion.getLINE_SMOOTHNESS() * secondDiffY;
                this.path.cubicTo(firstControlPointX, firstControlPointY, secondControlPointX, secondControlPointY, currentPointX, currentPointY);
            }
            prePreviousPointX = previousPointX;
            prePreviousPointY = previousPointY;
            previousPointX = currentPointX;
            previousPointY = currentPointY;
            currentPointX = nextPointX;
            currentPointY = nextPointY;
            ++valueIndex;
        }
        canvas.drawPath(this.path, this.linePaint);
        if (line.isFilled()) {
            this.drawArea(canvas, line);
        }
        this.path.reset();
    }

    private final void prepareLinePaint(Line line) {
        this.linePaint.setStrokeWidth((float)ChartUtils.INSTANCE.dp2px(this.getDensity(), line.getStrokeWidth()));
        this.linePaint.setColor(line.getColor());
        this.linePaint.setPathEffect(line.getPathEffect());
    }

    private final void drawPoints(Canvas canvas, Line line, int lineIndex, int mode) {
        this.pointPaint.setColor(line.getPointColor());
        int valueIndex = 0;
        for (PointValue pointValue : line.getValues()) {
            int pointRadius = ChartUtils.INSTANCE.dp2px(this.getDensity(), line.getPointRadius());
            float rawX = this.getComputator().computeRawX(pointValue.getX());
            float rawY = this.getComputator().computeRawY(pointValue.getY());
            if (this.getComputator().isWithinContentRect(rawX, rawY, this.checkPrecision)) {
                if (LineChartRenderer.Companion.getMODE_DRAW() == mode) {
                    this.drawPoint(canvas, line, pointValue, rawX, rawY, pointRadius);
                    if (line.getHasLabels()) {
                        this.drawLabel(canvas, line, pointValue, rawX, rawY, pointRadius + this.getLabelOffset());
                    }
                } else if (LineChartRenderer.Companion.getMODE_HIGHLIGHT() == mode) {
                    this.highlightPoint(canvas, line, pointValue, rawX, rawY, lineIndex, valueIndex);
                } else {
                    throw (Throwable)new IllegalStateException("Cannot process points in mode: " + mode);
                }
            }
            ++valueIndex;
        }
    }

    private final void drawPoint(Canvas canvas, Line line, PointValue pointValue, float rawX, float rawY, float pointRadius) {
        if (Intrinsics.areEqual((Object)((Object)ValueShape.SQUARE), (Object)((Object)line.getShape()))) {
            canvas.drawRect(rawX - pointRadius, rawY - pointRadius, rawX + pointRadius, rawY + pointRadius, this.pointPaint);
        } else if (Intrinsics.areEqual((Object)((Object)ValueShape.CIRCLE), (Object)((Object)line.getShape()))) {
            canvas.drawCircle(rawX, rawY, pointRadius, this.pointPaint);
        } else if (Intrinsics.areEqual((Object)((Object)ValueShape.DIAMOND), (Object)((Object)line.getShape()))) {
            canvas.save();
            canvas.rotate(45.0f, rawX, rawY);
            canvas.drawRect(rawX - pointRadius, rawY - pointRadius, rawX + pointRadius, rawY + pointRadius, this.pointPaint);
            canvas.restore();
        } else {
            throw (Throwable)new IllegalArgumentException("Invalid point shape: " + (Object)((Object)line.getShape()));
        }
    }

    private final void highlightPoints(Canvas canvas) {
        int lineIndex = this.getSelectedValue().getFirstIndex();
        Line line = this.dataProvider.getLineChartData().getLines().get(lineIndex);
        this.drawPoints(canvas, line, lineIndex, LineChartRenderer.Companion.getMODE_HIGHLIGHT());
    }

    private final void highlightPoint(Canvas canvas, Line line, PointValue pointValue, float rawX, float rawY, int lineIndex, int valueIndex) {
        if (this.getSelectedValue().getFirstIndex() == lineIndex && this.getSelectedValue().getSecondIndex() == valueIndex) {
            int pointRadius = ChartUtils.INSTANCE.dp2px(this.getDensity(), line.getPointRadius());
            this.pointPaint.setColor(line.getDarkenColor());
            this.drawPoint(canvas, line, pointValue, rawX, rawY, pointRadius + this.touchToleranceMargin);
            if (line.getHasLabels() || line.getHasLabelsOnlyForSelected()) {
                this.drawLabel(canvas, line, pointValue, rawX, rawY, pointRadius + this.getLabelOffset());
            }
        }
    }

    private final void drawLabel(Canvas canvas, Line line, PointValue pointValue, float rawX, float rawY, float offset) {
        float bottom;
        float top;
        Rect contentRect = this.getComputator().getContentRectMinusAllMargins();
        int numChars = line.getFormatter().formatChartValue(this.getLabelBuffer(), pointValue);
        if (numChars == 0) {
            return;
        }
        float labelWidth = this.getLabelPaint().measureText(this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars);
        int labelHeight = Math.abs(this.getFontMetrics().ascent);
        float left = rawX - labelWidth / (float)2 - (float)this.getLabelMargin();
        float right = rawX + labelWidth / (float)2 + (float)this.getLabelMargin();
        if (pointValue.getY() >= this.baseValue) {
            top = rawY - offset - (float)labelHeight - (float)(this.getLabelMargin() * 2);
            bottom = rawY - offset;
        } else {
            top = rawY + offset;
            bottom = rawY + offset + (float)labelHeight + (float)(this.getLabelMargin() * 2);
        }
        if (top < (float)contentRect.top) {
            top = rawY + offset;
            bottom = rawY + offset + (float)labelHeight + (float)(this.getLabelMargin() * 2);
        }
        if (bottom > (float)contentRect.bottom) {
            top = rawY - offset - (float)labelHeight - (float)(this.getLabelMargin() * 2);
            bottom = rawY - offset;
        }
        if (left < (float)contentRect.left) {
            left = rawX;
            right = rawX + labelWidth + (float)(this.getLabelMargin() * 2);
        }
        if (right > (float)contentRect.right) {
            left = rawX - labelWidth - (float)(this.getLabelMargin() * 2);
            right = rawX;
        }
        this.getLabelBackgroundRect().set(left, top, right, bottom);
        this.drawLabelTextAndBackground(canvas, this.getLabelBuffer(), this.getLabelBuffer().length - numChars, numChars, line.getDarkenColor());
    }

    private final void drawArea(Canvas canvas, Line line) {
        int lineSize = line.getValues().size();
        if (lineSize < 2) {
            return;
        }
        Rect contentRect = this.getComputator().getContentRectMinusAllMargins();
        float baseRawValue = Math.min((float)contentRect.bottom, Math.max(this.getComputator().computeRawY(this.baseValue), (float)contentRect.top));
        float left = Math.max(this.getComputator().computeRawX(line.getValues().get(0).getX()), (float)contentRect.left);
        float right = Math.min(this.getComputator().computeRawX(line.getValues().get(lineSize - 1).getX()), (float)contentRect.right);
        this.path.lineTo(right, baseRawValue);
        this.path.lineTo(left, baseRawValue);
        this.path.close();
        this.linePaint.setStyle(Paint.Style.FILL);
        this.linePaint.setAlpha(line.getAreaTransparency());
        canvas.drawPath(this.path, this.linePaint);
        this.linePaint.setStyle(Paint.Style.STROKE);
    }

    private final boolean isInArea(float x, float y, float touchX, float touchY, float radius) {
        float diffX = touchX - x;
        float diffY = touchY - y;
        return Math.pow(diffX, 2.0) + Math.pow(diffY, 2.0) <= (double)2 * Math.pow(radius, 2.0);
    }

    public LineChartRenderer(@NotNull Context context, @NotNull Chart chart, @NotNull LineChartDataProvider dataProvider) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        Intrinsics.checkParameterIsNotNull((Object)dataProvider, (String)"dataProvider");
        super(context, chart);
        this.dataProvider = dataProvider;
        this.path = new Path();
        this.linePaint = new Paint();
        this.pointPaint = new Paint();
        this.softwareCanvas = new Canvas();
        this.tempMaximumViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
        this.touchToleranceMargin = ChartUtils.INSTANCE.dp2px(this.getDensity(), LineChartRenderer.Companion.getDEFAULT_TOUCH_TOLERANCE_MARGIN_DP());
        this.linePaint.setAntiAlias(true);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setStrokeCap(Paint.Cap.ROUND);
        this.linePaint.setStrokeWidth((float)ChartUtils.INSTANCE.dp2px(this.getDensity(), LineChartRenderer.Companion.getDEFAULT_LINE_STROKE_WIDTH_DP()));
        this.pointPaint.setAntiAlias(true);
        this.pointPaint.setStyle(Paint.Style.FILL);
        this.checkPrecision = ChartUtils.INSTANCE.dp2px(this.getDensity(), 2);
    }

    static {
        LINE_SMOOTHNESS = 0.16f;
        DEFAULT_LINE_STROKE_WIDTH_DP = 3;
        DEFAULT_TOUCH_TOLERANCE_MARGIN_DP = 4;
        MODE_HIGHLIGHT = 1;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lco/csadev/kellocharts/renderer/LineChartRenderer$Companion;", "", "()V", "DEFAULT_LINE_STROKE_WIDTH_DP", "", "getDEFAULT_LINE_STROKE_WIDTH_DP", "()I", "DEFAULT_TOUCH_TOLERANCE_MARGIN_DP", "getDEFAULT_TOUCH_TOLERANCE_MARGIN_DP", "LINE_SMOOTHNESS", "", "getLINE_SMOOTHNESS", "()F", "MODE_DRAW", "getMODE_DRAW", "MODE_HIGHLIGHT", "getMODE_HIGHLIGHT", "kellocharts_release"})
    public static final class Companion {
        private final float getLINE_SMOOTHNESS() {
            return LINE_SMOOTHNESS;
        }

        private final int getDEFAULT_LINE_STROKE_WIDTH_DP() {
            return DEFAULT_LINE_STROKE_WIDTH_DP;
        }

        private final int getDEFAULT_TOUCH_TOLERANCE_MARGIN_DP() {
            return DEFAULT_TOUCH_TOLERANCE_MARGIN_DP;
        }

        private final int getMODE_DRAW() {
            return MODE_DRAW;
        }

        private final int getMODE_HIGHLIGHT() {
            return MODE_HIGHLIGHT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

