/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.renderer;

import android.content.Context;
import android.graphics.Canvas;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import co.csadev.kellocharts.renderer.AbstractChartRenderer;
import co.csadev.kellocharts.renderer.ChartRenderer;
import co.csadev.kellocharts.view.Chart;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001aH\u0016J\b\u0010 \u001a\u00020\u001aH\u0016J\b\u0010!\u001a\u00020\u001aH\u0016R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lco/csadev/kellocharts/renderer/ComboChartRenderer;", "Lco/csadev/kellocharts/renderer/AbstractChartRenderer;", "context", "Landroid/content/Context;", "chart", "Lco/csadev/kellocharts/view/Chart;", "(Landroid/content/Context;Lco/csadev/kellocharts/view/Chart;)V", "renderers", "", "Lco/csadev/kellocharts/renderer/ChartRenderer;", "getRenderers$kellocharts_release", "()Ljava/util/List;", "setRenderers$kellocharts_release", "(Ljava/util/List;)V", "unionViewport", "Lco/csadev/kellocharts/model/Viewport;", "getUnionViewport", "()Lco/csadev/kellocharts/model/Viewport;", "setUnionViewport", "(Lco/csadev/kellocharts/model/Viewport;)V", "checkTouch", "", "touchX", "", "touchY", "clearTouch", "", "draw", "canvas", "Landroid/graphics/Canvas;", "drawUnclipped", "onChartDataChanged", "onChartSizeChanged", "onChartViewportChanged", "kellocharts_release"})
public class ComboChartRenderer
extends AbstractChartRenderer {
    @NotNull
    private List<ChartRenderer> renderers;
    @NotNull
    private Viewport unionViewport;

    @NotNull
    public final List<ChartRenderer> getRenderers$kellocharts_release() {
        return this.renderers;
    }

    public final void setRenderers$kellocharts_release(@NotNull List<ChartRenderer> list) {
        Intrinsics.checkParameterIsNotNull(list, (String)"<set-?>");
        this.renderers = list;
    }

    @NotNull
    protected final Viewport getUnionViewport() {
        return this.unionViewport;
    }

    protected final void setUnionViewport(@NotNull Viewport viewport) {
        Intrinsics.checkParameterIsNotNull((Object)viewport, (String)"<set-?>");
        this.unionViewport = viewport;
    }

    @Override
    public void onChartSizeChanged() {
        for (ChartRenderer renderer : this.renderers) {
            renderer.onChartSizeChanged();
        }
    }

    @Override
    public void onChartDataChanged() {
        super.onChartDataChanged();
        for (ChartRenderer renderer : this.renderers) {
            renderer.onChartDataChanged();
        }
        this.onChartViewportChanged();
    }

    @Override
    public void onChartViewportChanged() {
        if (this.isViewportCalculationEnabled()) {
            int rendererIndex = 0;
            for (ChartRenderer renderer : this.renderers) {
                renderer.onChartViewportChanged();
                if (rendererIndex == 0) {
                    ViewportKt.set(this.unionViewport, renderer.getMaximumViewport());
                } else {
                    this.unionViewport.union(renderer.getMaximumViewport());
                }
                ++rendererIndex;
            }
            this.getComputator().setMaximumViewport$kellocharts_release(this.unionViewport);
            this.getComputator().setCurrentViewport$kellocharts_release(this.unionViewport);
        }
    }

    @Override
    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        for (ChartRenderer renderer : this.renderers) {
            renderer.draw(canvas);
        }
    }

    @Override
    public void drawUnclipped(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        for (ChartRenderer renderer : this.renderers) {
            renderer.drawUnclipped(canvas);
        }
    }

    @Override
    public boolean checkTouch(float touchX, float touchY) {
        ChartRenderer renderer;
        int rendererIndex;
        this.getSelectedValue().clear();
        for (rendererIndex = this.renderers.size() - 1; rendererIndex >= 0; --rendererIndex) {
            renderer = this.renderers.get(rendererIndex);
            if (!renderer.checkTouch(touchX, touchY)) continue;
            this.getSelectedValue().set(renderer.getSelectedValue());
            break;
        }
        --rendererIndex;
        while (rendererIndex >= 0) {
            renderer = this.renderers.get(rendererIndex);
            renderer.clearTouch();
            --rendererIndex;
        }
        return this.isTouched();
    }

    @Override
    public void clearTouch() {
        for (ChartRenderer renderer : this.renderers) {
            renderer.clearTouch();
        }
        this.getSelectedValue().clear();
    }

    public ComboChartRenderer(@NotNull Context context, @NotNull Chart chart) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chart, (String)"chart");
        super(context, chart);
        this.renderers = new ArrayList();
        this.unionViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    }
}

