/*
 * Decompiled with CFR 0.152.
 */
package co.csadev.kellocharts.computator;

import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import co.csadev.kellocharts.listener.DummyViewportChangeListener;
import co.csadev.kellocharts.listener.ViewportChangeListener;
import co.csadev.kellocharts.model.Viewport;
import co.csadev.kellocharts.model.ViewportKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\b\u0016\u0018\u0000 b2\u00020\u0001:\u0001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u00108\u001a\u000209H\u0002J\u000e\u0010:\u001a\u00020 2\u0006\u0010;\u001a\u00020 J\u000e\u0010<\u001a\u00020 2\u0006\u0010;\u001a\u00020 J\u0010\u0010=\u001a\u00020 2\u0006\u0010>\u001a\u00020 H\u0016J\u0010\u0010?\u001a\u00020 2\u0006\u0010@\u001a\u00020 H\u0016J\u000e\u0010A\u001a\u0002092\u0006\u0010B\u001a\u00020CJ(\u0010D\u001a\u0002092\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020 H\u0016J&\u0010I\u001a\u0002092\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u0004J&\u0010N\u001a\u0002092\u0006\u0010J\u001a\u00020\u00042\u0006\u0010K\u001a\u00020\u00042\u0006\u0010L\u001a\u00020\u00042\u0006\u0010M\u001a\u00020\u0004J\u001e\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020 2\u0006\u0010S\u001a\u00020 J\u001e\u0010T\u001a\u00020P2\u0006\u0010Q\u001a\u00020 2\u0006\u0010R\u001a\u00020 2\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u000209J6\u0010X\u001a\u0002092\u0006\u0010Y\u001a\u00020\u00042\u0006\u0010Z\u001a\u00020\u00042\u0006\u0010[\u001a\u00020\u00042\u0006\u0010\\\u001a\u00020\u00042\u0006\u0010]\u001a\u00020\u00042\u0006\u0010^\u001a\u00020\u0004J&\u0010_\u001a\u0002092\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 2\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020 J,\u0010`\u001a\u0002092\u0006\u0010E\u001a\u00020 2\b\b\u0002\u0010F\u001a\u00020 2\b\b\u0002\u0010G\u001a\u00020 2\b\b\u0002\u0010H\u001a\u00020 J\u0016\u0010a\u001a\u0002092\u0006\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020 R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR$\u0010\n\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R$\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\r@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R$\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017@@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\rX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0010\"\u0004\b\u001f\u0010\u0012R$\u0010!\u001a\u00020 2\u0006\u0010\u0016\u001a\u00020 @@X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R$\u0010&\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0017@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001a\"\u0004\b(\u0010\u001cR$\u0010)\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020 @DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010#\"\u0004\b+\u0010%R$\u0010,\u001a\u00020 2\u0006\u0010\u0003\u001a\u00020 @DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010#\"\u0004\b.\u0010%R(\u00100\u001a\u0004\u0018\u00010/2\b\u0010\u0003\u001a\u0004\u0018\u00010/@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\u00172\u0006\u00105\u001a\u00020\u00178V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u001a\"\u0004\b7\u0010\u001c\u00a8\u0006c"}, d2={"Lco/csadev/kellocharts/computator/ChartComputator;", "", "()V", "<set-?>", "", "chartHeight", "getChartHeight", "()I", "setChartHeight", "(I)V", "chartWidth", "getChartWidth", "setChartWidth", "Landroid/graphics/Rect;", "contentRectMinusAllMargins", "getContentRectMinusAllMargins", "()Landroid/graphics/Rect;", "setContentRectMinusAllMargins", "(Landroid/graphics/Rect;)V", "contentRectMinusAxesMargins", "getContentRectMinusAxesMargins", "setContentRectMinusAxesMargins", "value", "Lco/csadev/kellocharts/model/Viewport;", "currentViewport", "getCurrentViewport$kellocharts_release", "()Lco/csadev/kellocharts/model/Viewport;", "setCurrentViewport$kellocharts_release", "(Lco/csadev/kellocharts/model/Viewport;)V", "maxContentRect", "getMaxContentRect", "setMaxContentRect", "", "maxZoom", "getMaxZoom$kellocharts_release", "()F", "setMaxZoom$kellocharts_release", "(F)V", "maximumViewport", "getMaximumViewport", "setMaximumViewport$kellocharts_release", "minimumViewportHeight", "getMinimumViewportHeight", "setMinimumViewportHeight", "minimumViewportWidth", "getMinimumViewportWidth", "setMinimumViewportWidth", "Lco/csadev/kellocharts/listener/ViewportChangeListener;", "viewportChangeListener", "getViewportChangeListener", "()Lco/csadev/kellocharts/listener/ViewportChangeListener;", "setViewportChangeListener$kellocharts_release", "(Lco/csadev/kellocharts/listener/ViewportChangeListener;)V", "visibleViewport", "getVisibleViewport", "setVisibleViewport", "computeMinimumWidthAndHeight", "", "computeRawDistanceX", "distance", "computeRawDistanceY", "computeRawX", "valueX", "computeRawY", "valueY", "computeScrollSurfaceSize", "out", "Landroid/graphics/Point;", "constrainViewport", "left", "top", "right", "bottom", "insetContentRect", "deltaLeft", "deltaTop", "deltaRight", "deltaBottom", "insetContentRectByInternalMargins", "isWithinContentRect", "", "x", "y", "precision", "rawPixelsToDataPoint", "dest", "Landroid/graphics/PointF;", "resetContentRect", "setContentRect", "width", "height", "paddingLeft", "paddingTop", "paddingRight", "paddingBottom", "setCurrentViewport", "setMaxViewport", "setViewportTopLeft", "Companion", "kellocharts_release"})
public class ChartComputator {
    private float maxZoom = Companion.getDEFAULT_MAXIMUM_ZOOM();
    private int chartWidth;
    private int chartHeight;
    @NotNull
    private Rect contentRectMinusAllMargins = new Rect();
    @NotNull
    private Rect contentRectMinusAxesMargins = new Rect();
    @NotNull
    private Rect maxContentRect = new Rect();
    @NotNull
    private Viewport currentViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    @NotNull
    private Viewport maximumViewport = new Viewport(0.0f, 0.0f, 0.0f, 0.0f, 15, null);
    private float minimumViewportWidth;
    private float minimumViewportHeight;
    @Nullable
    private ViewportChangeListener viewportChangeListener = new DummyViewportChangeListener();
    private static final float DEFAULT_MAXIMUM_ZOOM = 20.0f;
    public static final Companion Companion = new Companion(null);

    public final float getMaxZoom$kellocharts_release() {
        return this.maxZoom;
    }

    public final void setMaxZoom$kellocharts_release(float value) {
        this.maxZoom = value;
        if (this.maxZoom < 1.0f) {
            this.maxZoom = 1.0f;
        }
        this.computeMinimumWidthAndHeight();
        this.setCurrentViewport$kellocharts_release(this.currentViewport);
    }

    public final int getChartWidth() {
        return this.chartWidth;
    }

    protected final void setChartWidth(int n) {
        this.chartWidth = n;
    }

    public final int getChartHeight() {
        return this.chartHeight;
    }

    protected final void setChartHeight(int n) {
        this.chartHeight = n;
    }

    @NotNull
    public final Rect getContentRectMinusAllMargins() {
        return this.contentRectMinusAllMargins;
    }

    protected final void setContentRectMinusAllMargins(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.contentRectMinusAllMargins = rect;
    }

    @NotNull
    public final Rect getContentRectMinusAxesMargins() {
        return this.contentRectMinusAxesMargins;
    }

    protected final void setContentRectMinusAxesMargins(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.contentRectMinusAxesMargins = rect;
    }

    @NotNull
    protected final Rect getMaxContentRect() {
        return this.maxContentRect;
    }

    protected final void setMaxContentRect(@NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"<set-?>");
        this.maxContentRect = rect;
    }

    @NotNull
    public final Viewport getCurrentViewport$kellocharts_release() {
        return this.currentViewport;
    }

    public final void setCurrentViewport$kellocharts_release(@NotNull Viewport value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.constrainViewport(value.getLeft(), value.getTop(), value.getRight(), value.getBottom());
    }

    @NotNull
    public final Viewport getMaximumViewport() {
        return this.maximumViewport;
    }

    public final void setMaximumViewport$kellocharts_release(@NotNull Viewport viewport) {
        Intrinsics.checkParameterIsNotNull((Object)viewport, (String)"<set-?>");
        this.maximumViewport = viewport;
    }

    public final float getMinimumViewportWidth() {
        return this.minimumViewportWidth;
    }

    protected final void setMinimumViewportWidth(float f) {
        this.minimumViewportWidth = f;
    }

    public final float getMinimumViewportHeight() {
        return this.minimumViewportHeight;
    }

    protected final void setMinimumViewportHeight(float f) {
        this.minimumViewportHeight = f;
    }

    @Nullable
    public final ViewportChangeListener getViewportChangeListener() {
        return this.viewportChangeListener;
    }

    public final void setViewportChangeListener$kellocharts_release(@Nullable ViewportChangeListener viewportChangeListener) {
        this.viewportChangeListener = viewportChangeListener;
    }

    @NotNull
    public Viewport getVisibleViewport() {
        return this.currentViewport;
    }

    public void setVisibleViewport(@NotNull Viewport visibleViewport) {
        Intrinsics.checkParameterIsNotNull((Object)visibleViewport, (String)"visibleViewport");
        this.setCurrentViewport$kellocharts_release(visibleViewport);
    }

    public final void setContentRect(int width, int height, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.chartWidth = width;
        this.chartHeight = height;
        this.maxContentRect.set(paddingLeft, paddingTop, width - paddingRight, height - paddingBottom);
        this.contentRectMinusAxesMargins.set(this.maxContentRect);
        this.contentRectMinusAllMargins.set(this.maxContentRect);
    }

    public final void resetContentRect() {
        this.contentRectMinusAxesMargins.set(this.maxContentRect);
        this.contentRectMinusAllMargins.set(this.maxContentRect);
    }

    public final void insetContentRect(int deltaLeft, int deltaTop, int deltaRight, int deltaBottom) {
        this.contentRectMinusAxesMargins.left += deltaLeft;
        this.contentRectMinusAxesMargins.top += deltaTop;
        this.contentRectMinusAxesMargins.right -= deltaRight;
        this.contentRectMinusAxesMargins.bottom -= deltaBottom;
        this.insetContentRectByInternalMargins(deltaLeft, deltaTop, deltaRight, deltaBottom);
    }

    public final void insetContentRectByInternalMargins(int deltaLeft, int deltaTop, int deltaRight, int deltaBottom) {
        this.contentRectMinusAllMargins.left += deltaLeft;
        this.contentRectMinusAllMargins.top += deltaTop;
        this.contentRectMinusAllMargins.right -= deltaRight;
        this.contentRectMinusAllMargins.bottom -= deltaBottom;
    }

    public void constrainViewport(float left, float top, float right, float bottom) {
        block8: {
            float left2 = left;
            float top2 = top;
            float right2 = right;
            float bottom2 = bottom;
            if (right2 - left2 < this.minimumViewportWidth) {
                right2 = left2 + this.minimumViewportWidth;
                if (left2 < this.maximumViewport.getLeft()) {
                    left2 = this.maximumViewport.getLeft();
                    right2 = left2 + this.minimumViewportWidth;
                } else if (right2 > this.maximumViewport.getRight()) {
                    right2 = this.maximumViewport.getRight();
                    left2 = right2 - this.minimumViewportWidth;
                }
            }
            if (top2 - bottom2 < this.minimumViewportHeight) {
                bottom2 = top2 - this.minimumViewportHeight;
                if (top2 > this.maximumViewport.getTop()) {
                    top2 = this.maximumViewport.getTop();
                    bottom2 = top2 - this.minimumViewportHeight;
                } else if (bottom2 < this.maximumViewport.getBottom()) {
                    bottom2 = this.maximumViewport.getBottom();
                    top2 = bottom2 + this.minimumViewportHeight;
                }
            }
            this.currentViewport.setLeft(Math.max(this.maximumViewport.getLeft(), left2));
            this.currentViewport.setTop(Math.min(this.maximumViewport.getTop(), top2));
            this.currentViewport.setRight(Math.min(this.maximumViewport.getRight(), right2));
            this.currentViewport.setBottom(Math.max(this.maximumViewport.getBottom(), bottom2));
            ViewportChangeListener viewportChangeListener = this.viewportChangeListener;
            if (viewportChangeListener == null) break block8;
            viewportChangeListener.onViewportChanged(this.currentViewport);
        }
    }

    public final void setViewportTopLeft(float left, float top) {
        float left2 = left;
        float top2 = top;
        float curWidth = this.currentViewport.width();
        float curHeight = this.currentViewport.height();
        left2 = Math.max(this.maximumViewport.getLeft(), Math.min(left2, this.maximumViewport.getRight() - curWidth));
        top2 = Math.max(this.maximumViewport.getBottom() + curHeight, Math.min(top2, this.maximumViewport.getTop()));
        this.constrainViewport(left2, top2, left2 + curWidth, top2 - curHeight);
    }

    public float computeRawX(float valueX) {
        float pixelOffset = (valueX - this.currentViewport.getLeft()) * ((float)this.contentRectMinusAllMargins.width() / this.currentViewport.width());
        return (float)this.contentRectMinusAllMargins.left + pixelOffset;
    }

    public float computeRawY(float valueY) {
        float pixelOffset = (valueY - this.currentViewport.getBottom()) * ((float)this.contentRectMinusAllMargins.height() / this.currentViewport.height());
        return (float)this.contentRectMinusAllMargins.bottom - pixelOffset;
    }

    public final float computeRawDistanceX(float distance) {
        return distance * ((float)this.contentRectMinusAllMargins.width() / this.currentViewport.width());
    }

    public final float computeRawDistanceY(float distance) {
        return distance * ((float)this.contentRectMinusAllMargins.height() / this.currentViewport.height());
    }

    public final boolean rawPixelsToDataPoint(float x, float y, @NotNull PointF dest) {
        Intrinsics.checkParameterIsNotNull((Object)dest, (String)"dest");
        if (!this.contentRectMinusAllMargins.contains((int)x, (int)y)) {
            return false;
        }
        dest.set(this.currentViewport.getLeft() + (x - (float)this.contentRectMinusAllMargins.left) * this.currentViewport.width() / (float)this.contentRectMinusAllMargins.width(), this.currentViewport.getBottom() + (y - (float)this.contentRectMinusAllMargins.bottom) * this.currentViewport.height() / (float)(-this.contentRectMinusAllMargins.height()));
        return true;
    }

    public final void computeScrollSurfaceSize(@NotNull Point out) {
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        out.set((int)(this.maximumViewport.width() * (float)this.contentRectMinusAllMargins.width() / this.currentViewport.width()), (int)(this.maximumViewport.height() * (float)this.contentRectMinusAllMargins.height() / this.currentViewport.height()));
    }

    public final boolean isWithinContentRect(float x, float y, float precision) {
        return x >= (float)this.contentRectMinusAllMargins.left - precision && x <= (float)this.contentRectMinusAllMargins.right + precision && y <= (float)this.contentRectMinusAllMargins.bottom + precision && y >= (float)this.contentRectMinusAllMargins.top - precision;
    }

    public final void setCurrentViewport(float left, float top, float right, float bottom) {
        this.constrainViewport(left, top, right, bottom);
    }

    public final void setMaxViewport(float left, float top, float right, float bottom) {
        ViewportKt.set(this.maximumViewport, Float.valueOf(left), Float.valueOf(top), Float.valueOf(right), Float.valueOf(bottom));
        this.computeMinimumWidthAndHeight();
    }

    public static /* bridge */ /* synthetic */ void setMaxViewport$default(ChartComputator chartComputator, float f, float f2, float f3, float f4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setMaxViewport");
        }
        if ((n & 2) != 0) {
            f2 = f;
        }
        if ((n & 4) != 0) {
            f3 = f;
        }
        if ((n & 8) != 0) {
            f4 = f;
        }
        chartComputator.setMaxViewport(f, f2, f3, f4);
    }

    private final void computeMinimumWidthAndHeight() {
        this.minimumViewportWidth = this.maximumViewport.width() / this.maxZoom;
        this.minimumViewportHeight = this.maximumViewport.height() / this.maxZoom;
    }

    static {
        DEFAULT_MAXIMUM_ZOOM = 20.0f;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lco/csadev/kellocharts/computator/ChartComputator$Companion;", "", "()V", "DEFAULT_MAXIMUM_ZOOM", "", "getDEFAULT_MAXIMUM_ZOOM", "()F", "kellocharts_release"})
    public static final class Companion {
        protected final float getDEFAULT_MAXIMUM_ZOOM() {
            return DEFAULT_MAXIMUM_ZOOM;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

