/*
 * Decompiled with CFR 0.152.
 */
package co.cask.format.text.input;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;

public class CombineHeaderFileSplit
extends CombineFileSplit {
    private String header;

    public CombineHeaderFileSplit() {
    }

    public CombineHeaderFileSplit(CombineFileSplit split, @Nullable String header) throws IOException {
        super(split.getPaths(), split.getStartOffsets(), split.getLengths(), split.getLocations());
        this.header = header;
    }

    @Nullable
    public String getHeader() {
        return this.header;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeBoolean(this.header != null);
        if (this.header != null) {
            out.writeUTF(this.header);
        }
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (in.readBoolean()) {
            this.header = in.readUTF();
        }
    }
}

