/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.UserIdParameter;
import com.amazon.device.ads.WebRequest;

class AdvertisingIdParameter
implements UserIdParameter {
    private static final String DEVICE_ID_KEY = "deviceId";
    private final DebugProperties debugProperties;
    private final Settings settings;
    private final AdvertisingIdentifier advertisingIdentifier;
    private AdvertisingIdentifier.Info advertisingIndentifierInfo;
    private DeviceInfo deviceInfo;

    public AdvertisingIdParameter() {
        this(new AdvertisingIdentifier(), Settings.getInstance(), DebugProperties.getInstance(), MobileAdsInfoStore.getInstance().getDeviceInfo());
    }

    AdvertisingIdParameter(AdvertisingIdentifier advertisingIdentifier, Settings settings, DebugProperties debugProperties, DeviceInfo deviceInfo) {
        this.advertisingIdentifier = advertisingIdentifier;
        this.settings = settings;
        this.debugProperties = debugProperties;
        this.deviceInfo = deviceInfo;
    }

    private boolean canIdentify() {
        if (this.advertisingIndentifierInfo == null) {
            this.advertisingIdentifier.setShouldSetCurrentAdvertisingIdentifier(this.settings.getInt("configVersion", 0) != 0);
            this.advertisingIndentifierInfo = this.advertisingIdentifier.getAdvertisingIdentifierInfo();
        }
        if (this.deviceInfo == null) {
            this.deviceInfo = MobileAdsInfoStore.getInstance().getDeviceInfo();
        }
        return this.advertisingIndentifierInfo.canDo();
    }

    @Override
    public boolean evaluate(WebRequest request) {
        String idfa;
        if (this.canIdentify() && (idfa = this.debugProperties.getDebugPropertyAsString("debug.idfa", this.advertisingIndentifierInfo.getAdvertisingIdentifier())) != null) {
            request.putUnencodedQueryParameter("idfa", idfa);
            return true;
        }
        String deviceId = this.settings.getString(DEVICE_ID_KEY, this.deviceInfo.getUdidSha1());
        request.putUnencodedQueryParameter(DEVICE_ID_KEY, this.debugProperties.getDebugPropertyAsString("debug.sha1udid", deviceId));
        return true;
    }
}

