/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.webkit.JavascriptInterface;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONObject;

class JavascriptInteractor {
    private static final String LOGTAG = JavascriptInteractor.class.getSimpleName();
    private static String executorMethodName;
    private final Map<String, JavascriptMethodExecutor> methodMap = new ConcurrentHashMap<String, JavascriptMethodExecutor>();
    private final Executor executor = new Executor(this);
    private static final MobileAdsLogger logger;

    public static String getExecutorMethodName() {
        if (executorMethodName == null) {
            Method[] methods = Executor.class.getDeclaredMethods();
            if (methods != null && methods.length == 1) {
                executorMethodName = methods[0].getName();
            } else {
                logger.e("Could not obtain the method name for javascript interfacing.");
            }
        }
        return executorMethodName;
    }

    public void addMethodExecutor(JavascriptMethodExecutor javascriptMethodExecutor) {
        if (this.methodMap.containsKey(javascriptMethodExecutor.getMethodName())) {
            throw new IllegalArgumentException("There is another executor with that method name already added.");
        }
        this.methodMap.put(javascriptMethodExecutor.getMethodName(), javascriptMethodExecutor);
    }

    public Executor getExecutor() {
        return this.executor;
    }

    private JSONObject execute(String method, String javascriptObjectParameters) {
        JSONObject jsonObject = null;
        if (javascriptObjectParameters != null && javascriptObjectParameters.length() > 2 && (jsonObject = JSONUtils.getJSONObjectFromString(javascriptObjectParameters)) == null) {
            logger.w("The javascript object \"%s\" could not be parsed for method \"%s\".", javascriptObjectParameters, method);
            return null;
        }
        return this.execute(method, jsonObject);
    }

    private JSONObject execute(String method, JSONObject jsonObject) {
        if (this.methodMap.containsKey(method)) {
            JavascriptMethodExecutor ji = this.methodMap.get(method);
            return ji.execute(jsonObject);
        }
        logger.w("The method %s was not recongized by this javascript interface.", method);
        return null;
    }

    static {
        logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    }

    public static abstract class JavascriptMethodExecutor {
        private final String methodName;

        protected JavascriptMethodExecutor(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        protected abstract JSONObject execute(JSONObject var1);
    }

    public static class Executor {
        private final JavascriptInteractor interactor;
        private boolean proguardKeeper = false;

        public Executor(JavascriptInteractor interactor) {
            this.interactor = interactor;
            if (this.proguardKeeper) {
                this.execute(null, null);
            }
        }

        @JavascriptInterface
        public String execute(String method, String javascriptObjectParameters) {
            JSONObject returnJSON = this.interactor.execute(method, javascriptObjectParameters);
            return returnJSON == null ? null : returnJSON.toString();
        }
    }
}

