/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AppEvent;
import com.amazon.device.ads.DefaultFileHandlerFactory;
import com.amazon.device.ads.FileHandlerFactory;
import com.amazon.device.ads.FileInputHandler;
import com.amazon.device.ads.FileOutputHandler;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SISRegistration;
import com.amazon.device.ads.ThreadUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class AppEventRegistrationHandler {
    private static final String LOGTAG = AppEventRegistrationHandler.class.getSimpleName();
    protected static final String APP_EVENTS_FILE = "AppEventsJsonFile";
    protected static final String APP_EVENT_NAME_KEY = "evtName";
    protected static final String APP_EVENT_TIMESTAMP_KEY = "ts";
    protected static final long APP_EVENTS_FILE_MAX_SIZE = 0x100000L;
    protected static final String INSTALL_REFERRER_EVENT_NAME = "INSTALL_REFERRER";
    protected final Object appEventsFileLock;
    protected final Set<String> newEventsToSave;
    protected final Set<String> eventsSent;
    private final FileHandlerFactory fileHandlerFactory;
    private FileOutputHandler fileOutputHandler;
    private FileInputHandler fileInputHandler;
    private final MobileAdsInfoStore infoStore;
    private final MobileAdsLogger logger = new MobileAdsLoggerFactory().createMobileAdsLogger(LOGTAG);
    protected static AppEventRegistrationHandler instance = new AppEventRegistrationHandler(MobileAdsInfoStore.getInstance(), new DefaultFileHandlerFactory());

    protected AppEventRegistrationHandler(MobileAdsInfoStore infoStore, FileHandlerFactory fileHandlerFactory) {
        this.infoStore = infoStore;
        this.fileHandlerFactory = fileHandlerFactory;
        this.appEventsFileLock = new Object();
        this.newEventsToSave = Collections.synchronizedSet(new HashSet());
        this.eventsSent = Collections.synchronizedSet(new HashSet());
    }

    public static AppEventRegistrationHandler getInstance() {
        return instance;
    }

    public void addEventToAppEventsCacheFile(final AppEvent appEvent) {
        ThreadUtils.scheduleRunnable(new Runnable(){

            @Override
            public void run() {
                AppEventRegistrationHandler.this.appendAppEventToFile(appEvent);
                if (appEvent.getEventName().equals(AppEventRegistrationHandler.INSTALL_REFERRER_EVENT_NAME) && AppEventRegistrationHandler.this.infoStore.getRegistrationInfo().isRegisteredWithSIS()) {
                    SISRegistration sisRegistration = AppEventRegistrationHandler.this.infoStore.getSISRegistration();
                    sisRegistration.registerEvents();
                }
            }
        });
    }

    private boolean createFileOutputHandlerIfNeeded() {
        if (this.fileOutputHandler == null) {
            File fileDir = this.infoStore.getFilesDir();
            if (fileDir == null) {
                this.logger.e("No files directory has been set.");
                return false;
            }
            this.fileOutputHandler = this.fileHandlerFactory.createFileOutputHandler(fileDir, APP_EVENTS_FILE);
        }
        return this.fileOutputHandler != null;
    }

    private boolean createFileInputHandlerIfNeeded() {
        if (this.fileInputHandler == null) {
            File fileDir = this.infoStore.getFilesDir();
            if (fileDir == null) {
                this.logger.e("No files directory has been set.");
                return false;
            }
            this.fileInputHandler = this.fileHandlerFactory.createFileInputHandler(fileDir, APP_EVENTS_FILE);
        }
        return this.fileInputHandler != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void appendAppEventToFile(AppEvent appEvent) {
        if (!this.createFileOutputHandlerIfNeeded()) {
            this.logger.e("Error creating file output handler.");
            return;
        }
        JSONObject jsonEvent = new JSONObject();
        try {
            jsonEvent.put(APP_EVENT_NAME_KEY, (Object)appEvent.getEventName());
            jsonEvent.put(APP_EVENT_TIMESTAMP_KEY, appEvent.getTimestamp());
            for (Map.Entry<String, String> prop : appEvent.getPropertyEntries()) {
                jsonEvent.put(prop.getKey(), (Object)prop.getValue());
            }
        }
        catch (JSONException e) {
            this.logger.w("Internal error while persisting the application event %s.", appEvent.toString());
            return;
        }
        this.newEventsToSave.add(jsonEvent.toString());
        Object object = this.appEventsFileLock;
        synchronized (object) {
            String toAppend = jsonEvent.toString() + "\n";
            if (this.fileOutputHandler.getFileLength() + (long)toAppend.length() > 0x100000L) {
                this.logger.w("Couldn't write the application event %s to the cache file. Maximum size limit reached.", appEvent.toString());
                return;
            }
            if (this.fileOutputHandler.open(FileOutputHandler.WriteMethod.APPEND)) {
                try {
                    this.fileOutputHandler.write(toAppend);
                    this.logger.d("Added the application event %s to the cache file.", appEvent.toString());
                }
                catch (IOException e) {
                    this.logger.w("Couldn't write the application event %s to the file.", appEvent.toString());
                }
            }
            this.fileOutputHandler.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getAppEventsJSONArray() {
        if (!this.createFileInputHandlerIfNeeded()) {
            this.logger.e("Error creating file input handler.");
            return null;
        }
        Object object = this.appEventsFileLock;
        synchronized (object) {
            if (!this.fileInputHandler.doesFileExist()) {
                return null;
            }
            if (!this.fileInputHandler.open()) {
                this.logger.e("App Events File could not be opened.");
                return null;
            }
            JSONArray jsonArray = new JSONArray();
            String jsonEventString = null;
            while ((jsonEventString = this.fileInputHandler.readLine()) != null) {
                JSONObject jsonEventObject = JSONUtils.getJSONObjectFromString(jsonEventString);
                if (jsonEventObject == null) {
                    this.onAppEventsRegistered();
                    this.fileInputHandler.close();
                    return null;
                }
                jsonArray.put((Object)jsonEventObject);
                this.eventsSent.add(jsonEventObject.toString());
            }
            this.fileInputHandler.close();
            if (jsonArray.length() > 0) {
                return jsonArray;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAppEventsRegistered() {
        if (!this.createFileOutputHandlerIfNeeded()) {
            this.logger.e("Error creating file output handler.");
            return;
        }
        Object object = this.appEventsFileLock;
        synchronized (object) {
            this.newEventsToSave.removeAll(this.eventsSent);
            if (!this.newEventsToSave.isEmpty()) {
                StringBuilder toWrite = new StringBuilder();
                Set<String> set = this.newEventsToSave;
                synchronized (set) {
                    for (String newEvent : this.newEventsToSave) {
                        toWrite.append(newEvent).append("\n");
                    }
                }
                if (this.fileOutputHandler.open(FileOutputHandler.WriteMethod.APPEND)) {
                    try {
                        this.fileOutputHandler.write(toWrite.toString());
                        this.newEventsToSave.clear();
                        this.eventsSent.clear();
                    }
                    catch (IOException e) {
                        this.logger.w("Couldn't write the application event(s) to the file.");
                    }
                }
                this.fileOutputHandler.close();
            } else {
                Context appContext = this.infoStore.getApplicationContext();
                appContext.deleteFile(APP_EVENTS_FILE);
                this.eventsSent.clear();
            }
        }
    }
}

