/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdSize;

class AdControllerFactory {
    private static AdController cachedAdController = null;
    private static AdControlAccessor cachedAdControlAccessor = null;

    AdControllerFactory() {
    }

    public static void cacheAdController(AdController adController) {
        cachedAdController = adController;
    }

    public static void cacheAdControlAccessor(AdControlAccessor adControlAccessor) {
        cachedAdControlAccessor = adControlAccessor;
    }

    public static AdController getCachedAdController() {
        return cachedAdController;
    }

    public static AdControlAccessor getCachedAdControlAccessor() {
        return cachedAdControlAccessor;
    }

    public static AdController removeCachedAdController() {
        AdController currentAdController = cachedAdController;
        cachedAdController = null;
        return currentAdController;
    }

    public static AdControlAccessor removeCachedAdControlAccessor() {
        AdControlAccessor currenAdControlAccessor = cachedAdControlAccessor;
        cachedAdControlAccessor = null;
        return currenAdControlAccessor;
    }

    public AdController buildAdController(Context context, AdSize adSize) {
        AdController adController = null;
        try {
            adController = new AdController(context, adSize);
        }
        catch (IllegalStateException e) {
            return null;
        }
        return adController;
    }
}

