/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdState;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.SDKEvent;
import java.util.concurrent.atomic.AtomicBoolean;

class AdCloser {
    private static final String LOGTAG = AdCloser.class.getSimpleName();
    private final MobileAdsLogger logger;
    private final AtomicBoolean isClosing = new AtomicBoolean(false);
    private final AdController adController;

    public AdCloser(AdController adController) {
        this(adController, new MobileAdsLoggerFactory());
    }

    AdCloser(AdController adController, MobileAdsLoggerFactory loggerFactory) {
        this.adController = adController;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
    }

    public boolean closeAd() {
        this.logger.d("Ad is attempting to close.");
        boolean isClosed = false;
        if (!this.adController.getAdState().equals((Object)AdState.READY_TO_LOAD) && !this.isClosing.getAndSet(true)) {
            boolean shouldClearAdActivity = false;
            boolean fireCloseEvent = false;
            switch (this.adController.getAdControlCallback().adClosing()) {
                case 1: {
                    shouldClearAdActivity = true;
                    fireCloseEvent = true;
                    break;
                }
                case 0: {
                    fireCloseEvent = true;
                    break;
                }
            }
            if (fireCloseEvent) {
                this.adController.fireSDKEvent(new SDKEvent(SDKEvent.SDKEventType.CLOSED));
                isClosed = true;
            }
            if (shouldClearAdActivity) {
                this.adController.resetToReady();
            }
            this.isClosing.set(false);
        }
        return isClosed;
    }
}

