/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.MobileAdsInfoStore;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;

class WebViewFactory {
    private static WebViewFactory instance = new WebViewFactory();
    private final MobileAdsInfoStore infoStore;
    private final MobileAdsLoggerFactory loggerFactory;
    private final DebugProperties debugProperties;
    private final MobileAdsCookieManager cookieManager;
    private final WebViewConstructor webViewConstructor;
    private boolean webViewDebugging = false;

    protected WebViewFactory() {
        this(MobileAdsInfoStore.getInstance(), new MobileAdsLoggerFactory(), DebugProperties.getInstance(), new MobileAdsCookieManager(), new WebViewConstructor());
    }

    WebViewFactory(MobileAdsInfoStore infoStore, MobileAdsLoggerFactory loggerFactory, DebugProperties debugProperties, MobileAdsCookieManager cookieManager, WebViewConstructor webViewConstructor) {
        this.infoStore = infoStore;
        this.loggerFactory = loggerFactory;
        this.debugProperties = debugProperties;
        this.cookieManager = cookieManager;
        this.webViewConstructor = webViewConstructor;
    }

    public static final WebViewFactory getInstance() {
        return instance;
    }

    public synchronized WebView createWebView(Context context) {
        this.shouldDebugWebViews();
        Context applicationContext = context.getApplicationContext();
        WebView webView = this.webViewConstructor.createWebView(applicationContext);
        this.infoStore.getDeviceInfo().setUserAgentString(webView.getSettings().getUserAgentString());
        webView.getSettings().setUserAgentString(this.infoStore.getDeviceInfo().getUserAgentString());
        this.cookieManager.createCookieSyncManager(context);
        this.updateAdIdCookie();
        return webView;
    }

    private void updateAdIdCookie() {
        if (this.cookieManager.isCookieSyncManagerCreated()) {
            String adId = this.infoStore.getRegistrationInfo().getAdId();
            if (adId == null) {
                adId = "";
            }
            this.cookieManager.setCookie("http://amazon-adsystem.com", "ad-id=" + adId + "; Domain=.amazon-adsystem.com");
        }
    }

    public boolean isWebViewOk(Context context) {
        try {
            return WebViewDatabase.getInstance((Context)context) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public boolean setJavaScriptEnabledForWebView(boolean enable, WebView webView, String logtag) {
        try {
            webView.getSettings().setJavaScriptEnabled(enable);
        }
        catch (NullPointerException e) {
            MobileAdsLogger logger = this.loggerFactory.createMobileAdsLogger(logtag);
            logger.w("Could not set JavaScriptEnabled because a NullPointerException was encountered.");
            return false;
        }
        return true;
    }

    private void shouldDebugWebViews() {
        boolean webViewDebugging = this.debugProperties.getDebugPropertyAsBoolean("debug.webViews", this.webViewDebugging);
        if (webViewDebugging != this.webViewDebugging) {
            this.webViewDebugging = webViewDebugging;
            AndroidTargetUtils.enableWebViewDebugging(this.webViewDebugging);
        }
    }

    static class WebViewConstructor {
        WebViewConstructor() {
        }

        public WebView createWebView(Context context) {
            return new WebView(context);
        }
    }

    static class MobileAdsCookieManager {
        private boolean cookieSyncManagerCreated = false;

        MobileAdsCookieManager() {
        }

        public void createCookieSyncManager(Context context) {
            if (!this.cookieSyncManagerCreated) {
                CookieSyncManager.createInstance((Context)context);
                this.cookieSyncManagerCreated = true;
            }
        }

        public void setCookie(String url, String cookie) {
            CookieManager.getInstance().setCookie(url, cookie);
        }

        public boolean isCookieSyncManagerCreated() {
            return this.cookieSyncManagerCreated;
        }

        public void startSync() {
            CookieSyncManager.getInstance().startSync();
        }

        public void stopSync() {
            CookieSyncManager.getInstance().stopSync();
        }
    }
}

