/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.media.MediaScannerConnection;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.amazon.device.ads.AdActivity;
import com.amazon.device.ads.AdControlAccessor;
import com.amazon.device.ads.AdControllerFactory;
import com.amazon.device.ads.AdEvent;
import com.amazon.device.ads.AdSDKBridge;
import com.amazon.device.ads.AdUtils2;
import com.amazon.device.ads.AndroidBuildInfo;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.CalendarEventParameters;
import com.amazon.device.ads.DisplayUtils;
import com.amazon.device.ads.ExpandProperties;
import com.amazon.device.ads.ForceOrientation;
import com.amazon.device.ads.GraphicsUtils;
import com.amazon.device.ads.ImageResponseReader;
import com.amazon.device.ads.InAppBrowser;
import com.amazon.device.ads.IntentBuilder;
import com.amazon.device.ads.IntentBuilderFactory;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.JavascriptInteractor;
import com.amazon.device.ads.LayoutFactory;
import com.amazon.device.ads.MRAIDAdSDKEventListener;
import com.amazon.device.ads.MobileAdsLogger;
import com.amazon.device.ads.MobileAdsLoggerFactory;
import com.amazon.device.ads.ModalAdActivityAdapter;
import com.amazon.device.ads.OrientationProperties;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Position;
import com.amazon.device.ads.PreloadCallback;
import com.amazon.device.ads.RelativePosition;
import com.amazon.device.ads.ResizeProperties;
import com.amazon.device.ads.SDKEventListener;
import com.amazon.device.ads.Size;
import com.amazon.device.ads.StringUtils;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.VideoActionHandler;
import com.amazon.device.ads.ViewUtils;
import com.amazon.device.ads.WebRequest;
import com.amazon.device.ads.WebUtils;
import com.amazon.device.ads.WebUtils2;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

class MRAIDAdSDKBridge
implements AdSDKBridge {
    private static final String LOGTAG = MRAIDAdSDKBridge.class.getSimpleName();
    private static final String ERROR_EVENT_FORMAT = "mraidBridge.error('%s', '%s');";
    private static final String PLACEMENT_TYPE_INTERSTITIAL = "interstitial";
    private static final String PLACEMENT_TYPE_INLINE = "inline";
    private static final String MRAID_BRIDGE_NAME = "mraidObject";
    private static final int CLOSE_BUTTON_SIZE = 50;
    private static final String CONTENT_DESCRIPTION_RESIZED_VIEW = "resizedView";
    private static final String JAVASCRIPT = "(function (window, console) {\n    var is_array = function (obj) {\n        return Object.prototype.toString.call(obj) === '[object Array]';\n    },\n    registerViewabilityInterest = function(){\n       mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"RegisterViewabilityInterest\", null);\n    },\n    deregisterViewabilityInterest = function(){\n       mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"DeregisterViewabilityInterest\", null);\n    },\n    forEach = function (array, fn) {\n        var i;\n        for (i = 0; i < array.length; i++) {\n            if (i in array) {\n                fn.call(null, array[i], i);\n            }\n        }\n    },\n    events = {\n            error: 'error',\n            ready: 'ready',\n            sizeChange: 'sizeChange',\n            stateChange: 'stateChange',\n            viewableChange: 'viewableChange'\n    },\n    states = [\"loading\",\"default\",\"expanded\",\"resized\",\"hidden\"],\n    placementTypes = [\"inline\", \"interstitial\"],\n    listeners = [],\n    version = '2.0',\n    currentState = \"loading\",\n    currentlyViewable = false,\n    supportedFeatures = null,\n    orientationProperties = {\"allowOrientationChange\":true,\"forceOrientation\":\"none\"},\n    // Error Event fires listeners\n    invokeListeners = function(event, args) {\n        var eventListeners = listeners[event] || [];\n        // fire all the listeners\n        forEach(eventListeners, function(listener){\n            try {\n                listener.apply(null, args);\n            }catch(e){\n                debug(\"Error executing \" + event + \" listener\");\n                debug(e);\n            }\n        });\n    },\n    debug = function(msg) {\n        console.log(\"MRAID log: \" + msg);\n    },\n    readyEvent = function() {\n        debug(\"MRAID ready\");\n        invokeListeners(\"ready\");\n    },\n    errorEvent = function(message, action) {\n        debug(\"error: \" + message + \" action: \" + action);\n        var args = [message, action];\n        invokeListeners(\"error\", args);\n    },\n    stateChangeEvent = function(state) {\n        debug(\"stateChange: \" + state);\n        var args = [state];\n        currentState = state;\n        invokeListeners(\"stateChange\", args);\n    },\n    viewableChangeEvent = function(viewable) {\n        if (viewable != currentlyViewable) {            debug(\"viewableChange: \" + viewable);\n            var args = [viewable];\n            invokeListeners(\"viewableChange\", args);\n            currentlyViewable = viewable;\n        }\n    }, \n    sizeChangeEvent = function(width, height) {\n        debug(\"sizeChange: \" + width + \"x\" + height);\n        var args = [width, height];\n        invokeListeners(\"sizeChange\", args);\n    };\n    window.mraidBridge = {\n            error : errorEvent,\n            ready : readyEvent,\n            stateChange : stateChangeEvent,\n            sizeChange : sizeChangeEvent,\n            viewableChange : viewableChangeEvent\n    };\n    // Define the mraid object\n    window.mraid = {\n            // Command Flow\n            addEventListener : function(event, listener){\n                var eventListeners = listeners[event] || [],\n                alreadyRegistered = false;\n                \n                //verify the event is one that will actually occur\n                if (!events.hasOwnProperty(event)){\n                    return;\n                }\n                \n                //register first set of listeners for this event\n                if (!is_array(listeners[event])) {\n                    listeners[event] = eventListeners;\n                }\n                \n                forEach(eventListeners, function(l){ \n                    // Listener already registered, so no need to add it.\n                        if (listener === l){\n                            alreadyRegistered = true;\n                        }\n                    }\n                );\n                if (!alreadyRegistered){\n                    debug('Registering Listener for ' + event + ': ' + listener)\n                    listeners[event].push(listener);\n                    if (event = 'viewableChange'){ \n                       registerViewabilityInterest();  \n                    } \n                }\n            },\n            removeEventListener : function(event, listener){\n                if (listeners.hasOwnProperty(event)) {\n                    var eventListeners = listeners[event];\n                    if (eventListeners) {\n                        var idx = eventListeners.indexOf(listener);\n                        if (idx !== -1) {\n                           eventListeners.splice(idx, 1);\n                           if (event = 'viewableChange'){ \n                               deregisterViewabilityInterest();  \n                           } \n                        }\n                    }\n                }\n            },\n            useCustomClose: function(bool){\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"UseCustomClose\", JSON.stringify({useCustomClose: bool}));\n            },\n            // Support\n            supports: function(feature){\n                if (!supportedFeatures)\n                {\n                    supportedFeatures = JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Supports\", null));\n                }\n                return supportedFeatures[feature];\n            },\n            // Properties\n            getVersion: function(){\n                return version;\n            },\n            getState: function(){\n                return currentState;\n            },\n            getPlacementType: function(){\n                var json = JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetPlacementType\", null));\n                return json.placementType;\n            },\n            isViewable: function(){\n                var json = JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"IsViewable\", null));\n                return json.isViewable;\n            },\n            getExpandProperties: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetExpandProperties\", null));\n            },\n            setExpandProperties: function(properties){\n                //Backwards compatibility with MRAID 1.0 creatives\n                if (!!properties.lockOrientation){\n                    mraid.setOrientationProperties({\"allowOrientationChange\":false});\n                }\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"SetExpandProperties\", JSON.stringify(properties));\n            },\n            getOrientationProperties: function(){\n                return orientationProperties;\n            },\n            setOrientationProperties: function(properties){\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"SetOrientationProperties\", JSON.stringify(properties));\n            },\n            getResizeProperties: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetResizeProperties\", null));\n            },\n            setResizeProperties: function(properties){\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"SetResizeProperties\", JSON.stringify(properties));\n            },\n            getCurrentPosition: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetCurrentPosition\", null));\n            },\n            getMaxSize: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetMaxSize\", null));\n            },\n            getDefaultPosition: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetDefaultPosition\", null));\n            },\n            getScreenSize: function(){\n                return JSON.parse(mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"GetScreenSize\", null));\n            },\n            // Operations\n            open: function(url) {\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Open\", JSON.stringify({url: url}));\n            },\n            close: function() {\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Close\", null);\n            },\n            expand: function(url) {\n                if (url !== undefined) {\n                    mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Expand\", JSON.stringify({url: url}));\n                } else {\n                    mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Expand\", JSON.stringify({url: \"\"}));\n                }\n            },\n            resize: function() {\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"Resize\", null);\n            },\n            createCalendarEvent: function(eventObject) {\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"CreateCalendarEvent\", JSON.stringify(eventObject));\n            },\n            playVideo: function(url){\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"PlayVideo\", JSON.stringify({url: url}));\n            },\n            storePicture: function(url){\n                mraidObject." + JavascriptInteractor.getExecutorMethodName() + "(\"StorePicture\", JSON.stringify({url: url}));\n            }\n    };\n})(window, console);\n";
    private final MobileAdsLogger logger;
    private final PermissionChecker permissionChecker;
    private final WebRequest.WebRequestFactory webRequestFactory;
    private final AndroidBuildInfo buildInfo;
    private final OrientationProperties orientationProperties;
    private final ExpandProperties expandProperties;
    private final Position defaultPosition;
    private final ResizeProperties resizeProperties;
    private boolean expandedWithUrl = true;
    private SDKEventListener sdkEventListener;
    private final AdControlAccessor adControlAccessor;
    private final JavascriptInteractor javascriptInteractor;
    private final WebUtils2 webUtils;
    private final AdUtils2 adUtils;
    private final ThreadUtils.ThreadRunner threadRunner;
    private final GraphicsUtils graphicsUtils;
    private final AlertDialogFactory alertDialogFactory;
    private final IntentBuilderFactory intentBuilderFactory;
    private final LayoutFactory layoutFactory;
    private final ViewUtils viewUtils;
    private FrameLayout rootView;
    private ViewGroup resizedView;

    MRAIDAdSDKBridge(AdControlAccessor adControlAccessor, JavascriptInteractor javascriptInteractor) {
        this(adControlAccessor, javascriptInteractor, new PermissionChecker(), new MobileAdsLoggerFactory(), new WebRequest.WebRequestFactory(), ThreadUtils.getThreadRunner(), new GraphicsUtils(), new AlertDialogFactory(), new WebUtils2(), new AdUtils2(), new IntentBuilderFactory(), new ExpandProperties(), new OrientationProperties(), new Position(), new ResizeProperties(), new AndroidBuildInfo(), new LayoutFactory(), new ViewUtils());
    }

    MRAIDAdSDKBridge(AdControlAccessor adControlAccessor, JavascriptInteractor javascriptInteractor, PermissionChecker permissionChecker, MobileAdsLoggerFactory loggerFactory, WebRequest.WebRequestFactory webRequestFactory, ThreadUtils.ThreadRunner threadRunner, GraphicsUtils graphicsUtils, AlertDialogFactory alertDialogFactory, WebUtils2 webUtils, AdUtils2 adUtils, IntentBuilderFactory intentBuilderFactory, ExpandProperties expandProperties, OrientationProperties orientationProperties, Position defaultPosition, ResizeProperties resizeProperties, AndroidBuildInfo buildInfo, LayoutFactory layoutFactory, ViewUtils viewUtils) {
        this.adControlAccessor = adControlAccessor;
        this.javascriptInteractor = javascriptInteractor;
        this.logger = loggerFactory.createMobileAdsLogger(LOGTAG);
        this.permissionChecker = permissionChecker;
        this.webRequestFactory = webRequestFactory;
        this.threadRunner = threadRunner;
        this.graphicsUtils = graphicsUtils;
        this.alertDialogFactory = alertDialogFactory;
        this.webUtils = webUtils;
        this.adUtils = adUtils;
        this.intentBuilderFactory = intentBuilderFactory;
        this.expandProperties = expandProperties;
        this.orientationProperties = orientationProperties;
        this.defaultPosition = defaultPosition;
        this.resizeProperties = resizeProperties;
        this.buildInfo = buildInfo;
        this.layoutFactory = layoutFactory;
        this.viewUtils = viewUtils;
        this.populateJavascriptExecutorsInInteractor();
    }

    private void populateJavascriptExecutorsInInteractor() {
        this.javascriptInteractor.addMethodExecutor(new CloseJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new CreateCalendarEventJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new ExpandJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetCurrentPositionJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetDefaultPositionJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetExpandPropertiesJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetMaxSizeJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetPlacementTypeJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetResizePropertiesJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new GetScreenSizeJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new OpenJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new PlayVideoJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new ResizeJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new SetExpandPropertiesJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new SetOrientationPropertiesJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new SetResizePropertiesJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new StorePictureJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new SupportsJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new UseCustomCloseJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new IsViewableJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new RegisterViewabilityInterestJSIF(this));
        this.javascriptInteractor.addMethodExecutor(new DeregisterViewabilityInterestJSIF(this));
    }

    @Override
    public boolean hasNativeExecution() {
        return true;
    }

    @Override
    public JavascriptInteractor.Executor getJavascriptInteractorExecutor() {
        return this.javascriptInteractor.getExecutor();
    }

    @Override
    public String getName() {
        return MRAID_BRIDGE_NAME;
    }

    @Override
    public String getJavascript() {
        return JAVASCRIPT;
    }

    @Override
    public SDKEventListener getSDKEventListener() {
        if (this.sdkEventListener == null) {
            this.sdkEventListener = new MRAIDAdSDKEventListener(this);
        }
        return this.sdkEventListener;
    }

    private Context getContext() {
        return this.adControlAccessor.getContext();
    }

    void updateDefaultPosition(int width, int height, int offsetX, int offsetY) {
        this.defaultPosition.setSize(new Size(width, height));
        this.defaultPosition.setX(offsetX);
        this.defaultPosition.setY(offsetY);
    }

    public JSONObject getCurrentPosition() {
        Position currentPosition = this.adControlAccessor.getCurrentPosition();
        if (currentPosition == null) {
            this.fireErrorEvent("Current position is unavailable because the ad has not yet been displayed.", "getCurrentPosition");
            return new Position(new Size(0, 0), 0, 0).toJSONObject();
        }
        return this.adControlAccessor.getCurrentPosition().toJSONObject();
    }

    public JSONObject getDefaultPosition() {
        return this.defaultPosition.toJSONObject();
    }

    public JSONObject getMaxSize() {
        Size maxSize = this.adControlAccessor.getMaxSize();
        if (maxSize == null) {
            return new Size(0, 0).toJSONObject();
        }
        return maxSize.toJSONObject();
    }

    public JSONObject getScreenSize() {
        Size screenSize = this.adControlAccessor.getScreenSize();
        if (screenSize == null) {
            return new Size(0, 0).toJSONObject();
        }
        return screenSize.toJSONObject();
    }

    public String getPlacementType() {
        if (this.adControlAccessor.isInterstitial()) {
            return PLACEMENT_TYPE_INTERSTITIAL;
        }
        return PLACEMENT_TYPE_INLINE;
    }

    public String getOrientationProperties() {
        return this.orientationProperties.toString();
    }

    public void setOrientationProperties(JSONObject json) {
        if (this.adControlAccessor.isInterstitial() && !this.adControlAccessor.isModal()) {
            this.adControlAccessor.orientationChangeAttemptedWhenNotAllowed();
        }
        this.orientationProperties.fromJSONObject(json);
        this.orientationPropertyChange();
    }

    public JSONObject getExpandPropertiesForCreative() {
        ExpandProperties expandProperties = this.expandProperties.toClone();
        Size screenSize = null;
        if (expandProperties.getWidth() == -1) {
            screenSize = this.adControlAccessor.getScreenSize();
            expandProperties.setWidth(screenSize.getWidth());
        }
        if (expandProperties.getHeight() == -1) {
            if (screenSize == null) {
                screenSize = this.adControlAccessor.getScreenSize();
            }
            expandProperties.setHeight(screenSize.getHeight());
        }
        return expandProperties.toJSONObject();
    }

    public void setExpandProperties(JSONObject json) {
        this.expandProperties.fromJSONObject(json);
        this.showNativeCloseButtonIfNeeded();
    }

    public JSONObject getResizeProperties() {
        return this.resizeProperties.toJSONObject();
    }

    public void setResizeProperties(JSONObject json) {
        if (!this.resizeProperties.fromJSONObject(json)) {
            this.fireErrorEvent("Invalid resize properties", "setResizeProperties");
        } else if (this.resizeProperties.getWidth() < 50 || this.resizeProperties.getHeight() < 50) {
            this.fireErrorEvent("Resize properties width and height must be greater than 50dp in order to fit the close button.", "setResizeProperties");
            this.resizeProperties.reset();
        } else {
            Size maxSize = this.adControlAccessor.getMaxSize();
            if (this.resizeProperties.getWidth() > maxSize.getWidth() || this.resizeProperties.getHeight() > maxSize.getHeight()) {
                this.fireErrorEvent("Resize properties width and height cannot be larger than the maximum size.", "setResizeProperties");
                this.resizeProperties.reset();
            } else if (this.resizeProperties.getAllowOffscreen()) {
                int maxHeight;
                int maxWidth;
                Size resizeSize = this.computeResizeSizeInPixels(this.resizeProperties);
                int leftMargin = this.adUtils.deviceIndependentPixelToPixel(this.defaultPosition.getX() + this.resizeProperties.getOffsetX());
                int topMargin = this.adUtils.deviceIndependentPixelToPixel(this.defaultPosition.getY() + this.resizeProperties.getOffsetY());
                RelativePosition closePosition = RelativePosition.fromString(this.resizeProperties.getCustomClosePosition());
                if (!this.isValidClosePosition(closePosition, topMargin, leftMargin, resizeSize, maxWidth = this.adUtils.deviceIndependentPixelToPixel(maxSize.getWidth()), maxHeight = this.adUtils.deviceIndependentPixelToPixel(maxSize.getHeight()))) {
                    this.fireErrorEvent("Invalid resize properties. Close event area must be entirely on screen.", "setResizeProperties");
                    this.resizeProperties.reset();
                }
            }
        }
    }

    public void setUseCustomClose(boolean useCustomClose) {
        this.expandProperties.setUseCustomClose(useCustomClose);
        this.showNativeCloseButtonIfNeeded();
    }

    private void showNativeCloseButtonIfNeeded() {
        if (this.adControlAccessor.isModal()) {
            this.adControlAccessor.showNativeCloseButtonImage(this.expandProperties.getUseCustomClose() == false);
        }
    }

    public void close() {
        if (!this.adControlAccessor.closeAd()) {
            this.fireErrorEvent("Unable to close ad in its current state.", "close");
        }
    }

    private AdControlAccessor getAdControlAccessor() {
        return this.adControlAccessor;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void expand(String url) {
        if (this.adControlAccessor.isInterstitial()) {
            this.fireErrorEvent("Unable to expand an interstitial ad placement", "expand");
            return;
        }
        if (this.adControlAccessor.isModal()) {
            this.fireErrorEvent("Unable to expand while expanded.", "expand");
            return;
        }
        if (!this.adControlAccessor.isVisible()) {
            this.fireErrorEvent("Unable to expand ad while it is not visible.", "expand");
            return;
        }
        if (this.expandProperties.getWidth() < 50 && this.expandProperties.getWidth() != -1 || this.expandProperties.getHeight() < 50 && this.expandProperties.getHeight() != -1) {
            this.fireErrorEvent("Expand size is too small, must leave room for close.", "expand");
            return;
        }
        if (StringUtils.isNullOrWhiteSpace(url)) {
            AdControllerFactory.cacheAdControlAccessor(this.adControlAccessor);
            this.launchExpandActivity(null, this.expandProperties);
            return;
        }
        if (this.webUtils.isUrlValid(url)) {
            final ExpandProperties expandProperties = this.expandProperties.toClone();
            this.adControlAccessor.preloadUrl(url, new PreloadCallback(){

                @Override
                public void onPreloadComplete(String url) {
                    MRAIDAdSDKBridge.this.getAdControlAccessor().injectJavascriptPreload("mraidBridge.stateChange('expanded');");
                    MRAIDAdSDKBridge.this.getAdControlAccessor().injectJavascriptPreload("mraidBridge.ready();");
                    AdControllerFactory.cacheAdControlAccessor(MRAIDAdSDKBridge.this.getAdControlAccessor());
                    MRAIDAdSDKBridge.this.launchExpandActivity(url, expandProperties);
                }
            });
            return;
        }
        this.fireErrorEvent("Unable to expand with invalid URL.", "expand");
    }

    private void launchExpandActivity(String url, ExpandProperties expandProperties) {
        IntentBuilder intentBuilder = this.intentBuilderFactory.createIntentBuilder();
        boolean isSuccess = intentBuilder.withClass(AdActivity.class).withContext(this.adControlAccessor.getContext().getApplicationContext()).withExtra("adapter", ModalAdActivityAdapter.class.getName()).withExtra("url", url).withExtra("expandProperties", expandProperties.toString()).withExtra("orientationProperties", this.orientationProperties.toString()).fireIntent();
        if (isSuccess) {
            this.logger.d("Successfully expanded ad");
        }
    }

    public void resize() {
        if (this.adControlAccessor.isInterstitial()) {
            this.fireErrorEvent("Unable to resize an interstitial ad placement.", "resize");
            return;
        }
        if (this.adControlAccessor.isModal()) {
            this.fireErrorEvent("Unable to resize while expanded.", "resize");
            return;
        }
        if (!this.adControlAccessor.isVisible()) {
            this.fireErrorEvent("Unable to resize ad while it is not visible.", "resize");
            return;
        }
        if (this.resizeProperties == null || !this.resizeProperties.areResizePropertiesSet()) {
            this.fireErrorEvent("Resize properties must be set before calling resize.", "resize");
            return;
        }
        this.resizeAd(this.resizeProperties);
    }

    public void playVideo(String url) {
        if (!this.adControlAccessor.isVisible()) {
            this.fireErrorEvent("Unable to play a video while the ad is not visible", "playVideo");
            return;
        }
        if (StringUtils.isNullOrEmpty(url)) {
            this.fireErrorEvent("Unable to play a video without a URL", "playVideo");
            return;
        }
        try {
            Bundle data = new Bundle();
            data.putString("url", url);
            Intent intent = new Intent(this.getContext(), AdActivity.class);
            intent.putExtra("adapter", VideoActionHandler.class.getName());
            intent.putExtras(data);
            this.getContext().startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            this.logger.d("Failed to open VideoAction activity");
            this.fireErrorEvent("Internal SDK Failure. Unable to launch VideoActionHandler", "playVideo");
        }
    }

    public void open(String url) {
        if (!this.adControlAccessor.isVisible()) {
            this.fireErrorEvent("Unable to open a URL while the ad is not visible", "open");
            return;
        }
        this.logger.d("Opening URL " + url);
        if (this.webUtils.isUrlValid(url)) {
            String scheme = WebUtils.getScheme(url);
            if ("http".equals(scheme) || "https".equals(scheme)) {
                new InAppBrowser.InAppBrowserBuilder().withContext(this.getContext()).withExternalBrowserButton().withUrl(url).show();
            } else {
                this.adControlAccessor.loadUrl(url);
            }
        } else {
            String message = "URL " + url + " is not a valid URL";
            this.logger.d(message);
            this.fireErrorEvent(message, "open");
        }
    }

    public JSONObject getSupportedFeatures() {
        JSONObject json = new JSONObject();
        try {
            boolean canSms = this.getContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
            json.put("sms", canSms);
            boolean canTel = this.getContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
            json.put("tel", canTel);
            boolean canCalendar = AndroidTargetUtils.isAtLeastAndroidAPI(14);
            json.put("calendar", canCalendar);
            boolean canStorePicture = this.permissionChecker.hasWriteExternalStoragePermission(this.getContext());
            json.put("storePicture", canStorePicture);
            boolean canInlineVideo = AndroidTargetUtils.isAtLeastAndroidAPI(11);
            json.put("inlineVideo", canInlineVideo);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    public void createCalendarEvent(String description, String location, String summary, String start, String end) {
        if (!AndroidTargetUtils.isAtLeastAndroidAPI(14)) {
            String message = "API version does not support calendar operations.";
            this.logger.d("API version does not support calendar operations.");
            this.fireErrorEvent("API version does not support calendar operations.", "createCalendarEvent");
            return;
        }
        CalendarEventParameters parameters = null;
        try {
            parameters = new CalendarEventParameters(description, location, summary, start, end);
        }
        catch (IllegalArgumentException e) {
            this.logger.d(e.getMessage());
            this.fireErrorEvent(e.getMessage(), "createCalendarEvent");
            return;
        }
        this.createCalendarIntent(parameters);
    }

    @TargetApi(value=14)
    private void createCalendarIntent(CalendarEventParameters parameters) {
        Intent calendarIntent = new Intent("android.intent.action.INSERT").setType("vnd.android.cursor.item/event");
        calendarIntent.putExtra("title", parameters.getDescription());
        if (!StringUtils.isNullOrEmpty(parameters.getLocation())) {
            calendarIntent.putExtra("eventLocation", parameters.getLocation());
        }
        if (!StringUtils.isNullOrEmpty(parameters.getSummary())) {
            calendarIntent.putExtra("description", parameters.getSummary());
        }
        calendarIntent.putExtra("beginTime", parameters.getStart().getTime());
        if (parameters.getEnd() != null) {
            calendarIntent.putExtra("endTime", parameters.getEnd().getTime());
        }
        this.getContext().startActivity(calendarIntent);
    }

    public void storePicture(final String url) {
        if (!this.permissionChecker.hasWriteExternalStoragePermission(this.getContext())) {
            this.fireErrorEvent("Picture could not be stored because permission was denied.", "storePicture");
            return;
        }
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                MRAIDAdSDKBridge.this.fetchPicture(url);
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.BACKGROUND_THREAD);
    }

    private void fetchPicture(String url) {
        WebRequest.WebResponse response;
        WebRequest webRequest = this.webRequestFactory.createWebRequest();
        webRequest.enableLog(true);
        webRequest.setUrlString(url);
        try {
            response = webRequest.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            this.fireErrorEvent("Server could not be contacted to download picture.", "storePicture");
            return;
        }
        if (response == null) {
            this.fireErrorEvent("Server could not be contacted to download picture.", "storePicture");
            return;
        }
        final Bitmap bitmap = new ImageResponseReader(response.getResponseReader(), this.graphicsUtils).readAsBitmap();
        if (bitmap == null) {
            this.fireErrorEvent("Picture could not be retrieved from server.", "storePicture");
            return;
        }
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                MRAIDAdSDKBridge.this.savePicture(bitmap);
            }
        }, ThreadUtils.ExecutionStyle.SCHEDULE, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    private void savePicture(final Bitmap bitmap) {
        AlertDialog.Builder alert = this.alertDialogFactory.createBuilder(this.getContext());
        alert.setTitle((CharSequence)"Would you like to save the image to your gallery?");
        alert.setPositiveButton((CharSequence)"Yes", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String insertUrl = MRAIDAdSDKBridge.this.graphicsUtils.insertImageInMediaStore(MRAIDAdSDKBridge.this.getContext(), bitmap, "AdImage", "Image created by rich media ad.");
                if (StringUtils.isNullOrEmpty(insertUrl)) {
                    MRAIDAdSDKBridge.this.fireErrorEvent("Picture could not be stored to device.", "storePicture");
                    return;
                }
                MediaScannerConnection.scanFile((Context)MRAIDAdSDKBridge.this.getContext(), (String[])new String[]{insertUrl}, null, null);
            }
        });
        alert.setNegativeButton((CharSequence)"No", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MRAIDAdSDKBridge.this.fireErrorEvent("User chose not to store image.", "storePicture");
            }
        });
        alert.show();
    }

    void collapseExpandedAd(final AdControlAccessor adControlAccessor) {
        this.logger.d("Collapsing expanded ad " + this);
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                MRAIDAdSDKBridge.this.collapseExpandedAdOnThread(adControlAccessor);
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    @SuppressLint(value={"InlinedApi"})
    private void collapseExpandedAdOnThread(final AdControlAccessor adControlAccessor) {
        adControlAccessor.setAdActivity(null);
        if (this.expandedWithUrl) {
            this.logger.d("Expanded With URL");
            adControlAccessor.popView();
        } else {
            this.logger.d("Not Expanded with URL");
        }
        FrameLayout.LayoutParams layoutParams2 = new FrameLayout.LayoutParams(-1, -1, 17);
        adControlAccessor.moveViewBackToParent((ViewGroup.LayoutParams)layoutParams2);
        adControlAccessor.removeCloseButton();
        adControlAccessor.fireAdEvent(new AdEvent(AdEvent.AdEventType.CLOSED));
        adControlAccessor.injectJavascript("mraidBridge.stateChange('default');");
        adControlAccessor.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                adControlAccessor.removeOnGlobalLayoutListener(this);
                MRAIDAdSDKBridge.this.reportSizeChangeEvent();
            }
        });
    }

    void resizeAd(final ResizeProperties resizeProperties) {
        final Size resizeSize = this.computeResizeSizeInPixels(resizeProperties);
        this.threadRunner.execute(new Runnable(){

            @Override
            public void run() {
                MRAIDAdSDKBridge.this.resizeAdOnThread(resizeProperties, resizeSize);
            }
        }, ThreadUtils.ExecutionStyle.RUN_ASAP, ThreadUtils.ExecutionThread.MAIN_THREAD);
    }

    private void resizeAdOnThread(final ResizeProperties resizeProperties, final Size resizeSize) {
        Size maxSize = this.adControlAccessor.getMaxSize();
        if (maxSize == null) {
            this.adControlAccessor.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    MRAIDAdSDKBridge.this.adControlAccessor.removeOnGlobalLayoutListener(this);
                    Size maxSize = MRAIDAdSDKBridge.this.adControlAccessor.getMaxSize();
                    MRAIDAdSDKBridge.this.resizeAdHelper(resizeProperties, resizeSize, maxSize);
                }
            });
        } else {
            this.resizeAdHelper(resizeProperties, resizeSize, maxSize);
        }
    }

    private void resizeAdHelper(ResizeProperties resizeProperties, Size resizeSize, Size maxSize) {
        if (maxSize == null) {
            this.logger.d("Size is null");
            return;
        }
        this.createResizedView();
        int leftMargin = this.adUtils.deviceIndependentPixelToPixel(this.defaultPosition.getX() + resizeProperties.getOffsetX());
        int topMargin = this.adUtils.deviceIndependentPixelToPixel(this.defaultPosition.getY() + resizeProperties.getOffsetY());
        RelativePosition closePosition = RelativePosition.fromString(resizeProperties.getCustomClosePosition());
        int maxWidth = this.adUtils.deviceIndependentPixelToPixel(maxSize.getWidth());
        int maxHeight = this.adUtils.deviceIndependentPixelToPixel(maxSize.getHeight());
        if (!resizeProperties.getAllowOffscreen()) {
            if (resizeSize.getWidth() > maxWidth) {
                resizeSize.setWidth(maxWidth);
            }
            if (resizeSize.getHeight() > maxHeight) {
                resizeSize.setHeight(maxHeight);
            }
            if (leftMargin < 0) {
                leftMargin = 0;
            } else if (leftMargin + resizeSize.getWidth() > maxWidth) {
                leftMargin = maxWidth - resizeSize.getWidth();
            }
            if (topMargin < 0) {
                topMargin = 0;
            } else if (topMargin + resizeSize.getHeight() > maxHeight) {
                topMargin = maxHeight - resizeSize.getHeight();
            }
        } else if (!this.isValidClosePosition(closePosition, topMargin, leftMargin, resizeSize, maxWidth, maxHeight)) {
            this.fireErrorEvent("Resize failed because close event area must be entirely on screen.", "resize");
            return;
        }
        RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(resizeSize.getWidth(), resizeSize.getHeight());
        this.adControlAccessor.moveViewToViewGroup(this.resizedView, (ViewGroup.LayoutParams)lp, false);
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(resizeSize.getWidth(), resizeSize.getHeight());
        params.gravity = 48;
        params.leftMargin = leftMargin;
        params.topMargin = topMargin;
        if (this.rootView.equals(this.resizedView.getParent())) {
            this.resizedView.setLayoutParams((ViewGroup.LayoutParams)params);
        } else {
            this.rootView.addView((View)this.resizedView, (ViewGroup.LayoutParams)params);
        }
        this.adControlAccessor.enableCloseButton(false, closePosition);
        final ViewTreeObserver vto = this.resizedView.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                MRAIDAdSDKBridge.this.viewUtils.removeOnGlobalLayoutListener(vto, this);
                int[] onScreen = new int[2];
                MRAIDAdSDKBridge.this.resizedView.getLocationOnScreen(onScreen);
                Rect positionOnScreen = new Rect(onScreen[0], onScreen[1], onScreen[0] + MRAIDAdSDKBridge.this.resizedView.getWidth(), onScreen[1] + MRAIDAdSDKBridge.this.resizedView.getHeight());
                AdEvent adEvent = new AdEvent(AdEvent.AdEventType.RESIZED);
                adEvent.setParameter("positionOnScreen", positionOnScreen);
                MRAIDAdSDKBridge.this.adControlAccessor.fireAdEvent(adEvent);
                MRAIDAdSDKBridge.this.adControlAccessor.injectJavascript("mraidBridge.stateChange('resized');");
                MRAIDAdSDKBridge.this.reportSizeChangeEvent();
            }
        });
    }

    private boolean isViewable() {
        return this.adControlAccessor.isViewable();
    }

    private boolean isValidClosePosition(RelativePosition closePosition, int topMargin, int leftMargin, Size resizeSize, int maxWidth, int maxHeight) {
        int closeButtonSize = this.adUtils.deviceIndependentPixelToPixel(50);
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        switch (closePosition) {
            case TOP_LEFT: {
                top = topMargin;
                left = leftMargin;
                bottom = top + closeButtonSize;
                right = left + closeButtonSize;
                break;
            }
            case TOP_RIGHT: {
                top = topMargin;
                right = leftMargin + resizeSize.getWidth();
                bottom = top + closeButtonSize;
                left = right - closeButtonSize;
                break;
            }
            case TOP_CENTER: {
                top = topMargin;
                left = resizeSize.getWidth() / 2 + leftMargin - closeButtonSize / 2;
                bottom = top + closeButtonSize;
                right = left + closeButtonSize;
                break;
            }
            case BOTTOM_LEFT: {
                bottom = topMargin + resizeSize.getHeight();
                left = leftMargin;
                top = bottom - closeButtonSize;
                right = left + closeButtonSize;
                break;
            }
            case BOTTOM_RIGHT: {
                bottom = topMargin + resizeSize.getHeight();
                right = leftMargin + resizeSize.getWidth();
                top = bottom - closeButtonSize;
                left = right - closeButtonSize;
                break;
            }
            case BOTTOM_CENTER: {
                bottom = topMargin + resizeSize.getHeight();
                left = resizeSize.getWidth() / 2 + leftMargin - closeButtonSize / 2;
                top = bottom - closeButtonSize;
                right = left + closeButtonSize;
                break;
            }
            case CENTER: {
                top = resizeSize.getHeight() / 2 + topMargin - closeButtonSize / 2;
                left = resizeSize.getWidth() / 2 + leftMargin - closeButtonSize / 2;
                bottom = top + closeButtonSize;
                right = left + closeButtonSize;
            }
        }
        return top >= 0 && left >= 0 && bottom <= maxHeight && right <= maxWidth;
    }

    private Size computeResizeSizeInPixels(ResizeProperties resizeProperties) {
        int widthToCompute = resizeProperties.getWidth();
        int heightToCompute = resizeProperties.getHeight();
        int pixelWidth = this.adUtils.deviceIndependentPixelToPixel(widthToCompute);
        int pixelHeight = this.adUtils.deviceIndependentPixelToPixel(heightToCompute);
        return new Size(pixelWidth, pixelHeight);
    }

    private void createResizedView() {
        if (this.resizedView == null) {
            if (this.rootView == null) {
                this.rootView = (FrameLayout)this.adControlAccessor.getRootView();
            }
            this.resizedView = this.layoutFactory.createLayout(this.getContext(), LayoutFactory.LayoutType.RELATIVE_LAYOUT, CONTENT_DESCRIPTION_RESIZED_VIEW);
        }
    }

    void reportSizeChangeEvent() {
        Position currentPosition = this.adControlAccessor.getCurrentPosition();
        if (currentPosition != null) {
            this.adControlAccessor.injectJavascript("mraidBridge.sizeChange(" + currentPosition.getSize().getWidth() + "," + currentPosition.getSize().getHeight() + ");");
        }
    }

    void orientationPropertyChange() {
        if (!this.adControlAccessor.isVisible() || !this.adControlAccessor.isModal()) {
            return;
        }
        Activity activity = this.adControlAccessor.getAdActivity();
        if (activity == null) {
            this.logger.e("unable to handle orientation property change on a non-expanded ad");
            return;
        }
        int originalOrientation = activity.getRequestedOrientation();
        Position currentPosition = this.adControlAccessor.getCurrentPosition();
        this.logger.d("Current Orientation: " + originalOrientation);
        switch (this.orientationProperties.getForceOrientation()) {
            case PORTRAIT: {
                activity.setRequestedOrientation(7);
                break;
            }
            case LANDSCAPE: {
                activity.setRequestedOrientation(6);
                break;
            }
        }
        if (ForceOrientation.NONE.equals((Object)this.orientationProperties.getForceOrientation())) {
            if (this.orientationProperties.isAllowOrientationChange().booleanValue()) {
                int currentOrientation = activity.getRequestedOrientation();
                if (currentOrientation != -1) {
                    activity.setRequestedOrientation(-1);
                }
            } else if (this.adControlAccessor.isModal()) {
                activity.setRequestedOrientation(DisplayUtils.determineCanonicalScreenOrientation((Context)activity, this.buildInfo));
            }
        }
        int newOrientation = activity.getRequestedOrientation();
        this.logger.d("New Orientation: " + newOrientation);
        if (newOrientation != originalOrientation && currentPosition != null) {
            Position newPosition = this.adControlAccessor.getCurrentPosition();
            if (currentPosition.getSize().getWidth() != newPosition.getSize().getWidth()) {
                this.adControlAccessor.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

                    public void onGlobalLayout() {
                        MRAIDAdSDKBridge.this.adControlAccessor.removeOnGlobalLayoutListener(this);
                        MRAIDAdSDKBridge.this.reportSizeChangeEvent();
                    }
                });
            }
        }
    }

    private void registerViewabilityInterest() {
        this.adControlAccessor.registerViewabilityInterest();
    }

    private void deregisterViewabilityInterest() {
        this.adControlAccessor.deregisterViewabilityInterest();
    }

    private void fireErrorEvent(String message, String action) {
        this.adControlAccessor.injectJavascript(String.format(Locale.US, ERROR_EVENT_FORMAT, message, action));
    }

    static class AlertDialogFactory {
        AlertDialogFactory() {
        }

        public AlertDialog.Builder createBuilder(Context context) {
            return new AlertDialog.Builder(context);
        }
    }

    private static class DeregisterViewabilityInterestJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "DeregisterViewabilityInterest";
        private final MRAIDAdSDKBridge bridge;

        public DeregisterViewabilityInterestJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        protected JSONObject execute(JSONObject parameters) {
            this.bridge.deregisterViewabilityInterest();
            return null;
        }
    }

    private static class RegisterViewabilityInterestJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "RegisterViewabilityInterest";
        private final MRAIDAdSDKBridge bridge;

        public RegisterViewabilityInterestJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        protected JSONObject execute(JSONObject parameters) {
            this.bridge.registerViewabilityInterest();
            return null;
        }
    }

    private static class StorePictureJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "StorePicture";
        private final MRAIDAdSDKBridge bridge;

        public StorePictureJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.storePicture(JSONUtils.getStringFromJSON(parameters, "url", null));
            return null;
        }
    }

    private static class CreateCalendarEventJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "CreateCalendarEvent";
        private final MRAIDAdSDKBridge bridge;

        public CreateCalendarEventJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.createCalendarEvent(JSONUtils.getStringFromJSON(parameters, "description", null), JSONUtils.getStringFromJSON(parameters, "location", null), JSONUtils.getStringFromJSON(parameters, "summary", null), JSONUtils.getStringFromJSON(parameters, "start", null), JSONUtils.getStringFromJSON(parameters, "end", null));
            return null;
        }
    }

    private static class SupportsJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "Supports";
        private final MRAIDAdSDKBridge bridge;

        public SupportsJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getSupportedFeatures();
        }
    }

    private static class OpenJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "Open";
        private final MRAIDAdSDKBridge bridge;

        public OpenJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.open(JSONUtils.getStringFromJSON(parameters, "url", null));
            return null;
        }
    }

    private static class PlayVideoJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "PlayVideo";
        private final MRAIDAdSDKBridge bridge;

        public PlayVideoJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.playVideo(JSONUtils.getStringFromJSON(parameters, "url", null));
            return null;
        }
    }

    private static class ResizeJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "Resize";
        private final MRAIDAdSDKBridge bridge;

        public ResizeJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.resize();
            return null;
        }
    }

    private static class ExpandJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "Expand";
        private final MRAIDAdSDKBridge bridge;

        public ExpandJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.expand(JSONUtils.getStringFromJSON(parameters, "url", null));
            return null;
        }
    }

    private static class CloseJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "Close";
        private final MRAIDAdSDKBridge bridge;

        public CloseJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.close();
            return null;
        }
    }

    private static class IsViewableJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "IsViewable";
        private final MRAIDAdSDKBridge bridge;

        public IsViewableJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            JSONObject json = new JSONObject();
            JSONUtils.put(json, "isViewable", this.bridge.isViewable());
            return json;
        }
    }

    private static class UseCustomCloseJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "UseCustomClose";
        private final MRAIDAdSDKBridge bridge;

        public UseCustomCloseJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.setUseCustomClose(JSONUtils.getBooleanFromJSON(parameters, "useCustomClose", false));
            return null;
        }
    }

    private static class SetResizePropertiesJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "SetResizeProperties";
        private final MRAIDAdSDKBridge bridge;

        public SetResizePropertiesJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.setResizeProperties(parameters);
            return null;
        }
    }

    private static class GetResizePropertiesJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetResizeProperties";
        private final MRAIDAdSDKBridge bridge;

        public GetResizePropertiesJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getResizeProperties();
        }
    }

    private static class SetExpandPropertiesJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "SetExpandProperties";
        private final MRAIDAdSDKBridge bridge;

        public SetExpandPropertiesJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.setExpandProperties(parameters);
            return null;
        }
    }

    private static class GetExpandPropertiesJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetExpandProperties";
        private final MRAIDAdSDKBridge bridge;

        public GetExpandPropertiesJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getExpandPropertiesForCreative();
        }
    }

    private static class SetOrientationPropertiesJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "SetOrientationProperties";
        private final MRAIDAdSDKBridge bridge;

        public SetOrientationPropertiesJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            this.bridge.setOrientationProperties(parameters);
            return null;
        }
    }

    private static class GetPlacementTypeJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetPlacementType";
        private final MRAIDAdSDKBridge bridge;

        public GetPlacementTypeJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            JSONObject json = new JSONObject();
            JSONUtils.put(json, "placementType", this.bridge.getPlacementType());
            return json;
        }
    }

    private static class GetScreenSizeJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetScreenSize";
        private final MRAIDAdSDKBridge bridge;

        public GetScreenSizeJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getScreenSize();
        }
    }

    private static class GetMaxSizeJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetMaxSize";
        private final MRAIDAdSDKBridge bridge;

        public GetMaxSizeJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getMaxSize();
        }
    }

    private static class GetDefaultPositionJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetDefaultPosition";
        private final MRAIDAdSDKBridge bridge;

        public GetDefaultPositionJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getDefaultPosition();
        }
    }

    private static class GetCurrentPositionJSIF
    extends JavascriptInteractor.JavascriptMethodExecutor {
        private static final String name = "GetCurrentPosition";
        private final MRAIDAdSDKBridge bridge;

        public GetCurrentPositionJSIF(MRAIDAdSDKBridge bridge) {
            super(name);
            this.bridge = bridge;
        }

        @Override
        public JSONObject execute(JSONObject parameters) {
            return this.bridge.getCurrentPosition();
        }
    }
}

