/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.JSONUtils;
import org.json.JSONObject;

class ResizeProperties {
    private static final String CUSTOM_CLOSE_POSITION_DEFAULT = "top-right";
    private static final boolean ALLOW_OFFSCREEN_DEFAULT = true;
    public static final int DIMENSION_NOT_SET = -1;
    private final JSONUtils.JSONUtilities jsonUtils;
    private int width = -1;
    private int height = -1;
    private int offsetX = -1;
    private int offsetY = -1;
    private String customClosePosition = "top-right";
    private boolean allowOffscreen = true;

    public ResizeProperties() {
        this(new JSONUtils.JSONUtilities());
    }

    ResizeProperties(JSONUtils.JSONUtilities jsonUtils) {
        this.jsonUtils = jsonUtils;
    }

    public void reset() {
        this.width = -1;
        this.height = -1;
        this.offsetX = -1;
        this.offsetY = -1;
        this.customClosePosition = CUSTOM_CLOSE_POSITION_DEFAULT;
        this.allowOffscreen = true;
    }

    public boolean areResizePropertiesSet() {
        return this.width != -1 && this.height != -1 && this.offsetX != -1 && this.offsetY != -1;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public String getCustomClosePosition() {
        return this.customClosePosition;
    }

    public boolean getAllowOffscreen() {
        return this.allowOffscreen;
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        this.setDimensionIfSet(json, "width", this.width);
        this.setDimensionIfSet(json, "height", this.height);
        this.setDimensionIfSet(json, "offsetX", this.offsetX);
        this.setDimensionIfSet(json, "offsetY", this.offsetY);
        this.jsonUtils.put(json, "customClosePosition", this.customClosePosition);
        this.jsonUtils.put(json, "allowOffscreen", this.allowOffscreen);
        return json;
    }

    private void setDimensionIfSet(JSONObject json, String parameter, int value) {
        if (value != -1) {
            this.jsonUtils.put(json, parameter, value);
        }
    }

    public boolean fromJSONObject(JSONObject json) {
        this.width = this.jsonUtils.getIntegerFromJSON(json, "width", this.width);
        this.height = this.jsonUtils.getIntegerFromJSON(json, "height", this.height);
        this.offsetX = this.jsonUtils.getIntegerFromJSON(json, "offsetX", this.offsetX);
        this.offsetY = this.jsonUtils.getIntegerFromJSON(json, "offsetY", this.offsetY);
        this.customClosePosition = this.jsonUtils.getStringFromJSON(json, "customClosePosition", this.customClosePosition);
        this.allowOffscreen = this.jsonUtils.getBooleanFromJSON(json, "allowOffscreen", this.allowOffscreen);
        if (this.areResizePropertiesSet()) {
            return true;
        }
        this.reset();
        return false;
    }
}

