/*
 * Decompiled with CFR 0.152.
 */
package com.therouter.router;

import android.app.Activity;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import com.therouter.InnerTheRouterContentProviderKt;
import com.therouter.TheRouter;
import com.therouter.TheRouterKt;
import com.therouter.TheRouterLifecycleCallback;
import com.therouter.history.ActivityNavigatorHistory;
import com.therouter.history.FragmentNavigatorHistory;
import com.therouter.history.HistoryRecorder;
import com.therouter.router.FragmentFactoryKt;
import com.therouter.router.Navigator;
import com.therouter.router.NavigatorKt;
import com.therouter.router.PendingNavigator;
import com.therouter.router.RouteItem;
import com.therouter.router.RouteMapKt;
import com.therouter.router.action.ActionManager;
import com.therouter.router.interceptor.NavigationCallback;
import com.therouter.router.interceptor.NavigatorParamsFixHandle;
import com.therouter.router.interceptor.NavigatorPathFixHandle;
import com.therouter.router.interceptor.PathReplaceInterceptor;
import com.therouter.router.interceptor.RouterReplaceInterceptor;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\u001d\u001a\u00020\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u0019\u0010$\u001a\u0004\u0018\u0001H%\"\n\b\u0000\u0010%*\u0004\u0018\u00010&\u00a2\u0006\u0002\u0010'J(\u0010(\u001a\u00020\u001e\"\n\b\u0000\u0010%*\u0004\u0018\u00010&2\u0014\u0010)\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u0001H%\u0012\u0004\u0012\u00020\u001e0*J\u0010\u0010+\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010 J$\u0010,\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001e0*J\u001a\u0010-\u001a\u00020\u00002\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001e0*J\u0006\u0010.\u001a\u00020\u0003J \u0010.\u001a\u00020\u00032\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000300J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u000201J0\u00102\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u00103\u001a\u0004\u0018\u00010&2\u0006\u00104\u001a\u00020#2\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0007J \u00102\u001a\u00020\u001e2\n\b\u0002\u00107\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010)\u001a\u0004\u0018\u000106H\u0007J&\u00102\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u00104\u001a\u00020#2\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0007J\u001e\u00102\u001a\u00020\u001e2\b\u00103\u001a\u0004\u0018\u00010&2\n\b\u0002\u0010)\u001a\u0004\u0018\u000106H\u0007J&\u00102\u001a\u00020\u001e2\b\u00103\u001a\u0004\u0018\u00010&2\u0006\u00104\u001a\u00020#2\n\b\u0002\u00105\u001a\u0004\u0018\u000106H\u0007J\u0010\u00108\u001a\u0004\u0018\u00010\u00012\u0006\u00109\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0000J\u0010\u0010:\u001a\u00020\u00002\b\u0010;\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010<\u001a\u00020\u00002\b\u0010=\u001a\u0004\u0018\u00010\u0011J\u0010\u0010>\u001a\u00020\u00002\b\u0010?\u001a\u0004\u0018\u00010\u0003J\u0010\u0010@\u001a\u00020\u00002\b\u0010A\u001a\u0004\u0018\u00010\tJ\u0018\u0010B\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020\u0018J\u001a\u0010C\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\b\u0010A\u001a\u0004\u0018\u00010\tJ\u0018\u0010D\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020EJ\u0018\u0010F\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020GJ\u0018\u0010H\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020IJ\u000e\u0010J\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#J\u0018\u0010K\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u00002\u0006\u0010N\u001a\u00020#J\u0018\u0010O\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020#J\u0018\u0010P\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020QJ\u0016\u0010R\u001a\u00020\u00002\u0006\u00109\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\u0001J\u0010\u0010S\u001a\u00020\u00002\b\u0010T\u001a\u0004\u0018\u00010\tJ\u000e\u0010U\u001a\u00020\u00002\u0006\u0010N\u001a\u00020#J\u001a\u0010V\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\b\u0010A\u001a\u0004\u0018\u00010WJ\u001a\u0010X\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\b\u0010A\u001a\u0004\u0018\u00010YJ\u001a\u0010Z\u001a\u00020\u00002\b\u00109\u001a\u0004\u0018\u00010\u00032\b\u0010A\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0015\"\u0004\b\u001c\u0010\u0004\u00a8\u0006["}, d2={"Lcom/therouter/router/Navigator;", "", "url", "", "(Ljava/lang/String;)V", "intent", "Landroid/content/Intent;", "(Ljava/lang/String;Landroid/content/Intent;)V", "extras", "Landroid/os/Bundle;", "getExtras", "()Landroid/os/Bundle;", "getIntent", "()Landroid/content/Intent;", "intentClipData", "Landroid/content/ClipData;", "intentData", "Landroid/net/Uri;", "intentIdentifier", "normalUrl", "getNormalUrl", "()Ljava/lang/String;", "optionsCompat", "pending", "", "simpleUrl", "getSimpleUrl", "getUrl", "setUrl", "action", "", "ctx", "Landroid/content/Context;", "addFlags", "flags", "", "createFragment", "T", "Landroidx/fragment/app/Fragment;", "()Landroidx/fragment/app/Fragment;", "createFragmentWithCallback", "callback", "Lkotlin/Function1;", "createIntent", "createIntentWithCallback", "fillParams", "getUrlWithParams", "handle", "Lkotlin/Function2;", "Lcom/therouter/router/interceptor/NavigatorParamsFixHandle;", "navigation", "fragment", "requestCode", "ncb", "Lcom/therouter/router/interceptor/NavigationCallback;", "context", "optObject", "key", "setClipData", "clipData", "setData", "uri", "setIdentifier", "identifier", "with", "value", "withBoolean", "withBundle", "withByte", "", "withChar", "", "withDouble", "", "withFlags", "withFloat", "", "withInAnimation", "id", "withInt", "withLong", "", "withObject", "withOptionsCompat", "options", "withOutAnimation", "withParcelable", "Landroid/os/Parcelable;", "withSerializable", "Ljava/io/Serializable;", "withString", "router_release"})
public class Navigator {
    @Nullable
    private String url;
    @Nullable
    private final Intent intent;
    @Nullable
    private final String normalUrl;
    @NotNull
    private final Bundle extras;
    @Nullable
    private Bundle optionsCompat;
    private boolean pending;
    @Nullable
    private String intentIdentifier;
    @Nullable
    private Uri intentData;
    @Nullable
    private ClipData intentClipData;

    public Navigator(@Nullable String url, @Nullable Intent intent) {
        block8: {
            String string;
            this.url = url;
            this.intent = intent;
            this.normalUrl = this.url;
            this.extras = new Bundle();
            TheRouterKt.require(!TextUtils.isEmpty((CharSequence)this.url), "Navigator", "Navigator constructor parameter url is empty");
            for (NavigatorPathFixHandle handle : NavigatorKt.access$getFixHandles$p()) {
                NavigatorPathFixHandle it;
                if (handle == null) continue;
                boolean bl = false;
                if (!it.watch(this.url)) continue;
                this.url = it.fix(this.url);
            }
            String string2 = this.url;
            if (string2 == null) break block8;
            String noNullUrl = string2;
            boolean bl = false;
            int index = StringsKt.indexOf$default((CharSequence)noNullUrl, (char)'?', (int)0, (boolean)false, (int)6, null);
            if (index >= 0 && noNullUrl.length() > index) {
                String string3 = noNullUrl.substring(index + 1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = noNullUrl;
            }
            String[] stringArray = new String[]{"&"};
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string4;
                String key;
                String string5;
                String it = (String)element$iv;
                boolean bl2 = false;
                int idx = StringsKt.indexOf$default((CharSequence)it, (String)"=", (int)0, (boolean)false, (int)6, null);
                if (idx > 0) {
                    String string6 = it.substring(0, idx);
                    string5 = string6;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                } else {
                    string5 = key = it;
                }
                if (idx > 0 && it.length() > idx + 1) {
                    String string7 = it.substring(idx + 1);
                    string4 = string7;
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"this as java.lang.String).substring(startIndex)");
                } else {
                    string4 = null;
                }
                String value = string4;
                this.extras.putString(key, value);
            }
        }
    }

    @Nullable
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@Nullable String string) {
        this.url = string;
    }

    @Nullable
    public final Intent getIntent() {
        return this.intent;
    }

    @Nullable
    public final String getNormalUrl() {
        return this.normalUrl;
    }

    @NotNull
    public final Bundle getExtras() {
        return this.extras;
    }

    @NotNull
    public final String getSimpleUrl() {
        String string;
        String string2 = this.normalUrl;
        boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"?", (boolean)false, (int)2, null) : false;
        if (bl) {
            String string3 = this.normalUrl.substring(0, StringsKt.indexOf$default((CharSequence)this.normalUrl, (char)'?', (int)0, (boolean)false, (int)6, null));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        } else {
            string = this.normalUrl;
            if (string == null) {
                string = "";
            }
        }
        return string;
    }

    public Navigator(@Nullable String url) {
        this(url, null);
    }

    @NotNull
    public final String getUrlWithParams() {
        return this.getUrlWithParams((Function2<? super String, ? super String, String>)((Function2)getUrlWithParams.1.INSTANCE));
    }

    @NotNull
    public final String getUrlWithParams(@NotNull NavigatorParamsFixHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        return this.getUrlWithParams((Function2<? super String, ? super String, String>)((Function2)new Function2<String, String, String>((Object)handle){

            @NotNull
            public final String invoke(@NotNull String p0, @NotNull String p1) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((NavigatorParamsFixHandle)this.receiver).fix(p0, p1);
            }
        }));
    }

    @NotNull
    public final String getUrlWithParams(@NotNull Function2<? super String, ? super String, String> handle) {
        Intrinsics.checkNotNullParameter(handle, (String)"handle");
        StringBuilder stringBuilder = new StringBuilder(this.getSimpleUrl());
        boolean isFirst = true;
        for (String key : this.extras.keySet()) {
            if (isFirst) {
                stringBuilder.append("?");
                isFirst = false;
            } else {
                stringBuilder.append("&");
            }
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Object object = this.extras.get(key);
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            stringBuilder.append((String)handle.invoke((Object)key, object));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"stringBuilder.toString()");
        return string;
    }

    @NotNull
    public final Navigator pending() {
        this.pending = true;
        return this;
    }

    @NotNull
    public final Navigator withInt(@Nullable String key, int value) {
        this.extras.putInt(key, value);
        return this;
    }

    @NotNull
    public final Navigator withLong(@Nullable String key, long value) {
        this.extras.putLong(key, value);
        return this;
    }

    @NotNull
    public final Navigator withDouble(@Nullable String key, double value) {
        this.extras.putDouble(key, value);
        return this;
    }

    @NotNull
    public final Navigator withFloat(@Nullable String key, float value) {
        this.extras.putFloat(key, value);
        return this;
    }

    @NotNull
    public final Navigator withChar(@Nullable String key, char value) {
        this.extras.putChar(key, value);
        return this;
    }

    @NotNull
    public final Navigator withByte(@Nullable String key, byte value) {
        this.extras.putByte(key, value);
        return this;
    }

    @NotNull
    public final Navigator withBoolean(@Nullable String key, boolean value) {
        this.extras.putBoolean(key, value);
        return this;
    }

    @NotNull
    public final Navigator withString(@Nullable String key, @Nullable String value) {
        this.extras.putString(key, value);
        return this;
    }

    @NotNull
    public final Navigator withSerializable(@Nullable String key, @Nullable Serializable value) {
        this.extras.putSerializable(key, value);
        return this;
    }

    @NotNull
    public final Navigator withParcelable(@Nullable String key, @Nullable Parcelable value) {
        this.extras.putParcelable(key, value);
        return this;
    }

    @NotNull
    public final Navigator withObject(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ((Map)NavigatorKt.getArguments()).put(key, new SoftReference<Object>(value));
        return this;
    }

    @NotNull
    public final Navigator with(@Nullable Bundle value) {
        return this.withBundle("therouter_bundle", value);
    }

    @NotNull
    public final Navigator fillParams(@NotNull Function1<? super Bundle, Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        action.invoke((Object)this.extras);
        return this;
    }

    @NotNull
    public final Navigator withBundle(@Nullable String key, @Nullable Bundle value) {
        this.extras.putBundle(key, value);
        return this;
    }

    @NotNull
    public final Navigator addFlags(int flags) {
        this.extras.putInt("therouter_intent_flags", this.extras.getInt("therouter_intent_flags", 0) | flags);
        return this;
    }

    @NotNull
    public final Navigator withFlags(int flags) {
        this.extras.putInt("therouter_intent_flags", flags);
        return this;
    }

    @NotNull
    public final Navigator withOptionsCompat(@Nullable Bundle options) {
        this.optionsCompat = options;
        return this;
    }

    @NotNull
    public final Navigator withInAnimation(int id) {
        this.extras.putInt("therouter_intent_animation_in", id);
        return this;
    }

    @NotNull
    public final Navigator withOutAnimation(int id) {
        this.extras.putInt("therouter_intent_animation_out", id);
        return this;
    }

    @NotNull
    public final Navigator setData(@Nullable Uri uri) {
        this.intentData = uri;
        return this;
    }

    @NotNull
    public final Navigator setIdentifier(@Nullable String identifier) {
        this.intentIdentifier = identifier;
        return this;
    }

    @NotNull
    public final Navigator setClipData(@Nullable ClipData clipData) {
        this.intentClipData = clipData;
        return this;
    }

    @Nullable
    public final Object optObject(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SoftReference<Object> softReference = NavigatorKt.getArguments().get(key);
        return softReference != null ? softReference.get() : null;
    }

    public final void createIntentWithCallback(@Nullable Context ctx, @NotNull Function1<? super Intent, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!RouteMapKt.getInitedRouteMap() || this.pending) {
            this.pending = true;
            TheRouterKt.debug$default("Navigator::createIntentWithCallback", "add pending navigator " + this.getSimpleUrl(), null, 4, null);
            NavigatorKt.access$getDisposableQueue$p().addLast(new PendingNavigator(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, callback, ctx){
                final /* synthetic */ Navigator this$0;
                final /* synthetic */ Function1<Intent, Unit> $callback;
                final /* synthetic */ Context $ctx;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                    this.$ctx = $ctx;
                    super(0);
                }

                public final void invoke() {
                    Navigator.access$setPending$p(this.this$0, false);
                    this.$callback.invoke((Object)this.this$0.createIntent(this.$ctx));
                }
            })));
        } else {
            callback.invoke((Object)this.createIntent(ctx));
        }
    }

    @NotNull
    public final Intent createIntent(@Nullable Context ctx) {
        Intent navigationIntent;
        RouteItem it;
        TheRouterKt.debug$default("Navigator::createIntent", "begin navigate " + this.getSimpleUrl(), null, 4, null);
        Context context = ctx;
        if (context == null) {
            context = InnerTheRouterContentProviderKt.getApplicationContext();
        }
        Context context2 = context;
        String matchUrl = null;
        matchUrl = this.getSimpleUrl();
        for (Object interceptor : NavigatorKt.access$getPathReplaceInterceptors$p()) {
            if (interceptor == null) continue;
            boolean bl = false;
            if (!((PathReplaceInterceptor)((Object)it)).watch(matchUrl)) continue;
            String temp = matchUrl;
            matchUrl = ((PathReplaceInterceptor)((Object)it)).replace(matchUrl);
            TheRouterKt.debug$default("Navigator::createIntent", temp + " replace to " + matchUrl, null, 4, null);
        }
        RouteItem match = null;
        match = RouteMapKt.matchRouteMap(matchUrl);
        RouteItem routeItem = match;
        if (routeItem != null && (routeItem = routeItem.getExtras()) != null) {
            routeItem.putAll(this.extras);
        }
        RouteItem routeItem2 = match;
        if (routeItem2 != null) {
            it = routeItem2;
            boolean bl = false;
            TheRouterKt.debug$default("Navigator::createIntent", "match route " + it, null, 4, null);
        }
        for (RouterReplaceInterceptor interceptor : NavigatorKt.access$getRouterReplaceInterceptors$p()) {
            RouteItem routeItem3;
            RouterReplaceInterceptor it2;
            if (interceptor == null) continue;
            boolean bl = false;
            if (!it2.watch(match)) continue;
            if ((match = it2.replace(match)) == null) continue;
            boolean bl2 = false;
            TheRouterKt.debug$default("Navigator::createIntent", "route replace to " + routeItem3, null, 4, null);
        }
        Intent intent = this.intent;
        if (intent == null) {
            intent = navigationIntent = new Intent();
        }
        if (match != null) {
            NavigatorKt.access$getRouterInterceptor$p().invoke((Object)match, (Object)new Function1<RouteItem, Unit>(this, navigationIntent, context2){
                final /* synthetic */ Navigator this$0;
                final /* synthetic */ Intent $navigationIntent;
                final /* synthetic */ Context $context;
                {
                    this.this$0 = $receiver;
                    this.$navigationIntent = $navigationIntent;
                    this.$context = $context;
                    super(1);
                }

                public final void invoke(@NotNull RouteItem routeItem) {
                    Uri it;
                    Intent intent;
                    Uri uri;
                    Intrinsics.checkNotNullParameter((Object)routeItem, (String)"routeItem");
                    Uri uri2 = Navigator.access$getIntentData$p(this.this$0);
                    if (uri2 != null) {
                        uri = uri2;
                        intent = this.$navigationIntent;
                        it = uri;
                        boolean bl = false;
                        intent.setData(it);
                    }
                    ClipData clipData = Navigator.access$getIntentClipData$p(this.this$0);
                    if (clipData != null) {
                        uri = clipData;
                        intent = this.$navigationIntent;
                        it = uri;
                        boolean bl = false;
                        intent.setClipData((ClipData)it);
                    }
                    if (Build.VERSION.SDK_INT >= 29 && Navigator.access$getIntentIdentifier$p(this.this$0) != null) {
                        this.$navigationIntent.setIdentifier(Navigator.access$getIntentIdentifier$p(this.this$0));
                    }
                    Context context = this.$context;
                    Intrinsics.checkNotNull((Object)context);
                    this.$navigationIntent.setComponent(new ComponentName(context.getPackageName(), routeItem.getClassName()));
                    if (!(this.$context instanceof Activity)) {
                        this.$navigationIntent.addFlags(0x10000000);
                    }
                    TheRouterLifecycleCallback.INSTANCE.addActivityCreatedObserver(routeItem.getClassName(), (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(routeItem, this.this$0){
                        final /* synthetic */ RouteItem $routeItem;
                        final /* synthetic */ Navigator this$0;
                        {
                            this.$routeItem = $routeItem;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (Intrinsics.areEqual((Object)it.getClass().getName(), (Object)this.$routeItem.getClassName()) && !TextUtils.isEmpty((CharSequence)this.$routeItem.getAction())) {
                                TheRouter.build(this.$routeItem.getAction()).withObject("therouter_object_navigator", this.this$0).withObject("therouter_object_current_activity", it).action((Context)it);
                            }
                        }
                    }));
                    this.$navigationIntent.putExtra("therouter_action", routeItem.getAction());
                    this.$navigationIntent.putExtra("therouter_path", this.this$0.getUrlWithParams());
                    this.$navigationIntent.putExtra("therouter_description", routeItem.getDescription());
                    Bundle bundle = routeItem.getExtras();
                    uri = this.$navigationIntent;
                    Bundle $this$invoke_u24lambda_u2d2 = bundle;
                    boolean bl = false;
                    Bundle bundle2 = $this$invoke_u24lambda_u2d2.getBundle("therouter_bundle");
                    if (bundle2 != null) {
                        $this$invoke_u24lambda_u2d2.remove("therouter_bundle");
                        uri.putExtra("therouter_bundle", bundle2);
                    }
                    uri.putExtras($this$invoke_u24lambda_u2d2);
                    this.$navigationIntent.addFlags(routeItem.getExtras().getInt("therouter_intent_flags"));
                    int inAnimId = routeItem.getExtras().getInt("therouter_intent_animation_in");
                    int outAnimId = routeItem.getExtras().getInt("therouter_intent_animation_out");
                    if (inAnimId != 0 || outAnimId != 0) {
                        if (this.$context instanceof Activity) {
                            TheRouterKt.debug$default("Navigator::createIntent", "overridePendingTransition " + routeItem.getClassName(), null, 4, null);
                            ((Activity)this.$context).overridePendingTransition(routeItem.getExtras().getInt("therouter_intent_animation_in"), routeItem.getExtras().getInt("therouter_intent_animation_out"));
                        } else if (TheRouter.isDebug()) {
                            throw new RuntimeException("Navigator::createIntent context is not Activity, ignore animation");
                        }
                    }
                }
            });
        }
        return navigationIntent;
    }

    public final <T extends Fragment> void createFragmentWithCallback(@NotNull Function1<? super T, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (!RouteMapKt.getInitedRouteMap() || this.pending) {
            this.pending = true;
            TheRouterKt.debug$default("Navigator::createFragmentWithCallback", "add pending navigator " + this.getSimpleUrl(), null, 4, null);
            NavigatorKt.access$getDisposableQueue$p().addLast(new PendingNavigator(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, callback){
                final /* synthetic */ Navigator this$0;
                final /* synthetic */ Function1<T, Unit> $callback;
                {
                    this.this$0 = $receiver;
                    this.$callback = $callback;
                    super(0);
                }

                public final void invoke() {
                    Navigator.access$setPending$p(this.this$0, false);
                    this.$callback.invoke(this.this$0.createFragment());
                }
            })));
        } else {
            callback.invoke(this.createFragment());
        }
    }

    @Nullable
    public final <T extends Fragment> T createFragment() {
        Ref.ObjectRef fragment;
        block4: {
            Object it;
            fragment = new Ref.ObjectRef();
            TheRouterKt.debug$default("Navigator::navigationFragment", "begin navigate " + this.getSimpleUrl(), null, 4, null);
            String matchUrl = null;
            matchUrl = this.getSimpleUrl();
            for (PathReplaceInterceptor interceptor : NavigatorKt.access$getPathReplaceInterceptors$p()) {
                if (interceptor == null) continue;
                boolean bl = false;
                if (!((PathReplaceInterceptor)it).watch(matchUrl)) continue;
                matchUrl = ((PathReplaceInterceptor)it).replace(matchUrl);
            }
            TheRouterKt.debug$default("Navigator::navigationFragment", "path replace to " + matchUrl, null, 4, null);
            RouteItem match = null;
            match = RouteMapKt.matchRouteMap(matchUrl);
            RouteItem routeItem = match;
            if (routeItem != null && (routeItem = routeItem.getExtras()) != null) {
                routeItem.putAll(this.extras);
            }
            RouteItem routeItem2 = match;
            if (routeItem2 != null) {
                it = routeItem2;
                boolean bl = false;
                TheRouterKt.debug$default("Navigator::navigationFragment", "match route " + it, null, 4, null);
            }
            for (RouterReplaceInterceptor interceptor : NavigatorKt.access$getRouterReplaceInterceptors$p()) {
                RouterReplaceInterceptor it2;
                if (interceptor == null) continue;
                boolean bl = false;
                if (!it2.watch(match)) continue;
                match = it2.replace(match);
            }
            TheRouterKt.debug$default("Navigator::navigationFragment", "route replace to " + match, null, 4, null);
            RouteItem routeItem3 = match;
            if (routeItem3 == null) break block4;
            it = routeItem3;
            boolean bl = false;
            Function2 function2 = NavigatorKt.access$getRouterInterceptor$p();
            RouteItem routeItem4 = match;
            Intrinsics.checkNotNull((Object)routeItem4);
            function2.invoke((Object)routeItem4, (Object)new Function1<RouteItem, Unit>((Ref.ObjectRef<Fragment>)fragment, this){
                final /* synthetic */ Ref.ObjectRef<Fragment> $fragment;
                final /* synthetic */ Navigator this$0;
                {
                    this.$fragment = $fragment;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull RouteItem routeItem) {
                    Intrinsics.checkNotNullParameter((Object)routeItem, (String)"routeItem");
                    if (FragmentFactoryKt.isFragmentClass(routeItem.getClassName())) {
                        try {
                            this.$fragment.element = FragmentFactoryKt.instantiate(routeItem.getClassName());
                            Bundle bundle = routeItem.getExtras();
                            Intent intent = this.this$0.getIntent();
                            if (intent != null && (intent = intent.getExtras()) != null) {
                                Intent it = intent;
                                boolean bl = false;
                                bundle.putAll((Bundle)it);
                            }
                            bundle.putString("therouter_action", routeItem.getAction());
                            bundle.putString("therouter_path", this.this$0.getUrlWithParams());
                            bundle.putString("therouter_description", routeItem.getDescription());
                            Fragment fragment = (Fragment)this.$fragment.element;
                            if (fragment != null) {
                                fragment.setArguments(bundle);
                            }
                            TheRouterKt.debug$default("Navigator::navigation", "create fragment " + routeItem.getClassName(), null, 4, null);
                        }
                        catch (Exception e) {
                            TheRouterKt.debug("Navigator::navigationFragment", "create fragment instance error", (Function0<Unit>)((Function0)new Function0<Unit>(e){
                                final /* synthetic */ Exception $e;
                                {
                                    this.$e = $e;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$e.printStackTrace();
                                }
                            }));
                        }
                        HistoryRecorder.pushHistory(new FragmentNavigatorHistory(this.this$0.getUrlWithParams()));
                    } else if (TheRouter.isDebug()) {
                        throw new RuntimeException("TheRouter::Navigator " + routeItem.getClassName() + " is not Fragment");
                    }
                }
            });
        }
        return (T)((Fragment)fragment.element);
    }

    @JvmOverloads
    public final void navigation(@Nullable Fragment fragment, @Nullable NavigationCallback callback) {
        this.navigation(fragment, -1008600, callback);
    }

    public static /* synthetic */ void navigation$default(Navigator navigator, Fragment fragment, NavigationCallback navigationCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigation");
        }
        if ((n & 2) != 0) {
            navigationCallback = null;
        }
        navigator.navigation(fragment, navigationCallback);
    }

    @JvmOverloads
    public final void navigation(@Nullable Fragment fragment, int requestCode, @Nullable NavigationCallback ncb) {
        Fragment fragment2 = fragment;
        this.navigation((Context)(fragment2 != null ? fragment2.getActivity() : null), fragment, requestCode, ncb);
    }

    public static /* synthetic */ void navigation$default(Navigator navigator, Fragment fragment, int n, NavigationCallback navigationCallback, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigation");
        }
        if ((n2 & 4) != 0) {
            navigationCallback = null;
        }
        navigator.navigation(fragment, n, navigationCallback);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context context, @Nullable NavigationCallback callback) {
        this.navigation(context, -1008600, callback);
    }

    public static /* synthetic */ void navigation$default(Navigator navigator, Context context, NavigationCallback navigationCallback, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigation");
        }
        if ((n & 1) != 0) {
            context = InnerTheRouterContentProviderKt.getApplicationContext();
        }
        if ((n & 2) != 0) {
            navigationCallback = null;
        }
        navigator.navigation(context, navigationCallback);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context ctx, int requestCode, @Nullable NavigationCallback ncb) {
        this.navigation(ctx, null, requestCode, ncb);
    }

    public static /* synthetic */ void navigation$default(Navigator navigator, Context context, int n, NavigationCallback navigationCallback, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigation");
        }
        if ((n2 & 4) != 0) {
            navigationCallback = null;
        }
        navigator.navigation(context, n, navigationCallback);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context ctx, @Nullable Fragment fragment, int requestCode, @Nullable NavigationCallback ncb) {
        RouteItem it;
        NavigationCallback navigationCallback;
        Context context;
        if (!RouteMapKt.getInitedRouteMap() || this.pending) {
            this.pending = true;
            TheRouterKt.debug$default("Navigator::navigation", "add pending navigator " + this.getSimpleUrl(), null, 4, null);
            NavigatorKt.access$getDisposableQueue$p().addLast(new PendingNavigator(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, ctx, fragment, requestCode, ncb){
                final /* synthetic */ Navigator this$0;
                final /* synthetic */ Context $ctx;
                final /* synthetic */ Fragment $fragment;
                final /* synthetic */ int $requestCode;
                final /* synthetic */ NavigationCallback $ncb;
                {
                    this.this$0 = $receiver;
                    this.$ctx = $ctx;
                    this.$fragment = $fragment;
                    this.$requestCode = $requestCode;
                    this.$ncb = $ncb;
                    super(0);
                }

                public final void invoke() {
                    Navigator.access$setPending$p(this.this$0, false);
                    this.this$0.navigation(this.$ctx, this.$fragment, this.$requestCode, this.$ncb);
                }
            })));
            return;
        }
        TheRouterKt.debug$default("Navigator::navigation", "begin navigate " + this.getSimpleUrl(), null, 4, null);
        Context context2 = ctx;
        if (context2 == null) {
            context2 = context = InnerTheRouterContentProviderKt.getApplicationContext();
        }
        if ((navigationCallback = ncb) == null) {
            navigationCallback = NavigatorKt.access$getDefaultCallback$p();
        }
        NavigationCallback callback = navigationCallback;
        String matchUrl = null;
        matchUrl = this.getSimpleUrl();
        for (PathReplaceInterceptor interceptor : NavigatorKt.access$getPathReplaceInterceptors$p()) {
            if (interceptor == null) continue;
            boolean bl = false;
            if (!((PathReplaceInterceptor)((Object)it)).watch(matchUrl)) continue;
            String temp = matchUrl;
            matchUrl = ((PathReplaceInterceptor)((Object)it)).replace(matchUrl);
            TheRouterKt.debug$default("Navigator::navigation", temp + " replace to " + matchUrl, null, 4, null);
        }
        RouteItem match = null;
        match = RouteMapKt.matchRouteMap(matchUrl);
        if (ActionManager.INSTANCE.isAction$router_release(this) && match == null) {
            ActionManager.INSTANCE.handleAction$router_release(this, context);
            return;
        }
        RouteItem routeItem = match;
        if (routeItem != null && (routeItem = routeItem.getExtras()) != null) {
            routeItem.putAll(this.extras);
        }
        RouteItem routeItem2 = match;
        if (routeItem2 != null) {
            it = routeItem2;
            boolean bl = false;
            TheRouterKt.debug$default("Navigator::navigation", "match route " + it, null, 4, null);
        }
        for (RouterReplaceInterceptor interceptor : NavigatorKt.access$getRouterReplaceInterceptors$p()) {
            RouteItem routeItem3;
            RouterReplaceInterceptor it2;
            if (interceptor == null) continue;
            boolean bl = false;
            if (!it2.watch(match)) continue;
            if ((match = it2.replace(match)) == null) continue;
            boolean bl2 = false;
            TheRouterKt.debug$default("Navigator::navigation", "route replace to " + routeItem3, null, 4, null);
        }
        if (match != null) {
            TheRouterKt.debug$default("Navigator::navigation", "NavigationCallback on found", null, 4, null);
            callback.onFound(this);
            NavigatorKt.access$getRouterInterceptor$p().invoke((Object)match, (Object)new Function1<RouteItem, Unit>(this, context, fragment, requestCode, callback){
                final /* synthetic */ Navigator this$0;
                final /* synthetic */ Context $context;
                final /* synthetic */ Fragment $fragment;
                final /* synthetic */ int $requestCode;
                final /* synthetic */ NavigationCallback $callback;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$fragment = $fragment;
                    this.$requestCode = $requestCode;
                    this.$callback = $callback;
                    super(1);
                }

                public final void invoke(@NotNull RouteItem routeItem) {
                    Uri it;
                    Intrinsics.checkNotNullParameter((Object)routeItem, (String)"routeItem");
                    Intent intent = this.this$0.getIntent();
                    if (intent == null) {
                        intent = new Intent();
                    }
                    Intent intent2 = intent;
                    Uri uri = Navigator.access$getIntentData$p(this.this$0);
                    if (uri != null) {
                        it = uri;
                        boolean bl = false;
                        intent2.setData(it);
                    }
                    ClipData clipData = Navigator.access$getIntentClipData$p(this.this$0);
                    if (clipData != null) {
                        it = clipData;
                        boolean bl = false;
                        intent2.setClipData((ClipData)it);
                    }
                    if (Build.VERSION.SDK_INT >= 29 && Navigator.access$getIntentIdentifier$p(this.this$0) != null) {
                        intent2.setIdentifier(Navigator.access$getIntentIdentifier$p(this.this$0));
                    }
                    Context context = this.$context;
                    Intrinsics.checkNotNull((Object)context);
                    intent2.setComponent(new ComponentName(context.getPackageName(), routeItem.getClassName()));
                    if (!(this.$context instanceof Activity) && this.$fragment == null) {
                        intent2.addFlags(0x10000000);
                    }
                    TheRouterLifecycleCallback.INSTANCE.addActivityCreatedObserver(routeItem.getClassName(), (Function1<? super Activity, Unit>)((Function1)new Function1<Activity, Unit>(routeItem, this.$callback, this.this$0){
                        final /* synthetic */ RouteItem $routeItem;
                        final /* synthetic */ NavigationCallback $callback;
                        final /* synthetic */ Navigator this$0;
                        {
                            this.$routeItem = $routeItem;
                            this.$callback = $callback;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Activity it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            if (Intrinsics.areEqual((Object)it.getClass().getName(), (Object)this.$routeItem.getClassName())) {
                                this.$callback.onActivityCreated(this.this$0, it);
                                if (!TextUtils.isEmpty((CharSequence)this.$routeItem.getAction())) {
                                    TheRouter.build(this.$routeItem.getAction()).withObject("therouter_object_navigator", this.this$0).withObject("therouter_object_current_activity", it).action((Context)it);
                                }
                            }
                        }
                    }));
                    intent2.putExtra("therouter_action", routeItem.getAction());
                    intent2.putExtra("therouter_path", this.this$0.getUrlWithParams());
                    intent2.putExtra("therouter_description", routeItem.getDescription());
                    Bundle $this$invoke_u24lambda_u2d2 = routeItem.getExtras();
                    boolean bl = false;
                    Bundle bundle = $this$invoke_u24lambda_u2d2.getBundle("therouter_bundle");
                    if (bundle != null) {
                        $this$invoke_u24lambda_u2d2.remove("therouter_bundle");
                        intent2.putExtra("therouter_bundle", bundle);
                    }
                    intent2.putExtras($this$invoke_u24lambda_u2d2);
                    intent2.addFlags(routeItem.getExtras().getInt("therouter_intent_flags"));
                    if (this.$requestCode == -1008600) {
                        if (this.$fragment != null) {
                            TheRouterKt.debug$default("Navigator::navigation", "fragment.startActivity " + routeItem.getClassName(), null, 4, null);
                            this.$fragment.startActivity(intent2, Navigator.access$getOptionsCompat$p(this.this$0));
                        } else {
                            TheRouterKt.debug$default("Navigator::navigation", "startActivity " + routeItem.getClassName(), null, 4, null);
                            this.$context.startActivity(intent2, Navigator.access$getOptionsCompat$p(this.this$0));
                        }
                        int inAnimId = routeItem.getExtras().getInt("therouter_intent_animation_in");
                        int outAnimId = routeItem.getExtras().getInt("therouter_intent_animation_out");
                        if (inAnimId != 0 || outAnimId != 0) {
                            if (this.$context instanceof Activity) {
                                TheRouterKt.debug$default("Navigator::navigation", "overridePendingTransition " + routeItem.getClassName(), null, 4, null);
                                ((Activity)this.$context).overridePendingTransition(routeItem.getExtras().getInt("therouter_intent_animation_in"), routeItem.getExtras().getInt("therouter_intent_animation_out"));
                            } else if (TheRouter.isDebug()) {
                                throw new RuntimeException("TheRouter::Navigator context is not Activity, ignore animation");
                            }
                        }
                    } else if (this.$fragment != null) {
                        TheRouterKt.debug$default("Navigator::navigation", "fragment.startActivityForResult " + routeItem.getClassName(), null, 4, null);
                        this.$fragment.startActivityForResult(intent2, this.$requestCode, Navigator.access$getOptionsCompat$p(this.this$0));
                    } else if (this.$context instanceof Activity) {
                        TheRouterKt.debug$default("Navigator::navigation", "startActivityForResult " + routeItem.getClassName(), null, 4, null);
                        ((Activity)this.$context).startActivityForResult(intent2, this.$requestCode, Navigator.access$getOptionsCompat$p(this.this$0));
                    } else {
                        if (TheRouter.isDebug()) {
                            throw new RuntimeException("TheRouter::Navigator context is not Activity or Fragment");
                        }
                        this.$context.startActivity(intent2, Navigator.access$getOptionsCompat$p(this.this$0));
                    }
                    HistoryRecorder.pushHistory(new ActivityNavigatorHistory(this.this$0.getUrlWithParams()));
                }
            });
            callback.onArrival(this);
        } else {
            callback.onLost(this);
        }
    }

    public static /* synthetic */ void navigation$default(Navigator navigator, Context context, Fragment fragment, int n, NavigationCallback navigationCallback, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: navigation");
        }
        if ((n2 & 8) != 0) {
            navigationCallback = null;
        }
        navigator.navigation(context, fragment, n, navigationCallback);
    }

    public final void action() {
        this.action(null);
    }

    public final void action(@Nullable Context ctx) {
        if (ActionManager.INSTANCE.isAction$router_release(this)) {
            Navigator.navigation$default(this, ctx, null, 2, null);
        }
    }

    public static /* synthetic */ void action$default(Navigator navigator, Context context, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: action");
        }
        if ((n & 1) != 0) {
            context = null;
        }
        navigator.action(context);
    }

    @JvmOverloads
    public final void navigation(@Nullable Fragment fragment) {
        Navigator.navigation$default(this, fragment, null, 2, null);
    }

    @JvmOverloads
    public final void navigation(@Nullable Fragment fragment, int requestCode) {
        Navigator.navigation$default(this, fragment, requestCode, null, 4, null);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context context) {
        Navigator.navigation$default(this, context, null, 2, null);
    }

    @JvmOverloads
    public final void navigation() {
        Navigator.navigation$default(this, null, null, 3, null);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context ctx, int requestCode) {
        Navigator.navigation$default(this, ctx, requestCode, null, 4, null);
    }

    @JvmOverloads
    public final void navigation(@Nullable Context ctx, @Nullable Fragment fragment, int requestCode) {
        Navigator.navigation$default(this, ctx, fragment, requestCode, null, 8, null);
    }

    public static final /* synthetic */ void access$setPending$p(Navigator $this, boolean bl) {
        $this.pending = bl;
    }

    public static final /* synthetic */ Uri access$getIntentData$p(Navigator $this) {
        return $this.intentData;
    }

    public static final /* synthetic */ ClipData access$getIntentClipData$p(Navigator $this) {
        return $this.intentClipData;
    }

    public static final /* synthetic */ String access$getIntentIdentifier$p(Navigator $this) {
        return $this.intentIdentifier;
    }

    public static final /* synthetic */ Bundle access$getOptionsCompat$p(Navigator $this) {
        return $this.optionsCompat;
    }
}

