/*
 * Decompiled with CFR 0.152.
 */
package cn.jzvd;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.media.AudioManager;
import android.provider.Settings;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import cn.jzvd.JZDataSource;
import cn.jzvd.JZMediaInterface;
import cn.jzvd.JZMediaManager;
import cn.jzvd.JZTextureView;
import cn.jzvd.JZUserAction;
import cn.jzvd.JZUtils;
import cn.jzvd.JzvdMgr;
import cn.jzvd.R;
import java.lang.reflect.Constructor;
import java.util.Timer;
import java.util.TimerTask;

public abstract class Jzvd
extends FrameLayout
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
View.OnTouchListener {
    public static final String TAG = "JZVD";
    public static final int THRESHOLD = 80;
    public static final int FULL_SCREEN_NORMAL_DELAY = 300;
    public static final int SCREEN_WINDOW_NORMAL = 0;
    public static final int SCREEN_WINDOW_LIST = 1;
    public static final int SCREEN_WINDOW_FULLSCREEN = 2;
    public static final int SCREEN_WINDOW_TINY = 3;
    public static final int CURRENT_STATE_NORMAL = 0;
    public static final int CURRENT_STATE_PREPARING = 1;
    public static final int CURRENT_STATE_PREPARING_CHANGING_URL = 2;
    public static final int CURRENT_STATE_PLAYING = 3;
    public static final int CURRENT_STATE_PAUSE = 5;
    public static final int CURRENT_STATE_AUTO_COMPLETE = 6;
    public static final int CURRENT_STATE_ERROR = 7;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_ADAPTER = 0;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_FILL_PARENT = 1;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_FILL_SCROP = 2;
    public static final int VIDEO_IMAGE_DISPLAY_TYPE_ORIGINAL = 3;
    public static boolean ACTION_BAR_EXIST = true;
    public static boolean TOOL_BAR_EXIST = true;
    public static int FULLSCREEN_ORIENTATION = 4;
    public static int NORMAL_ORIENTATION = 1;
    public static boolean SAVE_PROGRESS = true;
    public static boolean WIFI_TIP_DIALOG_SHOWED = false;
    public static int VIDEO_IMAGE_DISPLAY_TYPE = 0;
    public static long CLICK_QUIT_FULLSCREEN_TIME = 0L;
    public static long lastAutoFullscreenTime = 0L;
    public static AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int focusChange) {
            switch (focusChange) {
                case 1: {
                    break;
                }
                case -1: {
                    Jzvd.releaseAllVideos();
                    Log.d((String)Jzvd.TAG, (String)("AUDIOFOCUS_LOSS [" + this.hashCode() + "]"));
                    break;
                }
                case -2: {
                    try {
                        Jzvd player = JzvdMgr.getCurrentJzvd();
                        if (player != null && player.currentState == 3) {
                            player.startButton.performClick();
                        }
                    }
                    catch (IllegalStateException e) {
                        e.printStackTrace();
                    }
                    Log.d((String)Jzvd.TAG, (String)("AUDIOFOCUS_LOSS_TRANSIENT [" + this.hashCode() + "]"));
                    break;
                }
            }
        }
    };
    protected static JZUserAction JZ_USER_EVENT;
    protected static Timer UPDATE_PROGRESS_TIMER;
    public int currentState = -1;
    public int currentScreen = -1;
    public long seekToInAdvance = 0L;
    public ImageView startButton;
    public SeekBar progressBar;
    public ImageView fullscreenButton;
    public TextView currentTimeTextView;
    public TextView totalTimeTextView;
    public ViewGroup textureViewContainer;
    public ViewGroup topContainer;
    public ViewGroup bottomContainer;
    public int widthRatio = 0;
    public int heightRatio = 0;
    public JZDataSource jzDataSource;
    public int positionInList = -1;
    public int videoRotation = 0;
    protected int mScreenWidth;
    protected int mScreenHeight;
    protected AudioManager mAudioManager;
    protected ProgressTimerTask mProgressTimerTask;
    protected boolean mTouchingProgressBar;
    protected float mDownX;
    protected float mDownY;
    protected boolean mChangeVolume;
    protected boolean mChangePosition;
    protected boolean mChangeBrightness;
    protected long mGestureDownPosition;
    protected int mGestureDownVolume;
    protected float mGestureDownBrightness;
    protected long mSeekTimePosition;
    boolean tmp_test_back = false;
    public static int ON_PLAY_PAUSE_TMP_STATE;

    public Jzvd(Context context) {
        super(context);
        this.init(context);
    }

    public Jzvd(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public static void releaseAllVideos() {
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME > 300L) {
            Log.d((String)TAG, (String)"releaseAllVideos");
            JzvdMgr.completeAll();
            JZMediaManager.instance().positionInList = -1;
            JZMediaManager.instance().releaseMediaPlayer();
        }
    }

    public static void startFullscreen(Context context, Class _class, String url, String title) {
        Jzvd.startFullscreen(context, _class, new JZDataSource(url, title));
    }

    public static void startFullscreen(Context context, Class _class, JZDataSource jzDataSource) {
        Jzvd.hideSupportActionBar(context);
        JZUtils.setRequestedOrientation(context, FULLSCREEN_ORIENTATION);
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(context).findViewById(0x1020002);
        View old = vp.findViewById(R.id.jz_fullscreen_id);
        if (old != null) {
            vp.removeView(old);
        }
        try {
            Constructor constructor = _class.getConstructor(Context.class);
            Jzvd jzvd = (Jzvd)((Object)constructor.newInstance(context));
            jzvd.setId(R.id.jz_fullscreen_id);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jzvd, (ViewGroup.LayoutParams)lp);
            jzvd.setUp(jzDataSource, 2);
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            jzvd.startButton.performClick();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean backPress() {
        Log.i((String)TAG, (String)"backPress");
        if (System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME < 300L) {
            return false;
        }
        if (JzvdMgr.getSecondFloor() != null) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            if (JzvdMgr.getFirstFloor().jzDataSource.containsTheUrl(JZMediaManager.getDataSource().getCurrentUrl())) {
                Jzvd jzvd = JzvdMgr.getSecondFloor();
                jzvd.onEvent(jzvd.currentScreen == 2 ? 8 : 10);
                JzvdMgr.getFirstFloor().playOnThisJzvd();
            } else {
                Jzvd.quitFullscreenOrTinyWindow();
            }
            return true;
        }
        if (JzvdMgr.getFirstFloor() != null && (JzvdMgr.getFirstFloor().currentScreen == 2 || JzvdMgr.getFirstFloor().currentScreen == 3)) {
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
            Jzvd.quitFullscreenOrTinyWindow();
            return true;
        }
        return false;
    }

    public static void quitFullscreenOrTinyWindow() {
        JzvdMgr.getFirstFloor().clearFloatScreen();
        JZMediaManager.instance().releaseMediaPlayer();
        JzvdMgr.completeAll();
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void showSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && JZUtils.getAppCompActivity(context) != null && (ab = JZUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
        if (TOOL_BAR_EXIST) {
            JZUtils.getWindow(context).clearFlags(1024);
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public static void hideSupportActionBar(Context context) {
        ActionBar ab;
        if (ACTION_BAR_EXIST && JZUtils.getAppCompActivity(context) != null && (ab = JZUtils.getAppCompActivity(context).getSupportActionBar()) != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        if (TOOL_BAR_EXIST) {
            JZUtils.getWindow(context).setFlags(1024, 1024);
        }
    }

    public static void clearSavedProgress(Context context, String url) {
        JZUtils.clearSavedProgress(context, url);
    }

    public static void setJzUserAction(JZUserAction jzUserEvent) {
        JZ_USER_EVENT = jzUserEvent;
    }

    public static void goOnPlayOnResume() {
        if (JzvdMgr.getCurrentJzvd() != null) {
            Jzvd jzvd = JzvdMgr.getCurrentJzvd();
            if (jzvd.currentState == 5) {
                if (ON_PLAY_PAUSE_TMP_STATE == 5) {
                    jzvd.onStatePause();
                    JZMediaManager.pause();
                } else {
                    jzvd.onStatePlaying();
                    JZMediaManager.start();
                }
                ON_PLAY_PAUSE_TMP_STATE = 0;
            }
        }
    }

    public static void goOnPlayOnPause() {
        if (JzvdMgr.getCurrentJzvd() != null) {
            Jzvd jzvd = JzvdMgr.getCurrentJzvd();
            if (jzvd.currentState != 6 && jzvd.currentState != 0 && jzvd.currentState != 7) {
                ON_PLAY_PAUSE_TMP_STATE = jzvd.currentState;
                jzvd.onStatePause();
                JZMediaManager.pause();
            }
        }
    }

    public static void onScrollAutoTiny(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int lastVisibleItem = firstVisibleItem + visibleItemCount;
        int currentPlayPosition = JZMediaManager.instance().positionInList;
        if (currentPlayPosition >= 0) {
            if (currentPlayPosition < firstVisibleItem || currentPlayPosition > lastVisibleItem - 1) {
                if (JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd().currentScreen != 3 && JzvdMgr.getCurrentJzvd().currentScreen != 2) {
                    if (JzvdMgr.getCurrentJzvd().currentState == 5) {
                        Jzvd.releaseAllVideos();
                    } else {
                        Log.e((String)TAG, (String)"onScroll: out screen");
                        JzvdMgr.getCurrentJzvd().startWindowTiny();
                    }
                }
            } else if (JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd().currentScreen == 3) {
                Log.e((String)TAG, (String)"onScroll: into screen");
                Jzvd.backPress();
            }
        }
    }

    public static void onScrollReleaseAllVideos(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        int lastVisibleItem = firstVisibleItem + visibleItemCount;
        int currentPlayPosition = JZMediaManager.instance().positionInList;
        Log.e((String)TAG, (String)("onScrollReleaseAllVideos: " + currentPlayPosition + " " + firstVisibleItem + " " + currentPlayPosition + " " + lastVisibleItem));
        if (currentPlayPosition >= 0 && (currentPlayPosition < firstVisibleItem || currentPlayPosition > lastVisibleItem - 1) && JzvdMgr.getCurrentJzvd().currentScreen != 2) {
            Jzvd.releaseAllVideos();
        }
    }

    public static void onChildViewAttachedToWindow(View view, int jzvdId) {
        Jzvd jzvd;
        if (JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd().currentScreen == 3 && (jzvd = (Jzvd)view.findViewById(jzvdId)) != null && jzvd.jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl())) {
            Jzvd.backPress();
        }
    }

    public static void onChildViewDetachedFromWindow(View view) {
        Jzvd jzvd;
        if (JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd().currentScreen != 3 && ((ViewGroup)view).indexOfChild((View)(jzvd = JzvdMgr.getCurrentJzvd())) != -1) {
            if (jzvd.currentState == 5) {
                Jzvd.releaseAllVideos();
            } else {
                jzvd.startWindowTiny();
            }
        }
    }

    public static void setTextureViewRotation(int rotation) {
        if (JZMediaManager.textureView != null) {
            JZMediaManager.textureView.setRotation(rotation);
        }
    }

    public static void setVideoImageDisplayType(int type) {
        VIDEO_IMAGE_DISPLAY_TYPE = type;
        if (JZMediaManager.textureView != null) {
            JZMediaManager.textureView.requestLayout();
        }
    }

    public Object getCurrentUrl() {
        return this.jzDataSource.getCurrentUrl();
    }

    public abstract int getLayoutId();

    public void init(Context context) {
        View.inflate((Context)context, (int)this.getLayoutId(), (ViewGroup)this);
        this.startButton = (ImageView)this.findViewById(R.id.start);
        this.fullscreenButton = (ImageView)this.findViewById(R.id.fullscreen);
        this.progressBar = (SeekBar)this.findViewById(R.id.bottom_seek_progress);
        this.currentTimeTextView = (TextView)this.findViewById(R.id.current);
        this.totalTimeTextView = (TextView)this.findViewById(R.id.total);
        this.bottomContainer = (ViewGroup)this.findViewById(R.id.layout_bottom);
        this.textureViewContainer = (ViewGroup)this.findViewById(R.id.surface_container);
        this.topContainer = (ViewGroup)this.findViewById(R.id.layout_top);
        this.startButton.setOnClickListener((View.OnClickListener)this);
        this.fullscreenButton.setOnClickListener((View.OnClickListener)this);
        this.progressBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.bottomContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnClickListener((View.OnClickListener)this);
        this.textureViewContainer.setOnTouchListener((View.OnTouchListener)this);
        this.mScreenWidth = this.getContext().getResources().getDisplayMetrics().widthPixels;
        this.mScreenHeight = this.getContext().getResources().getDisplayMetrics().heightPixels;
        this.mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        try {
            if (this.isCurrentPlay()) {
                NORMAL_ORIENTATION = ((AppCompatActivity)context).getRequestedOrientation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setUp(String url, String title, int screen) {
        this.setUp(new JZDataSource(url, title), screen);
    }

    public void setUp(JZDataSource jzDataSource, int screen) {
        if (this.jzDataSource != null && jzDataSource.getCurrentUrl() != null && this.jzDataSource.containsTheUrl(jzDataSource.getCurrentUrl())) {
            return;
        }
        if (this.isCurrentJZVD() && jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl())) {
            long position = 0L;
            try {
                position = JZMediaManager.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
            if (position != 0L) {
                JZUtils.saveProgress(this.getContext(), JZMediaManager.getCurrentUrl(), position);
            }
            JZMediaManager.instance().releaseMediaPlayer();
        } else if (this.isCurrentJZVD() && !jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl())) {
            this.startWindowTiny();
        } else if (!this.isCurrentJZVD() && jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl())) {
            if (JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd().currentScreen == 3) {
                this.tmp_test_back = true;
            }
        } else if (this.isCurrentJZVD() || !jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl())) {
            // empty if block
        }
        this.jzDataSource = jzDataSource;
        this.currentScreen = screen;
        this.onStateNormal();
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.start) {
            Log.i((String)TAG, (String)("onClick start [" + ((Object)((Object)this)).hashCode() + "] "));
            if (this.jzDataSource.urlsMap.isEmpty() || this.jzDataSource.getCurrentUrl() == null) {
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getResources().getString(R.string.no_url), (int)0).show();
                return;
            }
            if (this.currentState == 0) {
                if (!(this.jzDataSource.getCurrentUrl().toString().startsWith("file") || this.jzDataSource.getCurrentUrl().toString().startsWith("/") || JZUtils.isWifiConnected(this.getContext()) || WIFI_TIP_DIALOG_SHOWED)) {
                    this.showWifiDialog();
                    return;
                }
                this.startVideo();
                this.onEvent(0);
            } else if (this.currentState == 3) {
                this.onEvent(3);
                Log.d((String)TAG, (String)("pauseVideo [" + ((Object)((Object)this)).hashCode() + "] "));
                JZMediaManager.pause();
                this.onStatePause();
            } else if (this.currentState == 5) {
                this.onEvent(4);
                JZMediaManager.start();
                this.onStatePlaying();
            } else if (this.currentState == 6) {
                this.onEvent(2);
                this.startVideo();
            }
        } else if (i == R.id.fullscreen) {
            Log.i((String)TAG, (String)("onClick fullscreen [" + ((Object)((Object)this)).hashCode() + "] "));
            if (this.currentState == 6) {
                return;
            }
            if (this.currentScreen == 2) {
                Jzvd.backPress();
            } else {
                Log.d((String)TAG, (String)("toFullscreenActivity [" + ((Object)((Object)this)).hashCode() + "] "));
                this.onEvent(7);
                this.startWindowFullscreen();
            }
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        int id2 = v.getId();
        if (id2 == R.id.surface_container) {
            switch (event.getAction()) {
                case 0: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionDown [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = true;
                    this.mDownX = x;
                    this.mDownY = y;
                    this.mChangeVolume = false;
                    this.mChangePosition = false;
                    this.mChangeBrightness = false;
                    break;
                }
                case 2: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionMove [" + ((Object)((Object)this)).hashCode() + "] "));
                    float deltaX = x - this.mDownX;
                    float deltaY = y - this.mDownY;
                    float absDeltaX = Math.abs(deltaX);
                    float absDeltaY = Math.abs(deltaY);
                    if (!(this.currentScreen != 2 || this.mChangePosition || this.mChangeVolume || this.mChangeBrightness || !(absDeltaX > 80.0f) && !(absDeltaY > 80.0f))) {
                        this.cancelProgressTimer();
                        if (absDeltaX >= 80.0f) {
                            if (this.currentState != 7) {
                                this.mChangePosition = true;
                                this.mGestureDownPosition = this.getCurrentPositionWhenPlaying();
                            }
                        } else if (this.mDownX < (float)this.mScreenWidth * 0.5f) {
                            this.mChangeBrightness = true;
                            WindowManager.LayoutParams lp = JZUtils.getWindow(this.getContext()).getAttributes();
                            if (lp.screenBrightness < 0.0f) {
                                try {
                                    this.mGestureDownBrightness = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"screen_brightness");
                                    Log.i((String)TAG, (String)("current system brightness: " + this.mGestureDownBrightness));
                                }
                                catch (Settings.SettingNotFoundException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                this.mGestureDownBrightness = lp.screenBrightness * 255.0f;
                                Log.i((String)TAG, (String)("current activity brightness: " + this.mGestureDownBrightness));
                            }
                        } else {
                            this.mChangeVolume = true;
                            this.mGestureDownVolume = this.mAudioManager.getStreamVolume(3);
                        }
                    }
                    if (this.mChangePosition) {
                        long totalTimeDuration = this.getDuration();
                        this.mSeekTimePosition = (int)((float)this.mGestureDownPosition + deltaX * (float)totalTimeDuration / (float)this.mScreenWidth);
                        if (this.mSeekTimePosition > totalTimeDuration) {
                            this.mSeekTimePosition = totalTimeDuration;
                        }
                        String seekTime = JZUtils.stringForTime(this.mSeekTimePosition);
                        String totalTime = JZUtils.stringForTime(totalTimeDuration);
                        this.showProgressDialog(deltaX, seekTime, this.mSeekTimePosition, totalTime, totalTimeDuration);
                    }
                    if (this.mChangeVolume) {
                        deltaY = -deltaY;
                        int max = this.mAudioManager.getStreamMaxVolume(3);
                        int deltaV = (int)((float)max * deltaY * 3.0f / (float)this.mScreenHeight);
                        this.mAudioManager.setStreamVolume(3, this.mGestureDownVolume + deltaV, 0);
                        int volumePercent = (int)((float)(this.mGestureDownVolume * 100 / max) + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                        this.showVolumeDialog(-deltaY, volumePercent);
                    }
                    if (!this.mChangeBrightness) break;
                    deltaY = -deltaY;
                    int deltaV = (int)(255.0f * deltaY * 3.0f / (float)this.mScreenHeight);
                    WindowManager.LayoutParams params = JZUtils.getWindow(this.getContext()).getAttributes();
                    params.screenBrightness = (this.mGestureDownBrightness + (float)deltaV) / 255.0f >= 1.0f ? 1.0f : ((this.mGestureDownBrightness + (float)deltaV) / 255.0f <= 0.0f ? 0.01f : (this.mGestureDownBrightness + (float)deltaV) / 255.0f);
                    JZUtils.getWindow(this.getContext()).setAttributes(params);
                    int brightnessPercent = (int)(this.mGestureDownBrightness * 100.0f / 255.0f + deltaY * 3.0f * 100.0f / (float)this.mScreenHeight);
                    this.showBrightnessDialog(brightnessPercent);
                    break;
                }
                case 1: {
                    Log.i((String)TAG, (String)("onTouch surfaceContainer actionUp [" + ((Object)((Object)this)).hashCode() + "] "));
                    this.mTouchingProgressBar = false;
                    this.dismissProgressDialog();
                    this.dismissVolumeDialog();
                    this.dismissBrightnessDialog();
                    if (this.mChangePosition) {
                        this.onEvent(12);
                        JZMediaManager.seekTo(this.mSeekTimePosition);
                        long duration = this.getDuration();
                        int progress = (int)(this.mSeekTimePosition * 100L / (duration == 0L ? 1L : duration));
                        this.progressBar.setProgress(progress);
                    }
                    if (this.mChangeVolume) {
                        this.onEvent(11);
                    }
                    this.startProgressTimer();
                }
            }
        }
        return false;
    }

    public void startVideo() {
        JzvdMgr.completeAll();
        Log.d((String)TAG, (String)("startVideo [" + ((Object)((Object)this)).hashCode() + "] "));
        this.initTextureView();
        this.addTextureView();
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.requestAudioFocus(onAudioFocusChangeListener, 3, 2);
        JZUtils.scanForActivity(this.getContext()).getWindow().addFlags(128);
        JZMediaManager.setDataSource(this.jzDataSource);
        JZMediaManager.instance().positionInList = this.positionInList;
        this.onStatePreparing();
        JzvdMgr.setFirstFloor(this);
    }

    public void onPrepared() {
        Log.i((String)TAG, (String)("onPrepared  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onStatePrepared();
        this.onStatePlaying();
    }

    public void setState(int state) {
        this.setState(state, 0, 0);
    }

    public void setState(int state, int urlMapIndex, int seekToInAdvance) {
        switch (state) {
            case 0: {
                this.onStateNormal();
                break;
            }
            case 1: {
                this.onStatePreparing();
                break;
            }
            case 2: {
                this.changeUrl(urlMapIndex, (long)seekToInAdvance);
                break;
            }
            case 3: {
                this.onStatePlaying();
                break;
            }
            case 5: {
                this.onStatePause();
                break;
            }
            case 7: {
                this.onStateError();
                break;
            }
            case 6: {
                this.onStateAutoComplete();
            }
        }
    }

    public void onStateNormal() {
        Log.i((String)TAG, (String)("onStateNormal  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 0;
        this.cancelProgressTimer();
    }

    public void onStatePreparing() {
        Log.i((String)TAG, (String)("onStatePreparing  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 1;
        this.resetProgressAndTime();
    }

    public void changeUrl(int urlMapIndex, long seekToInAdvance) {
        this.currentState = 2;
        this.seekToInAdvance = seekToInAdvance;
        this.jzDataSource.currentUrlIndex = urlMapIndex;
        JZMediaManager.setDataSource(this.jzDataSource);
        JZMediaManager.instance().prepare();
    }

    public void changeUrl(JZDataSource jzDataSource, long seekToInAdvance) {
        this.currentState = 2;
        this.seekToInAdvance = seekToInAdvance;
        this.jzDataSource = jzDataSource;
        if (JzvdMgr.getSecondFloor() != null && JzvdMgr.getFirstFloor() != null) {
            JzvdMgr.getFirstFloor().jzDataSource = jzDataSource;
        }
        JZMediaManager.setDataSource(jzDataSource);
        JZMediaManager.instance().prepare();
    }

    public void changeUrl(String url, String title, long seekToInAdvance) {
        this.changeUrl(new JZDataSource(url, title), seekToInAdvance);
    }

    public void onStatePrepared() {
        if (this.seekToInAdvance != 0L) {
            JZMediaManager.seekTo(this.seekToInAdvance);
            this.seekToInAdvance = 0L;
        } else {
            long position = JZUtils.getSavedProgress(this.getContext(), this.jzDataSource.getCurrentUrl());
            if (position != 0L) {
                JZMediaManager.seekTo(position);
            }
        }
    }

    public void onStatePlaying() {
        Log.i((String)TAG, (String)("onStatePlaying  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 3;
        this.startProgressTimer();
    }

    public void onStatePause() {
        Log.i((String)TAG, (String)("onStatePause  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 5;
        this.startProgressTimer();
    }

    public void onStateError() {
        Log.i((String)TAG, (String)("onStateError  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 7;
        this.cancelProgressTimer();
    }

    public void onStateAutoComplete() {
        Log.i((String)TAG, (String)("onStateAutoComplete  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = 6;
        this.cancelProgressTimer();
        this.progressBar.setProgress(100);
        this.currentTimeTextView.setText(this.totalTimeTextView.getText());
    }

    public void onInfo(int what, int extra) {
        Log.d((String)TAG, (String)("onInfo what - " + what + " extra - " + extra));
    }

    public void onError(int what, int extra) {
        Log.e((String)TAG, (String)("onError " + what + " - " + extra + " [" + ((Object)((Object)this)).hashCode() + "] "));
        if (what != 38 && extra != -38 && what != -38 && extra != 38 && extra != -19) {
            this.onStateError();
            if (this.isCurrentPlay()) {
                JZMediaManager.instance().releaseMediaPlayer();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.currentScreen == 2 || this.currentScreen == 3) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (this.widthRatio != 0 && this.heightRatio != 0) {
            int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int specHeight = (int)((float)specWidth * (float)this.heightRatio / (float)this.widthRatio);
            this.setMeasuredDimension(specWidth, specHeight);
            int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specWidth, (int)0x40000000);
            int childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)specHeight, (int)0x40000000);
            this.getChildAt(0).measure(childWidthMeasureSpec, childHeightMeasureSpec);
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    public void onAutoCompletion() {
        Runtime.getRuntime().gc();
        Log.i((String)TAG, (String)("onAutoCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(6);
        this.dismissVolumeDialog();
        this.dismissProgressDialog();
        this.dismissBrightnessDialog();
        this.onStateAutoComplete();
        if (this.currentScreen == 2 || this.currentScreen == 3) {
            Jzvd.backPress();
        }
        JZMediaManager.instance().releaseMediaPlayer();
        JZUtils.saveProgress(this.getContext(), this.jzDataSource.getCurrentUrl(), 0L);
    }

    public void onCompletion() {
        Log.i((String)TAG, (String)("onCompletion  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (this.currentState == 3 || this.currentState == 5) {
            long position = this.getCurrentPositionWhenPlaying();
            JZUtils.saveProgress(this.getContext(), this.jzDataSource.getCurrentUrl(), position);
        }
        this.cancelProgressTimer();
        this.dismissBrightnessDialog();
        this.dismissProgressDialog();
        this.dismissVolumeDialog();
        this.onStateNormal();
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        JZMediaManager.instance().currentVideoWidth = 0;
        JZMediaManager.instance().currentVideoHeight = 0;
        AudioManager mAudioManager = (AudioManager)this.getContext().getSystemService("audio");
        mAudioManager.abandonAudioFocus(onAudioFocusChangeListener);
        JZUtils.scanForActivity(this.getContext()).getWindow().clearFlags(128);
        this.clearFullscreenLayout();
        JZUtils.setRequestedOrientation(this.getContext(), NORMAL_ORIENTATION);
        if (JZMediaManager.surface != null) {
            JZMediaManager.surface.release();
        }
        if (JZMediaManager.savedSurfaceTexture != null) {
            JZMediaManager.savedSurfaceTexture.release();
        }
        JZMediaManager.textureView = null;
        JZMediaManager.savedSurfaceTexture = null;
    }

    public void release() {
        if (!(!this.jzDataSource.getCurrentUrl().equals(JZMediaManager.getCurrentUrl()) || System.currentTimeMillis() - CLICK_QUIT_FULLSCREEN_TIME <= 300L || JzvdMgr.getSecondFloor() != null && JzvdMgr.getSecondFloor().currentScreen == 2 || JzvdMgr.getSecondFloor() == null && JzvdMgr.getFirstFloor() != null && JzvdMgr.getFirstFloor().currentScreen == 2)) {
            Log.d((String)TAG, (String)("releaseMediaPlayer [" + ((Object)((Object)this)).hashCode() + "]"));
            Jzvd.releaseAllVideos();
        }
    }

    public void initTextureView() {
        this.removeTextureView();
        JZMediaManager.textureView = new JZTextureView(this.getContext());
        JZMediaManager.textureView.setSurfaceTextureListener(JZMediaManager.instance());
    }

    public void addTextureView() {
        Log.d((String)TAG, (String)("addTextureView [" + ((Object)((Object)this)).hashCode() + "] "));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.textureViewContainer.addView((View)JZMediaManager.textureView, (ViewGroup.LayoutParams)layoutParams);
    }

    public void removeTextureView() {
        JZMediaManager.savedSurfaceTexture = null;
        if (JZMediaManager.textureView != null && JZMediaManager.textureView.getParent() != null) {
            ((ViewGroup)JZMediaManager.textureView.getParent()).removeView((View)JZMediaManager.textureView);
        }
    }

    public void clearFullscreenLayout() {
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View oldF = vp.findViewById(R.id.jz_fullscreen_id);
        View oldT = vp.findViewById(R.id.jz_tiny_id);
        if (oldF != null) {
            vp.removeView(oldF);
        }
        if (oldT != null) {
            vp.removeView(oldT);
        }
        Jzvd.showSupportActionBar(this.getContext());
    }

    public void clearFloatScreen() {
        JZUtils.setRequestedOrientation(this.getContext(), NORMAL_ORIENTATION);
        Jzvd.showSupportActionBar(this.getContext());
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        Jzvd fullJzvd = (Jzvd)vp.findViewById(R.id.jz_fullscreen_id);
        Jzvd tinyJzvd = (Jzvd)vp.findViewById(R.id.jz_tiny_id);
        if (fullJzvd != null) {
            vp.removeView((View)fullJzvd);
            if (fullJzvd.textureViewContainer != null) {
                fullJzvd.textureViewContainer.removeView((View)JZMediaManager.textureView);
            }
        }
        if (tinyJzvd != null) {
            vp.removeView((View)tinyJzvd);
            if (tinyJzvd.textureViewContainer != null) {
                tinyJzvd.textureViewContainer.removeView((View)JZMediaManager.textureView);
            }
        }
        JzvdMgr.setSecondFloor(null);
    }

    public void onVideoSizeChanged() {
        Log.i((String)TAG, (String)("onVideoSizeChanged  [" + ((Object)((Object)this)).hashCode() + "] "));
        if (JZMediaManager.textureView != null) {
            if (this.videoRotation != 0) {
                JZMediaManager.textureView.setRotation(this.videoRotation);
            }
            JZMediaManager.textureView.setVideoSize(JZMediaManager.instance().currentVideoWidth, JZMediaManager.instance().currentVideoHeight);
        }
    }

    public void startProgressTimer() {
        Log.i((String)TAG, (String)("startProgressTimer:  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.cancelProgressTimer();
        UPDATE_PROGRESS_TIMER = new Timer();
        this.mProgressTimerTask = new ProgressTimerTask();
        UPDATE_PROGRESS_TIMER.schedule((TimerTask)this.mProgressTimerTask, 0L, 300L);
    }

    public void cancelProgressTimer() {
        if (UPDATE_PROGRESS_TIMER != null) {
            UPDATE_PROGRESS_TIMER.cancel();
        }
        if (this.mProgressTimerTask != null) {
            this.mProgressTimerTask.cancel();
        }
    }

    public void setProgressAndText(int progress, long position, long duration) {
        if (!this.mTouchingProgressBar && progress != 0) {
            this.progressBar.setProgress(progress);
        }
        if (position != 0L) {
            this.currentTimeTextView.setText((CharSequence)JZUtils.stringForTime(position));
        }
        this.totalTimeTextView.setText((CharSequence)JZUtils.stringForTime(duration));
    }

    public void setBufferProgress(int bufferProgress) {
        if (bufferProgress != 0) {
            this.progressBar.setSecondaryProgress(bufferProgress);
        }
    }

    public void resetProgressAndTime() {
        this.progressBar.setProgress(0);
        this.progressBar.setSecondaryProgress(0);
        this.currentTimeTextView.setText((CharSequence)JZUtils.stringForTime(0L));
        this.totalTimeTextView.setText((CharSequence)JZUtils.stringForTime(0L));
    }

    public long getCurrentPositionWhenPlaying() {
        long position = 0L;
        if (this.currentState == 3 || this.currentState == 5) {
            try {
                position = JZMediaManager.getCurrentPosition();
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
                return position;
            }
        }
        return position;
    }

    public long getDuration() {
        long duration = 0L;
        try {
            duration = JZMediaManager.getDuration();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
            return duration;
        }
        return duration;
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStartTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.cancelProgressTimer();
        for (ViewParent vpdown = this.getParent(); vpdown != null; vpdown = vpdown.getParent()) {
            vpdown.requestDisallowInterceptTouchEvent(true);
        }
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        Log.i((String)TAG, (String)("bottomProgress onStopTrackingTouch [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(5);
        this.startProgressTimer();
        for (ViewParent vpup = this.getParent(); vpup != null; vpup = vpup.getParent()) {
            vpup.requestDisallowInterceptTouchEvent(false);
        }
        if (this.currentState != 3 && this.currentState != 5) {
            return;
        }
        long time = (long)seekBar.getProgress() * this.getDuration() / 100L;
        JZMediaManager.seekTo(time);
        Log.i((String)TAG, (String)("seekTo " + time + " [" + ((Object)((Object)this)).hashCode() + "] "));
    }

    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        if (fromUser) {
            long duration = this.getDuration();
            this.currentTimeTextView.setText((CharSequence)JZUtils.stringForTime((long)progress * duration / 100L));
        }
    }

    public void startWindowFullscreen() {
        Log.i((String)TAG, (String)("startWindowFullscreen  [" + ((Object)((Object)this)).hashCode() + "] "));
        Jzvd.hideSupportActionBar(this.getContext());
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(R.id.jz_fullscreen_id);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            Jzvd jzvd = (Jzvd)((Object)constructor.newInstance(this.getContext()));
            jzvd.setId(R.id.jz_fullscreen_id);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
            vp.addView((View)jzvd, (ViewGroup.LayoutParams)lp);
            jzvd.setSystemUiVisibility(4102);
            jzvd.setUp(this.jzDataSource, 2);
            jzvd.setState(this.currentState);
            jzvd.addTextureView();
            JzvdMgr.setSecondFloor(jzvd);
            JZUtils.setRequestedOrientation(this.getContext(), FULLSCREEN_ORIENTATION);
            this.onStateNormal();
            jzvd.progressBar.setSecondaryProgress(this.progressBar.getSecondaryProgress());
            jzvd.startProgressTimer();
            CLICK_QUIT_FULLSCREEN_TIME = System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startWindowTiny() {
        Log.i((String)TAG, (String)("startWindowTiny  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.onEvent(9);
        if (this.currentState == 0 || this.currentState == 7 || this.currentState == 6) {
            return;
        }
        ViewGroup vp = (ViewGroup)JZUtils.scanForActivity(this.getContext()).findViewById(0x1020002);
        View old = vp.findViewById(R.id.jz_tiny_id);
        if (old != null) {
            vp.removeView(old);
        }
        this.textureViewContainer.removeView((View)JZMediaManager.textureView);
        try {
            Constructor<?> constructor = ((Object)((Object)this)).getClass().getConstructor(Context.class);
            Jzvd jzvd = (Jzvd)((Object)constructor.newInstance(this.getContext()));
            jzvd.setId(R.id.jz_tiny_id);
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(400, 400);
            lp.gravity = 85;
            vp.addView((View)jzvd, (ViewGroup.LayoutParams)lp);
            jzvd.setUp(this.jzDataSource, 3);
            jzvd.setState(this.currentState);
            jzvd.addTextureView();
            JzvdMgr.setSecondFloor(jzvd);
            this.onStateNormal();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isCurrentPlay() {
        return this.isCurrentJZVD() && this.jzDataSource.containsTheUrl(JZMediaManager.getCurrentUrl());
    }

    public boolean isCurrentJZVD() {
        return JzvdMgr.getCurrentJzvd() != null && JzvdMgr.getCurrentJzvd() == this;
    }

    public void playOnThisJzvd() {
        Log.i((String)TAG, (String)("playOnThisJzvd  [" + ((Object)((Object)this)).hashCode() + "] "));
        this.currentState = JzvdMgr.getSecondFloor().currentState;
        this.clearFloatScreen();
        this.setState(this.currentState);
        this.addTextureView();
    }

    public void autoFullscreen(float x) {
        if (this.isCurrentPlay() && (this.currentState == 3 || this.currentState == 5) && this.currentScreen != 2 && this.currentScreen != 3) {
            if (x > 0.0f) {
                JZUtils.setRequestedOrientation(this.getContext(), 0);
            } else {
                JZUtils.setRequestedOrientation(this.getContext(), 8);
            }
            this.onEvent(7);
            this.startWindowFullscreen();
        }
    }

    public void autoQuitFullscreen() {
        if (System.currentTimeMillis() - lastAutoFullscreenTime > 2000L && this.isCurrentPlay() && this.currentState == 3 && this.currentScreen == 2) {
            lastAutoFullscreenTime = System.currentTimeMillis();
            Jzvd.backPress();
        }
    }

    public void onEvent(int type) {
        if (JZ_USER_EVENT != null && this.isCurrentPlay() && !this.jzDataSource.urlsMap.isEmpty()) {
            JZ_USER_EVENT.onEvent(type, this.jzDataSource.getCurrentUrl(), this.currentScreen, new Object[0]);
        }
    }

    public static void setMediaInterface(JZMediaInterface mediaInterface) {
        JZMediaManager.instance().jzMediaInterface = mediaInterface;
    }

    public void onSeekComplete() {
    }

    public void showWifiDialog() {
    }

    public void showProgressDialog(float deltaX, String seekTime, long seekTimePosition, String totalTime, long totalTimeDuration) {
    }

    public void dismissProgressDialog() {
    }

    public void showVolumeDialog(float deltaY, int volumePercent) {
    }

    public void dismissVolumeDialog() {
    }

    public void showBrightnessDialog(int brightnessPercent) {
    }

    public void dismissBrightnessDialog() {
    }

    static {
        ON_PLAY_PAUSE_TMP_STATE = 0;
    }

    public class ProgressTimerTask
    extends TimerTask {
        @Override
        public void run() {
            if (Jzvd.this.currentState == 3 || Jzvd.this.currentState == 5) {
                Jzvd.this.post(new Runnable(){

                    @Override
                    public void run() {
                        long position = Jzvd.this.getCurrentPositionWhenPlaying();
                        long duration = Jzvd.this.getDuration();
                        int progress = (int)(position * 100L / (duration == 0L ? 1L : duration));
                        Jzvd.this.setProgressAndText(progress, position, duration);
                    }
                });
            }
        }
    }

    public static class JZAutoFullscreenListener
    implements SensorEventListener {
        public void onSensorChanged(SensorEvent event) {
            float x = event.values[0];
            float y = event.values[1];
            float z = event.values[2];
            if ((x < -12.0f || x > 12.0f) && System.currentTimeMillis() - lastAutoFullscreenTime > 2000L) {
                if (JzvdMgr.getCurrentJzvd() != null) {
                    JzvdMgr.getCurrentJzvd().autoFullscreen(x);
                }
                lastAutoFullscreenTime = System.currentTimeMillis();
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    }
}

