/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.schedule.model;

import cn.jiguang.common.utils.StringUtils;
import cn.jpush.api.push.model.PushPayload;
import cn.jpush.api.schedule.model.IModel;
import cn.jpush.api.schedule.model.TriggerPayload;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class SchedulePayload
implements IModel {
    private static final String CID = "cid";
    private static final String NAME = "name";
    private static final String ENABLED = "enabled";
    private static final String TRIGGER = "trigger";
    private static final String PUSH = "push";
    private static Gson gson = new Gson();
    private String cid;
    private String name;
    private Boolean enabled;
    private TriggerPayload trigger;
    private PushPayload push;

    private SchedulePayload(String cid, String name, Boolean enabled, TriggerPayload trigger, PushPayload push) {
        this.cid = cid;
        this.name = name;
        this.enabled = enabled;
        this.trigger = trigger;
        this.push = push;
    }

    public SchedulePayload setCid(String cid) {
        this.cid = cid;
        return this;
    }

    public String getCid() {
        return this.cid;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = new JsonObject();
        if (null != this.cid) {
            json.addProperty(CID, this.cid);
        }
        if (StringUtils.isNotEmpty((String)this.name)) {
            json.addProperty(NAME, this.name);
        }
        if (null != this.enabled) {
            json.addProperty(ENABLED, this.enabled);
        }
        if (null != this.trigger) {
            json.add(TRIGGER, this.trigger.toJSON());
        }
        if (null != this.push) {
            json.add(PUSH, this.push.toJSON());
        }
        return json;
    }

    public String toString() {
        return gson.toJson(this.toJSON());
    }

    public void resetPushApnsProduction(boolean apnsProduction) {
        if (null != this.push) {
            this.push.resetOptionsApnsProduction(apnsProduction);
        }
    }

    public void resetPushTimeToLive(long timeToLive) {
        if (null != this.push) {
            this.push.resetOptionsTimeToLive(timeToLive);
        }
    }

    public static class Builder {
        private String cid;
        private String name;
        private Boolean enabled;
        private TriggerPayload trigger;
        private PushPayload push;

        public Builder setCid(String cid) {
            this.cid = cid;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEnabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setTrigger(TriggerPayload trigger) {
            this.trigger = trigger;
            return this;
        }

        public Builder setPush(PushPayload push) {
            this.push = push;
            return this;
        }

        public SchedulePayload build() {
            return new SchedulePayload(this.cid, this.name, this.enabled, this.trigger, this.push);
        }
    }
}

