/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.messages;

import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.enums.ToolCallStatus;
import cn.iflow.sdk.types.messages.Message;
import cn.iflow.sdk.types.messages.ToolCallConfirmation;
import cn.iflow.sdk.types.messages.ToolCallContent;
import cn.iflow.sdk.types.messages.ToolCallLocation;
import cn.iflow.sdk.types.protocol.AgentInfo;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class ToolResultMessage
implements Message {
    private final String id;
    private final ToolCallStatus status;
    private final String toolName;
    private final ToolCallContent content;
    private final List<ToolCallLocation> locations;
    private final ToolCallConfirmation confirmation;
    private final String agentId;
    private final AgentInfo agentInfo;
    private final Map<String, Object> args;
    private final long timestamp;

    public ToolResultMessage(String id, ToolCallStatus status, String toolName, ToolCallContent content, List<ToolCallLocation> locations, ToolCallConfirmation confirmation, String agentId, AgentInfo agentInfo, Map<String, Object> args, long timestamp) {
        this.id = id;
        this.status = status;
        this.toolName = toolName;
        this.content = content;
        this.locations = locations;
        this.confirmation = confirmation;
        this.agentId = agentId;
        this.agentInfo = agentInfo;
        this.args = args;
        this.timestamp = timestamp;
    }

    public ToolResultMessage(String id, ToolCallStatus status, String toolName, ToolCallContent content, List<ToolCallLocation> locations, ToolCallConfirmation confirmation, String agentId, AgentInfo agentInfo, Map<String, Object> args) {
        this(id, status, toolName, content, locations, confirmation, agentId, agentInfo, args, System.currentTimeMillis() / 1000L);
    }

    @Override
    public MessageType getType() {
        return MessageType.TOOL_CALL_RESULT;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Optional<String> getAgentId() {
        return Optional.ofNullable(this.agentId);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ToolResultMessage)) {
            return false;
        }
        ToolResultMessage other = (ToolResultMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ToolCallStatus this$status = this.getStatus();
        ToolCallStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$toolName = this.getToolName();
        String other$toolName = other.getToolName();
        if (this$toolName == null ? other$toolName != null : !this$toolName.equals(other$toolName)) {
            return false;
        }
        ToolCallContent this$content = this.getContent();
        ToolCallContent other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        List<ToolCallLocation> this$locations = this.getLocations();
        List<ToolCallLocation> other$locations = other.getLocations();
        if (this$locations == null ? other$locations != null : !((Object)this$locations).equals(other$locations)) {
            return false;
        }
        ToolCallConfirmation this$confirmation = this.getConfirmation();
        ToolCallConfirmation other$confirmation = other.getConfirmation();
        if (this$confirmation == null ? other$confirmation != null : !((Object)this$confirmation).equals(other$confirmation)) {
            return false;
        }
        Optional<String> this$agentId = this.getAgentId();
        Optional<String> other$agentId = other.getAgentId();
        if (this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId)) {
            return false;
        }
        AgentInfo this$agentInfo = this.getAgentInfo();
        AgentInfo other$agentInfo = other.getAgentInfo();
        if (this$agentInfo == null ? other$agentInfo != null : !this$agentInfo.equals(other$agentInfo)) {
            return false;
        }
        Map<String, Object> this$args = this.getArgs();
        Map<String, Object> other$args = other.getArgs();
        return !(this$args == null ? other$args != null : !((Object)this$args).equals(other$args));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ToolResultMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ToolCallStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $toolName = this.getToolName();
        result = result * 59 + ($toolName == null ? 43 : $toolName.hashCode());
        ToolCallContent $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        List<ToolCallLocation> $locations = this.getLocations();
        result = result * 59 + ($locations == null ? 43 : ((Object)$locations).hashCode());
        ToolCallConfirmation $confirmation = this.getConfirmation();
        result = result * 59 + ($confirmation == null ? 43 : ((Object)$confirmation).hashCode());
        Optional<String> $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        AgentInfo $agentInfo = this.getAgentInfo();
        result = result * 59 + ($agentInfo == null ? 43 : $agentInfo.hashCode());
        Map<String, Object> $args = this.getArgs();
        result = result * 59 + ($args == null ? 43 : ((Object)$args).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ToolResultMessage(id=" + this.getId() + ", status=" + this.getStatus() + ", toolName=" + this.getToolName() + ", content=" + this.getContent() + ", locations=" + this.getLocations() + ", confirmation=" + this.getConfirmation() + ", agentId=" + this.getAgentId() + ", agentInfo=" + this.getAgentInfo() + ", args=" + this.getArgs() + ", timestamp=" + this.getTimestamp() + ")";
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ToolCallStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getToolName() {
        return this.toolName;
    }

    @Generated
    public ToolCallContent getContent() {
        return this.content;
    }

    @Generated
    public List<ToolCallLocation> getLocations() {
        return this.locations;
    }

    @Generated
    public ToolCallConfirmation getConfirmation() {
        return this.confirmation;
    }

    @Generated
    public AgentInfo getAgentInfo() {
        return this.agentInfo;
    }

    @Generated
    public Map<String, Object> getArgs() {
        return this.args;
    }
}

