/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.messages;

import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.enums.StopReason;
import cn.iflow.sdk.types.messages.Message;
import java.util.Optional;
import lombok.Generated;

public class TaskFinishMessage
implements Message {
    private final StopReason stopReason;
    private final String agentId;
    private final long timestamp;

    public TaskFinishMessage(StopReason stopReason, String agentId, long timestamp) {
        this.stopReason = stopReason;
        this.agentId = agentId;
        this.timestamp = timestamp;
    }

    public TaskFinishMessage(StopReason stopReason, String agentId) {
        this(stopReason, agentId, System.currentTimeMillis());
    }

    public TaskFinishMessage(StopReason stopReason) {
        this(stopReason, null, System.currentTimeMillis());
    }

    @Override
    public MessageType getType() {
        return MessageType.TASK_FINISH;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Optional<String> getAgentId() {
        return Optional.ofNullable(this.agentId);
    }

    @Generated
    public StopReason getStopReason() {
        return this.stopReason;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskFinishMessage)) {
            return false;
        }
        TaskFinishMessage other = (TaskFinishMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        StopReason this$stopReason = this.getStopReason();
        StopReason other$stopReason = other.getStopReason();
        if (this$stopReason == null ? other$stopReason != null : !((Object)((Object)this$stopReason)).equals((Object)other$stopReason)) {
            return false;
        }
        Optional<String> this$agentId = this.getAgentId();
        Optional<String> other$agentId = other.getAgentId();
        return !(this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TaskFinishMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        StopReason $stopReason = this.getStopReason();
        result = result * 59 + ($stopReason == null ? 43 : ((Object)((Object)$stopReason)).hashCode());
        Optional<String> $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TaskFinishMessage(stopReason=" + this.getStopReason() + ", agentId=" + this.getAgentId() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

