/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.messages;

import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.messages.Message;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class PlanMessage
implements Message {
    private final List<PlanEntry> entries;
    private final String agentId;
    private final long timestamp;

    public PlanMessage(List<PlanEntry> entries, String agentId, long timestamp) {
        this.entries = entries;
        this.agentId = agentId;
        this.timestamp = timestamp;
    }

    public PlanMessage(List<PlanEntry> entries, String agentId) {
        this(entries, agentId, System.currentTimeMillis());
    }

    public PlanMessage(List<PlanEntry> entries) {
        this(entries, null, System.currentTimeMillis());
    }

    @Override
    public MessageType getType() {
        return MessageType.PLAN;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Optional<String> getAgentId() {
        return Optional.ofNullable(this.agentId);
    }

    public String toString() {
        return "PlanMessage{entries=" + this.entries + ", agentId=" + this.agentId + ", timestamp=" + this.timestamp + "}";
    }

    @Generated
    public List<PlanEntry> getEntries() {
        return this.entries;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlanMessage)) {
            return false;
        }
        PlanMessage other = (PlanMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        List<PlanEntry> this$entries = this.getEntries();
        List<PlanEntry> other$entries = other.getEntries();
        if (this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries)) {
            return false;
        }
        Optional<String> this$agentId = this.getAgentId();
        Optional<String> other$agentId = other.getAgentId();
        return !(this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PlanMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        List<PlanEntry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        Optional<String> $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        return result;
    }

    public static class PlanEntry {
        private final String id;
        private final String content;
        private final String status;
        private final String priority;

        public PlanEntry(String id, String content, String status, String priority) {
            this.id = id;
            this.content = content;
            this.status = status;
            this.priority = priority;
        }

        public String getId() {
            return this.id;
        }

        public String getContent() {
            return this.content;
        }

        public String getStatus() {
            return this.status;
        }

        public String getPriority() {
            return this.priority;
        }

        public String toString() {
            return "PlanEntry{id='" + this.id + "', content='" + this.content + "', status='" + this.status + "', priority='" + this.priority + "'}";
        }
    }
}

