/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.messages;

import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.messages.Message;
import java.util.Optional;
import lombok.Generated;

public class AssistantMessage
implements Message {
    private final AssistantMessageChunk chunk;
    private final String agentId;
    private final long timestamp;

    public AssistantMessage(AssistantMessageChunk chunk, String agentId, long timestamp) {
        this.chunk = chunk;
        this.agentId = agentId;
        this.timestamp = timestamp;
    }

    public AssistantMessage(AssistantMessageChunk chunk, String agentId) {
        this(chunk, agentId, System.currentTimeMillis());
    }

    public AssistantMessage(AssistantMessageChunk chunk) {
        this(chunk, null, System.currentTimeMillis());
    }

    @Override
    public MessageType getType() {
        return MessageType.ASSISTANT_MESSAGE;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Optional<String> getAgentId() {
        return Optional.ofNullable(this.agentId);
    }

    @Generated
    public AssistantMessageChunk getChunk() {
        return this.chunk;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssistantMessage)) {
            return false;
        }
        AssistantMessage other = (AssistantMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        AssistantMessageChunk this$chunk = this.getChunk();
        AssistantMessageChunk other$chunk = other.getChunk();
        if (this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk)) {
            return false;
        }
        Optional<String> this$agentId = this.getAgentId();
        Optional<String> other$agentId = other.getAgentId();
        return !(this$agentId == null ? other$agentId != null : !((Object)this$agentId).equals(other$agentId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AssistantMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        AssistantMessageChunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        Optional<String> $agentId = this.getAgentId();
        result = result * 59 + ($agentId == null ? 43 : ((Object)$agentId).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AssistantMessage(chunk=" + this.getChunk() + ", agentId=" + this.getAgentId() + ", timestamp=" + this.getTimestamp() + ")";
    }

    public static class AssistantMessageChunk {
        private final String text;
        private final String reasoning;

        public AssistantMessageChunk(String text, String reasoning) {
            this.text = text;
            this.reasoning = reasoning;
        }

        public Optional<String> getReasoning() {
            return Optional.ofNullable(this.reasoning);
        }

        @Generated
        public String getText() {
            return this.text;
        }
    }
}

