/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.types.config;

import cn.iflow.sdk.types.config.CommandConfig;
import cn.iflow.sdk.types.config.CreateAgentConfig;
import cn.iflow.sdk.types.config.HookEventConfig;
import cn.iflow.sdk.types.config.McpServerConfig;
import cn.iflow.sdk.types.config.SessionSettings;
import cn.iflow.sdk.types.enums.ApprovalMode;
import cn.iflow.sdk.types.enums.HookEventType;
import cn.iflow.sdk.types.enums.PermissionMode;
import cn.iflow.sdk.types.protocol.AuthMethodInfo;
import cn.iflow.sdk.types.protocol.requests.PermissionRequestParams;
import cn.iflow.sdk.types.protocol.responses.PermissionRequestResult;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import reactor.core.publisher.Mono;

public class IFlowOptions {
    private String url;
    private final String cwd;
    private final List<McpServerConfig> mcpServers;
    private final Map<HookEventType, List<HookEventConfig>> hooks;
    private final List<CommandConfig> commands;
    private final List<CreateAgentConfig> agents;
    private final ApprovalMode approvalMode;
    private final String authMethodId;
    private final AuthMethodInfo authMethodInfo;
    private final PermissionMode permissionMode;
    private final List<String> autoApproveTypes;
    private final Duration timeout;
    private final Map<String, Object> metadata;
    private final boolean fileAccess;
    private final List<String> fileAllowedDirs;
    private final boolean fileReadOnly;
    private final long fileMaxSize;
    private final boolean autoStartProcess;
    private final int processStartPort;
    private final String iflowExecutable;
    private final Duration processStartTimeout;
    private final SessionSettings sessionSettings;
    private final Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback;

    private IFlowOptions(Builder builder) {
        this.url = builder.url;
        this.cwd = builder.cwd;
        this.mcpServers = new ArrayList<McpServerConfig>(builder.mcpServers);
        this.hooks = builder.hooks != null ? new HashMap<HookEventType, List<HookEventConfig>>(builder.hooks) : new HashMap();
        this.commands = builder.commands != null ? new ArrayList<CommandConfig>(builder.commands) : new ArrayList();
        this.agents = builder.agents != null ? new ArrayList<CreateAgentConfig>(builder.agents) : new ArrayList();
        this.approvalMode = builder.approvalMode;
        this.authMethodId = builder.authMethodId;
        this.authMethodInfo = builder.authMethodInfo;
        this.permissionMode = builder.permissionMode;
        this.autoApproveTypes = new ArrayList<String>(builder.autoApproveTypes);
        this.timeout = builder.timeout;
        this.metadata = new HashMap<String, Object>(builder.metadata);
        this.fileAccess = builder.fileAccess;
        this.fileAllowedDirs = builder.fileAllowedDirs != null ? new ArrayList<String>(builder.fileAllowedDirs) : null;
        this.fileReadOnly = builder.fileReadOnly;
        this.fileMaxSize = builder.fileMaxSize;
        this.autoStartProcess = builder.autoStartProcess;
        this.processStartPort = builder.processStartPort;
        this.iflowExecutable = builder.iflowExecutable;
        this.processStartTimeout = builder.processStartTimeout;
        this.permissionCallback = builder.permissionCallback;
        this.sessionSettings = builder.sessionSettings;
    }

    public static IFlowOptions getDefault() {
        return IFlowOptions.builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public IFlowOptions forSandbox() {
        return this.forSandbox("wss://sandbox.iflow.ai/acp?peer=iflow");
    }

    public IFlowOptions forSandbox(String sandboxUrl) {
        return IFlowOptions.builder().url(sandboxUrl).permissionMode(this.permissionMode).autoApproveTypes(this.autoApproveTypes).timeout(this.timeout).metadata(this.metadata).build();
    }

    public List<McpServerConfig> getMcpServers() {
        return new ArrayList<McpServerConfig>(this.mcpServers);
    }

    public List<String> getAutoApproveTypes() {
        return new ArrayList<String>(this.autoApproveTypes);
    }

    public Duration getTimeoutDuration() {
        return Duration.ofMillis(this.timeout.toMillis());
    }

    public Map<String, Object> getMetadata() {
        return new HashMap<String, Object>(this.metadata);
    }

    public List<String> getFileAllowedDirs() {
        return this.fileAllowedDirs != null ? new ArrayList<String>(this.fileAllowedDirs) : null;
    }

    public Path getWorkingDirectory() {
        return Paths.get(this.cwd, new String[0]);
    }

    public String toString() {
        return "IFlowOptions{url='" + this.url + "', cwd='" + this.cwd + "', mcpServers=" + this.mcpServers.size() + " servers, permissionMode=" + this.permissionMode + ", autoApproveTypes=" + this.autoApproveTypes + ", timeout=" + this.timeout + ", fileAccess=" + this.fileAccess + ", fileAllowedDirs=" + (String)(this.fileAllowedDirs != null ? this.fileAllowedDirs.size() + " dirs" : "current dir only") + ", fileReadOnly=" + this.fileReadOnly + ", fileMaxSize=" + this.fileMaxSize + ", autoStartProcess=" + this.autoStartProcess + ", processStartPort=" + this.processStartPort + ", iflowExecutable='" + this.iflowExecutable + "', processStartTimeout=" + this.processStartTimeout + "}";
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getCwd() {
        return this.cwd;
    }

    @Generated
    public Map<HookEventType, List<HookEventConfig>> getHooks() {
        return this.hooks;
    }

    @Generated
    public List<CommandConfig> getCommands() {
        return this.commands;
    }

    @Generated
    public List<CreateAgentConfig> getAgents() {
        return this.agents;
    }

    @Generated
    public ApprovalMode getApprovalMode() {
        return this.approvalMode;
    }

    @Generated
    public String getAuthMethodId() {
        return this.authMethodId;
    }

    @Generated
    public AuthMethodInfo getAuthMethodInfo() {
        return this.authMethodInfo;
    }

    @Generated
    public PermissionMode getPermissionMode() {
        return this.permissionMode;
    }

    @Generated
    public Duration getTimeout() {
        return this.timeout;
    }

    @Generated
    public boolean isFileAccess() {
        return this.fileAccess;
    }

    @Generated
    public boolean isFileReadOnly() {
        return this.fileReadOnly;
    }

    @Generated
    public long getFileMaxSize() {
        return this.fileMaxSize;
    }

    @Generated
    public boolean isAutoStartProcess() {
        return this.autoStartProcess;
    }

    @Generated
    public int getProcessStartPort() {
        return this.processStartPort;
    }

    @Generated
    public String getIflowExecutable() {
        return this.iflowExecutable;
    }

    @Generated
    public Duration getProcessStartTimeout() {
        return this.processStartTimeout;
    }

    @Generated
    public SessionSettings getSessionSettings() {
        return this.sessionSettings;
    }

    @Generated
    public Function<PermissionRequestParams, Mono<PermissionRequestResult>> getPermissionCallback() {
        return this.permissionCallback;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IFlowOptions)) {
            return false;
        }
        IFlowOptions other = (IFlowOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isFileAccess() != other.isFileAccess()) {
            return false;
        }
        if (this.isFileReadOnly() != other.isFileReadOnly()) {
            return false;
        }
        if (this.getFileMaxSize() != other.getFileMaxSize()) {
            return false;
        }
        if (this.isAutoStartProcess() != other.isAutoStartProcess()) {
            return false;
        }
        if (this.getProcessStartPort() != other.getProcessStartPort()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$cwd = this.getCwd();
        String other$cwd = other.getCwd();
        if (this$cwd == null ? other$cwd != null : !this$cwd.equals(other$cwd)) {
            return false;
        }
        List<McpServerConfig> this$mcpServers = this.getMcpServers();
        List<McpServerConfig> other$mcpServers = other.getMcpServers();
        if (this$mcpServers == null ? other$mcpServers != null : !((Object)this$mcpServers).equals(other$mcpServers)) {
            return false;
        }
        Map<HookEventType, List<HookEventConfig>> this$hooks = this.getHooks();
        Map<HookEventType, List<HookEventConfig>> other$hooks = other.getHooks();
        if (this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks)) {
            return false;
        }
        List<CommandConfig> this$commands = this.getCommands();
        List<CommandConfig> other$commands = other.getCommands();
        if (this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands)) {
            return false;
        }
        List<CreateAgentConfig> this$agents = this.getAgents();
        List<CreateAgentConfig> other$agents = other.getAgents();
        if (this$agents == null ? other$agents != null : !((Object)this$agents).equals(other$agents)) {
            return false;
        }
        ApprovalMode this$approvalMode = this.getApprovalMode();
        ApprovalMode other$approvalMode = other.getApprovalMode();
        if (this$approvalMode == null ? other$approvalMode != null : !((Object)((Object)this$approvalMode)).equals((Object)other$approvalMode)) {
            return false;
        }
        String this$authMethodId = this.getAuthMethodId();
        String other$authMethodId = other.getAuthMethodId();
        if (this$authMethodId == null ? other$authMethodId != null : !this$authMethodId.equals(other$authMethodId)) {
            return false;
        }
        AuthMethodInfo this$authMethodInfo = this.getAuthMethodInfo();
        AuthMethodInfo other$authMethodInfo = other.getAuthMethodInfo();
        if (this$authMethodInfo == null ? other$authMethodInfo != null : !((Object)this$authMethodInfo).equals(other$authMethodInfo)) {
            return false;
        }
        PermissionMode this$permissionMode = this.getPermissionMode();
        PermissionMode other$permissionMode = other.getPermissionMode();
        if (this$permissionMode == null ? other$permissionMode != null : !((Object)((Object)this$permissionMode)).equals((Object)other$permissionMode)) {
            return false;
        }
        List<String> this$autoApproveTypes = this.getAutoApproveTypes();
        List<String> other$autoApproveTypes = other.getAutoApproveTypes();
        if (this$autoApproveTypes == null ? other$autoApproveTypes != null : !((Object)this$autoApproveTypes).equals(other$autoApproveTypes)) {
            return false;
        }
        Duration this$timeout = this.getTimeout();
        Duration other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        Map<String, Object> this$metadata = this.getMetadata();
        Map<String, Object> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<String> this$fileAllowedDirs = this.getFileAllowedDirs();
        List<String> other$fileAllowedDirs = other.getFileAllowedDirs();
        if (this$fileAllowedDirs == null ? other$fileAllowedDirs != null : !((Object)this$fileAllowedDirs).equals(other$fileAllowedDirs)) {
            return false;
        }
        String this$iflowExecutable = this.getIflowExecutable();
        String other$iflowExecutable = other.getIflowExecutable();
        if (this$iflowExecutable == null ? other$iflowExecutable != null : !this$iflowExecutable.equals(other$iflowExecutable)) {
            return false;
        }
        Duration this$processStartTimeout = this.getProcessStartTimeout();
        Duration other$processStartTimeout = other.getProcessStartTimeout();
        if (this$processStartTimeout == null ? other$processStartTimeout != null : !((Object)this$processStartTimeout).equals(other$processStartTimeout)) {
            return false;
        }
        SessionSettings this$sessionSettings = this.getSessionSettings();
        SessionSettings other$sessionSettings = other.getSessionSettings();
        if (this$sessionSettings == null ? other$sessionSettings != null : !((Object)this$sessionSettings).equals(other$sessionSettings)) {
            return false;
        }
        Function<PermissionRequestParams, Mono<PermissionRequestResult>> this$permissionCallback = this.getPermissionCallback();
        Function<PermissionRequestParams, Mono<PermissionRequestResult>> other$permissionCallback = other.getPermissionCallback();
        return !(this$permissionCallback == null ? other$permissionCallback != null : !this$permissionCallback.equals(other$permissionCallback));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IFlowOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFileAccess() ? 79 : 97);
        result = result * 59 + (this.isFileReadOnly() ? 79 : 97);
        long $fileMaxSize = this.getFileMaxSize();
        result = result * 59 + (int)($fileMaxSize >>> 32 ^ $fileMaxSize);
        result = result * 59 + (this.isAutoStartProcess() ? 79 : 97);
        result = result * 59 + this.getProcessStartPort();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $cwd = this.getCwd();
        result = result * 59 + ($cwd == null ? 43 : $cwd.hashCode());
        List<McpServerConfig> $mcpServers = this.getMcpServers();
        result = result * 59 + ($mcpServers == null ? 43 : ((Object)$mcpServers).hashCode());
        Map<HookEventType, List<HookEventConfig>> $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        List<CommandConfig> $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        List<CreateAgentConfig> $agents = this.getAgents();
        result = result * 59 + ($agents == null ? 43 : ((Object)$agents).hashCode());
        ApprovalMode $approvalMode = this.getApprovalMode();
        result = result * 59 + ($approvalMode == null ? 43 : ((Object)((Object)$approvalMode)).hashCode());
        String $authMethodId = this.getAuthMethodId();
        result = result * 59 + ($authMethodId == null ? 43 : $authMethodId.hashCode());
        AuthMethodInfo $authMethodInfo = this.getAuthMethodInfo();
        result = result * 59 + ($authMethodInfo == null ? 43 : ((Object)$authMethodInfo).hashCode());
        PermissionMode $permissionMode = this.getPermissionMode();
        result = result * 59 + ($permissionMode == null ? 43 : ((Object)((Object)$permissionMode)).hashCode());
        List<String> $autoApproveTypes = this.getAutoApproveTypes();
        result = result * 59 + ($autoApproveTypes == null ? 43 : ((Object)$autoApproveTypes).hashCode());
        Duration $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        Map<String, Object> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<String> $fileAllowedDirs = this.getFileAllowedDirs();
        result = result * 59 + ($fileAllowedDirs == null ? 43 : ((Object)$fileAllowedDirs).hashCode());
        String $iflowExecutable = this.getIflowExecutable();
        result = result * 59 + ($iflowExecutable == null ? 43 : $iflowExecutable.hashCode());
        Duration $processStartTimeout = this.getProcessStartTimeout();
        result = result * 59 + ($processStartTimeout == null ? 43 : ((Object)$processStartTimeout).hashCode());
        SessionSettings $sessionSettings = this.getSessionSettings();
        result = result * 59 + ($sessionSettings == null ? 43 : ((Object)$sessionSettings).hashCode());
        Function<PermissionRequestParams, Mono<PermissionRequestResult>> $permissionCallback = this.getPermissionCallback();
        result = result * 59 + ($permissionCallback == null ? 43 : $permissionCallback.hashCode());
        return result;
    }

    public static class Builder {
        private String url = "ws://localhost:8090/acp";
        private String cwd = System.getProperty("user.dir");
        private List<McpServerConfig> mcpServers = new ArrayList<McpServerConfig>();
        private Map<HookEventType, List<HookEventConfig>> hooks = new HashMap<HookEventType, List<HookEventConfig>>();
        private List<CommandConfig> commands = new ArrayList<CommandConfig>();
        private List<CreateAgentConfig> agents = new ArrayList<CreateAgentConfig>();
        private ApprovalMode approvalMode = ApprovalMode.YOLO;
        private String authMethodId = "iflow";
        private AuthMethodInfo authMethodInfo;
        private PermissionMode permissionMode = PermissionMode.AUTO;
        private List<String> autoApproveTypes = new ArrayList<String>();
        private Duration timeout = Duration.ofSeconds(30L);
        private Map<String, Object> metadata = new HashMap<String, Object>();
        private boolean fileAccess = false;
        private List<String> fileAllowedDirs = null;
        private boolean fileReadOnly = false;
        private long fileMaxSize = 0xA00000L;
        private boolean autoStartProcess = true;
        private int processStartPort = 8090;
        private String iflowExecutable = "iflow";
        private Duration processStartTimeout = Duration.ofSeconds(30L);
        private Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback;
        private SessionSettings sessionSettings;

        public Builder() {
            this.autoApproveTypes.add("edit");
            this.autoApproveTypes.add("fetch");
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        public Builder cwd(String cwd) {
            this.cwd = cwd;
            return this;
        }

        public Builder cwd(File cwd) {
            this.cwd = cwd.getAbsolutePath();
            return this;
        }

        public Builder mcpServers(List<McpServerConfig> mcpServers) {
            this.mcpServers = new ArrayList<McpServerConfig>(mcpServers);
            return this;
        }

        public Builder addMcpServer(McpServerConfig mcpServer) {
            this.mcpServers.add(mcpServer);
            return this;
        }

        public Builder permissionMode(PermissionMode permissionMode) {
            this.permissionMode = permissionMode;
            return this;
        }

        public Builder autoApproveTypes(List<String> autoApproveTypes) {
            this.autoApproveTypes = new ArrayList<String>(autoApproveTypes);
            return this;
        }

        public Builder addAutoApproveType(String toolType) {
            this.autoApproveTypes.add(toolType);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder metadata(Map<String, Object> metadata) {
            this.metadata = new HashMap<String, Object>(metadata);
            return this;
        }

        public Builder addMetadata(String key, Object value) {
            this.metadata.put(key, value);
            return this;
        }

        public Builder fileAccess(boolean fileAccess) {
            this.fileAccess = fileAccess;
            return this;
        }

        public Builder fileAllowedDirs(List<String> fileAllowedDirs) {
            this.fileAllowedDirs = fileAllowedDirs != null ? new ArrayList<String>(fileAllowedDirs) : null;
            return this;
        }

        public Builder addFileAllowedDir(String directory) {
            if (this.fileAllowedDirs == null) {
                this.fileAllowedDirs = new ArrayList<String>();
            }
            this.fileAllowedDirs.add(directory);
            return this;
        }

        public Builder fileReadOnly(boolean fileReadOnly) {
            this.fileReadOnly = fileReadOnly;
            return this;
        }

        public Builder fileMaxSize(long fileMaxSize) {
            this.fileMaxSize = fileMaxSize;
            return this;
        }

        public Builder autoStartProcess(boolean autoStartProcess) {
            this.autoStartProcess = autoStartProcess;
            return this;
        }

        public Builder processStartPort(int processStartPort) {
            this.processStartPort = processStartPort;
            return this;
        }

        public Builder iflowExecutable(String iflowExecutable) {
            this.iflowExecutable = iflowExecutable;
            return this;
        }

        public Builder processStartTimeout(Duration processStartTimeout) {
            this.processStartTimeout = processStartTimeout;
            return this;
        }

        public Builder permissionCallback(Function<PermissionRequestParams, Mono<PermissionRequestResult>> permissionCallback) {
            this.permissionCallback = permissionCallback;
            return this;
        }

        public Builder sessionSettings(SessionSettings sessionSettings) {
            this.sessionSettings = sessionSettings;
            return this;
        }

        public Builder hooks(Map<HookEventType, List<HookEventConfig>> hooks) {
            this.hooks = hooks != null ? new HashMap<HookEventType, List<HookEventConfig>>(hooks) : new HashMap();
            return this;
        }

        public Builder addHook(HookEventType eventType, HookEventConfig hookConfig) {
            if (this.hooks == null) {
                this.hooks = new HashMap<HookEventType, List<HookEventConfig>>();
            }
            this.hooks.computeIfAbsent(eventType, k -> new ArrayList()).add(hookConfig);
            return this;
        }

        public Builder commands(List<CommandConfig> commands) {
            this.commands = commands != null ? new ArrayList<CommandConfig>(commands) : new ArrayList();
            return this;
        }

        public Builder addCommand(CommandConfig command) {
            if (this.commands == null) {
                this.commands = new ArrayList<CommandConfig>();
            }
            this.commands.add(command);
            return this;
        }

        public Builder agents(List<CreateAgentConfig> agents) {
            this.agents = agents != null ? new ArrayList<CreateAgentConfig>(agents) : new ArrayList();
            return this;
        }

        public Builder addAgent(CreateAgentConfig agent) {
            if (this.agents == null) {
                this.agents = new ArrayList<CreateAgentConfig>();
            }
            this.agents.add(agent);
            return this;
        }

        public Builder approvalMode(ApprovalMode approvalMode) {
            this.approvalMode = approvalMode;
            return this;
        }

        public Builder authMethodId(String authMethodId) {
            this.authMethodId = authMethodId;
            return this;
        }

        public Builder authMethodInfo(AuthMethodInfo authMethodInfo) {
            this.authMethodInfo = authMethodInfo;
            return this;
        }

        public IFlowOptions build() {
            return new IFlowOptions(this);
        }
    }
}

