/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.enums.PermissionMode;
import cn.iflow.sdk.types.messages.AssistantMessage;
import cn.iflow.sdk.types.messages.ErrorMessage;
import cn.iflow.sdk.types.messages.PlanMessage;
import cn.iflow.sdk.types.messages.ToolCallMessage;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComprehensiveDemo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComprehensiveDemo.class);

    public static void main(String[] args) {
        System.out.println("\n\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557\n\u2551            iFlow SDK - Comprehensive Demo                  \u2551\n\u2551                                                            \u2551\n\u2551  This demo showcases all major features of the SDK        \u2551\n\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        try {
            ComprehensiveDemo demo = new ComprehensiveDemo();
            demo.basicConversation();
            demo.toolInteraction();
            demo.agentTracking();
            demo.planExecution();
            demo.simpleQuery();
            System.out.println("\n" + "=".repeat(60));
            System.out.println("\u2728 All demonstrations completed successfully!");
            System.out.println("=".repeat(60));
        }
        catch (Exception e) {
            System.err.println("\n\u274c Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void basicConversation() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("1. BASIC CONVERSATION");
        System.out.println("=".repeat(60));
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            client.sendMessage("What is the capital of France?").block();
            System.out.println("\nResponse from iFlow:");
            this.handleMessages(client, "Basic Conversation");
        }
        catch (Exception e) {
            System.err.println("Basic conversation failed: " + e.getMessage());
        }
    }

    private void toolInteraction() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("2. TOOL INTERACTION");
        System.out.println("=".repeat(60));
        IFlowOptions options = IFlowOptions.builder().permissionMode(PermissionMode.AUTO).build();
        try (IFlowClient client = IFlowClient.create(options);){
            client.connect().block();
            client.sendMessage("Create a file called demo.txt with 'Hello World' content").block();
            ArrayList toolCalls = new ArrayList();
            AtomicBoolean finished = new AtomicBoolean(false);
            client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
                switch (message.getType()) {
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        System.out.println("\n\ud83d\udd27 Tool Call: " + toolCall.getLabel());
                        System.out.println("   Status: " + toolCall.getStatus());
                        System.out.println("   ID: " + toolCall.getToolCallId());
                        HashMap<String, String> toolInfo = new HashMap<String, String>();
                        toolInfo.put("label", toolCall.getLabel());
                        toolInfo.put("status", toolCall.getStatus().toString());
                        toolCalls.add(toolInfo);
                        break;
                    }
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        System.out.println("\n\ud83d\udcac Assistant: " + assistantMsg.getChunk().getText());
                        break;
                    }
                    case TASK_FINISH: {
                        System.out.println("\n\u2705 Task completed with " + toolCalls.size() + " tool calls");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.err.println("\n\u274c Error: " + error.getErrorMessage());
                        finished.set(true);
                    }
                }
            }).blockLast(Duration.ofSeconds(30L));
        }
        catch (Exception e) {
            System.err.println("Tool interaction failed: " + e.getMessage());
        }
    }

    private void agentTracking() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("3. SUBAGENT TRACKING");
        System.out.println("=".repeat(60));
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            client.sendMessage("Analyze this project structure and suggest improvements").block();
            HashSet agentsSeen = new HashSet();
            AtomicBoolean finished = new AtomicBoolean(false);
            client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
                String agentId = message.getAgentId().orElse(null);
                if (agentId != null) {
                    agentsSeen.add(agentId);
                    System.out.print("\n[Agent: " + agentId.substring(0, Math.min(8, agentId.length())) + "...] ");
                } else {
                    System.out.print("\n[Main Agent] ");
                }
                switch (message.getType()) {
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        String text = assistantMsg.getChunk().getText();
                        System.out.print(text.substring(0, Math.min(50, text.length())) + "...");
                        break;
                    }
                    case TOOL_CALL: {
                        ToolCallMessage toolCall = (ToolCallMessage)message;
                        System.out.print("\ud83d\udd27 " + toolCall.getLabel());
                        break;
                    }
                    case TASK_FINISH: {
                        System.out.println("\n\n\u2705 Completed with " + agentsSeen.size() + " SubAgent(s)");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.err.println("\n\u274c Error: " + error.getErrorMessage());
                        finished.set(true);
                    }
                }
            }).doOnComplete(() -> finished.set(true)).blockLast(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            System.err.println("Agent tracking failed: " + e.getMessage());
        }
    }

    private void planExecution() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("4. PLAN EXECUTION");
        System.out.println("=".repeat(60));
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            client.sendMessage("Create a plan to build a simple web application with authentication, database, and API endpoints").block();
            ArrayList plansReceived = new ArrayList();
            AtomicBoolean finished = new AtomicBoolean(false);
            client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
                switch (message.getType()) {
                    case PLAN: {
                        PlanMessage plan = (PlanMessage)message;
                        System.out.println("\n\ud83d\udccb Plan received with entries:");
                        for (int i = 0; i < plan.getEntries().size(); ++i) {
                            PlanMessage.PlanEntry entry = plan.getEntries().get(i);
                            String statusIcon = this.getStatusIcon(entry.getStatus());
                            String priorityIcon = this.getPriorityIcon(entry.getPriority());
                            System.out.println("   " + (i + 1) + ". " + statusIcon + " " + priorityIcon + " " + entry.getContent());
                        }
                        plansReceived.add(plan);
                        break;
                    }
                    case ASSISTANT_MESSAGE: {
                        AssistantMessage assistantMsg = (AssistantMessage)message;
                        if (assistantMsg.getChunk().getText() == null) break;
                        System.out.print(assistantMsg.getChunk().getText());
                        break;
                    }
                    case TASK_FINISH: {
                        System.out.println("\n\n\u2705 Planning completed (" + plansReceived.size() + " plan(s))");
                        finished.set(true);
                        break;
                    }
                    case ERROR: {
                        ErrorMessage error = (ErrorMessage)message;
                        System.err.println("\n\u274c Error: " + error.getErrorMessage());
                        finished.set(true);
                    }
                }
            }).blockLast(Duration.ofSeconds(10L));
        }
        catch (Exception e) {
            System.err.println("Plan execution failed: " + e.getMessage());
        }
    }

    private void simpleQuery() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("5. SIMPLE QUERY (Synchronous)");
        System.out.println("=".repeat(60));
        try {
            String response = "This would normally return a response from iFlow";
            System.out.println("\nResponse: " + response);
        }
        catch (Exception e) {
            System.err.println("Simple query failed: " + e.getMessage());
            System.out.println("Note: Requires running iFlow instance");
        }
    }

    private String getStatusIcon(String status) {
        Map<String, String> statusIcons = Map.of("completed", "\u2705", "in_progress", "\ud83d\udd04", "pending", "\u23f3");
        return statusIcons.getOrDefault(status, "\u2753");
    }

    private String getPriorityIcon(String priority) {
        Map<String, String> priorityIcons = Map.of("high", "\ud83d\udd34", "medium", "\ud83d\udfe1", "low", "\ud83d\udfe2");
        return priorityIcons.getOrDefault(priority, "\u26aa");
    }

    private void handleMessages(IFlowClient client, String context) {
        AtomicBoolean finished = new AtomicBoolean(false);
        client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
            switch (message.getType()) {
                case ASSISTANT_MESSAGE: {
                    AssistantMessage assistantMsg = (AssistantMessage)message;
                    if (assistantMsg.getChunk().getText() == null) break;
                    System.out.print(assistantMsg.getChunk().getText());
                    break;
                }
                case TASK_FINISH: {
                    System.out.println("\n\n\u2705 " + context + " completed");
                    finished.set(true);
                    break;
                }
                case ERROR: {
                    ErrorMessage error = (ErrorMessage)message;
                    System.err.println("\n\u274c Error: " + error.getErrorMessage());
                    finished.set(true);
                }
            }
        }).doOnComplete(() -> finished.set(true)).blockLast(Duration.ofSeconds(30L));
    }
}

