/*
 * Decompiled with CFR 0.152.
 */
package cn.iflow.sdk.examples;

import cn.iflow.sdk.core.IFlowClient;
import cn.iflow.sdk.types.config.IFlowOptions;
import cn.iflow.sdk.types.enums.MessageType;
import cn.iflow.sdk.types.messages.AssistantMessage;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoStartExample {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutoStartExample.class);

    public static void main(String[] args) {
        System.out.println("=".repeat(60));
        System.out.println("iFlow SDK \u81ea\u52a8\u542f\u52a8\u6f14\u793a");
        System.out.println("=".repeat(60));
        try {
            AutoStartExample.exampleAutoStart();
            AutoStartExample.exampleProcessManager();
            System.out.println("\n" + "=".repeat(60));
            System.out.println("\u2728 \u6f14\u793a\u5b8c\u6210!");
            System.out.println("=".repeat(60));
            AutoStartExample.printFeatureSummary();
        }
        catch (Exception e) {
            log.error("Auto-start example failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void exampleAutoStart() {
        System.out.println("\n\ud83d\udccb \u65b9\u5f0f 1: \u9ed8\u8ba4\u8bbe\u7f6e\uff08\u81ea\u52a8\u542f\u52a8\uff09");
        System.out.println("\u5f53\u68c0\u6d4b\u5230 iFlow \u672a\u8fd0\u884c\u65f6\uff0cSDK \u4f1a\u81ea\u52a8\u542f\u52a8\u5b83");
        try (IFlowClient client = IFlowClient.create();){
            client.connect().block();
            System.out.println("\u2705 \u5ba2\u6237\u7aef\u5df2\u8fde\u63a5!");
            System.out.println("   iFlow \u8fdb\u7a0b\u5df2\u81ea\u52a8\u542f\u52a8\uff08\u5982\u679c\u4e4b\u524d\u672a\u8fd0\u884c\uff09");
            client.sendMessage("Hello, iFlow! \u8fd9\u662f\u81ea\u52a8\u542f\u52a8\u7684\u6f14\u793a\u3002").block();
            System.out.println("\u2705 \u6d88\u606f\u5df2\u53d1\u9001");
            int timeout = 20;
            System.out.println("   \u7b49\u5f85\u54cd\u5e94 (" + timeout + "\u79d2)...");
            try {
                AutoStartExample.handleMessagesWithTimeout(client, timeout);
            }
            catch (Exception e) {
                System.out.println("   \u8d85\u65f6\uff0c\u7ee7\u7eed...");
            }
        }
        catch (Exception e) {
            System.out.println("\u274c \u9519\u8bef: " + e.getMessage());
        }
        System.out.println("\n\u2728 \u5ba2\u6237\u7aef\u5df2\u5173\u95ed\uff0ciFlow \u8fdb\u7a0b\u5df2\u81ea\u52a8\u6e05\u7406");
        System.out.println("\n" + "=".repeat(60));
        System.out.println("\ud83d\udccb \u65b9\u5f0f 2: \u81ea\u5b9a\u4e49\u7aef\u53e3");
        IFlowOptions options = IFlowOptions.builder().autoStartProcess(true).processStartPort(9500).build();
        try (IFlowClient client = IFlowClient.create(options);){
            client.connect().block();
            System.out.println("\u2705 \u5ba2\u6237\u7aef\u5df2\u8fde\u63a5\u5230\u81ea\u5b9a\u4e49\u7aef\u53e3!");
            System.out.println("   URL: ws://localhost:8090/acp");
            client.sendMessage("\u4f7f\u7528\u81ea\u5b9a\u4e49\u7aef\u53e3\u7684\u6d4b\u8bd5").block();
            System.out.println("\u2705 \u6d88\u606f\u5df2\u53d1\u9001");
        }
        catch (Exception e) {
            System.out.println("\u274c \u9519\u8bef: " + e.getMessage());
        }
        System.out.println("\n" + "=".repeat(60));
        System.out.println("\ud83d\udccb \u65b9\u5f0f 3: \u7981\u7528\u81ea\u52a8\u542f\u52a8");
        System.out.println("\u5f53\u4f60\u60f3\u8fde\u63a5\u5230\u5df2\u7ecf\u8fd0\u884c\u7684 iFlow \u5b9e\u4f8b\u65f6");
        IFlowOptions manualOptions = IFlowOptions.builder().autoStartProcess(false).url("ws://localhost:8090/acp").build();
        try (IFlowClient client = IFlowClient.create(manualOptions);){
            client.connect().block();
            System.out.println("\u2705 \u8fde\u63a5\u5230\u5df2\u8fd0\u884c\u7684 iFlow \u5b9e\u4f8b");
            client.sendMessage("\u8fde\u63a5\u5230\u73b0\u6709\u5b9e\u4f8b").block();
        }
        catch (Exception e) {
            System.out.println("\u26a0\ufe0f \u9884\u671f\u7684\u9519\u8bef\uff08\u5982\u679c iFlow \u672a\u5728\u8be5\u7aef\u53e3\u8fd0\u884c\uff09: " + e.getClass().getSimpleName());
        }
    }

    private static void exampleProcessManager() {
        System.out.println("\n" + "=".repeat(60));
        System.out.println("\u76f4\u63a5\u4f7f\u7528\u8fdb\u7a0b\u7ba1\u7406\u5668");
        System.out.println("=".repeat(60));
        try {
            System.out.println("Java SDK \u7684\u8fdb\u7a0b\u7ba1\u7406\u662f\u5185\u7f6e\u7684\uff0c\u901a\u8fc7 IFlowOptions \u914d\u7f6e:");
            IFlowOptions processOptions = IFlowOptions.builder().autoStartProcess(true).processStartPort(10000).processStartTimeout(Duration.ofSeconds(30L)).build();
            try (IFlowClient client = IFlowClient.create(processOptions);){
                System.out.println("\u2705 \u8fdb\u7a0b\u7ba1\u7406\u5668\u914d\u7f6e:");
                System.out.println("   \u8d77\u59cb\u7aef\u53e3: " + processOptions.getProcessStartPort());
                System.out.println("   \u8d85\u65f6\u65f6\u95f4: " + processOptions.getProcessStartTimeout());
                client.connect().block();
                System.out.println("\u2705 iFlow \u8fdb\u7a0b\u5df2\u542f\u52a8");
                System.out.println("   URL: ws://localhost:8090/acp");
                Thread.sleep(2000L);
            }
            System.out.println("\u2705 iFlow \u8fdb\u7a0b\u5df2\u81ea\u52a8\u505c\u6b62");
        }
        catch (Exception e) {
            System.out.println("\u274c \u9519\u8bef: " + e.getMessage());
        }
    }

    private static void printFeatureSummary() {
        System.out.println("\n\u91cd\u8981\u529f\u80fd:");
        System.out.println("1. \u2705 \u81ea\u52a8\u68c0\u6d4b iFlow \u662f\u5426\u5b89\u88c5");
        System.out.println("2. \u2705 \u81ea\u52a8\u542f\u52a8 iFlow \u8fdb\u7a0b");
        System.out.println("3. \u2705 \u81ea\u52a8\u67e5\u627e\u53ef\u7528\u7aef\u53e3");
        System.out.println("4. \u2705 \u9000\u51fa\u65f6\u81ea\u52a8\u6e05\u7406\u8fdb\u7a0b");
        System.out.println("5. \u2705 \u652f\u6301\u81ea\u5b9a\u4e49\u7aef\u53e3\u8303\u56f4");
        System.out.println("6. \u2705 \u53ef\u4ee5\u7981\u7528\u81ea\u52a8\u542f\u52a8\u529f\u80fd");
    }

    private static void handleMessagesWithTimeout(IFlowClient client, int timeoutSeconds) throws Exception {
        AtomicBoolean finished = new AtomicBoolean(false);
        client.receiveMessages().takeUntil(msg -> finished.get()).doOnNext(message -> {
            if (message.getType() == MessageType.ASSISTANT_MESSAGE) {
                AssistantMessage assistantMsg = (AssistantMessage)message;
                if (assistantMsg.getChunk().getText() != null) {
                    System.out.print(assistantMsg.getChunk().getText());
                }
            } else if (message.getType() == MessageType.TASK_FINISH) {
                System.out.println("\n   \u6536\u5230\u6d88\u606f: " + message.getType());
                finished.set(true);
            }
        }).doOnComplete(() -> finished.set(true)).blockLast(Duration.ofSeconds(timeoutSeconds));
    }
}

