/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.strategy;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.fun.strategy.SaFirewallCheckFailHandleFunction;
import cn.dev33.satoken.fun.strategy.SaFirewallCheckFunction;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHook;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForBlackPath;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForDirectoryTraversal;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForHeader;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForHost;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForHttpMethod;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForParameter;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForPathBannedCharacter;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForPathDangerCharacter;
import cn.dev33.satoken.strategy.hooks.SaFirewallCheckHookForWhitePath;
import java.util.ArrayList;
import java.util.List;

public final class SaFirewallStrategy {
    public static final SaFirewallStrategy instance = new SaFirewallStrategy();
    public List<SaFirewallCheckHook> checkHooks = new ArrayList<SaFirewallCheckHook>();
    public SaFirewallCheckFunction check = (req, res, extArg) -> {
        for (SaFirewallCheckHook checkHook : this.checkHooks) {
            checkHook.execute(req, res, extArg);
        }
    };
    public SaFirewallCheckFailHandleFunction checkFailHandle = null;

    private SaFirewallStrategy() {
        this.checkHooks.add(SaFirewallCheckHookForWhitePath.instance);
        this.checkHooks.add(SaFirewallCheckHookForBlackPath.instance);
        this.checkHooks.add(SaFirewallCheckHookForPathDangerCharacter.instance);
        this.checkHooks.add(SaFirewallCheckHookForPathBannedCharacter.instance);
        this.checkHooks.add(SaFirewallCheckHookForDirectoryTraversal.instance);
        this.checkHooks.add(SaFirewallCheckHookForHost.instance);
        this.checkHooks.add(SaFirewallCheckHookForHttpMethod.instance);
        this.checkHooks.add(SaFirewallCheckHookForHeader.instance);
        this.checkHooks.add(SaFirewallCheckHookForParameter.instance);
    }

    public void registerHook(SaFirewallCheckHook checkHook) {
        SaManager.getLog().info("\u9632\u706b\u5899\u6821\u9a8c hook \u6ce8\u518c\u6210\u529f: " + checkHook.getClass(), new Object[0]);
        this.checkHooks.add(checkHook);
    }

    public void registerHookToFirst(SaFirewallCheckHook checkHook) {
        SaManager.getLog().info("\u9632\u706b\u5899\u6821\u9a8c hook \u6ce8\u518c\u6210\u529f: " + checkHook.getClass(), new Object[0]);
        this.checkHooks.add(0, checkHook);
    }

    public void registerHookToSecond(SaFirewallCheckHook checkHook) {
        SaManager.getLog().info("\u9632\u706b\u5899\u6821\u9a8c hook \u6ce8\u518c\u6210\u529f: " + checkHook.getClass(), new Object[0]);
        this.checkHooks.add(1, checkHook);
    }

    public void removeHook(Class<? extends SaFirewallCheckHook> hookClass) {
        for (SaFirewallCheckHook hook : this.checkHooks) {
            if (!hook.getClass().equals(hookClass)) continue;
            this.checkHooks.remove(hook);
            SaManager.getLog().info("\u9632\u706b\u5899\u6821\u9a8c hook \u79fb\u9664\u6210\u529f: " + hookClass, new Object[0]);
            return;
        }
    }
}

