/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.router;

import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.exception.BackResultException;
import cn.dev33.satoken.exception.StopMatchException;
import cn.dev33.satoken.fun.SaFunction;
import cn.dev33.satoken.fun.SaParamFunction;
import cn.dev33.satoken.fun.SaParamRetFunction;
import cn.dev33.satoken.router.SaHttpMethod;
import cn.dev33.satoken.router.SaRouterStaff;
import cn.dev33.satoken.strategy.SaStrategy;
import java.util.List;

public class SaRouter {
    private SaRouter() {
    }

    public static boolean isMatch(String pattern, String path) {
        return (Boolean)SaStrategy.instance.routeMatcher.apply(pattern, path);
    }

    public static boolean isMatch(List<String> patterns, String path) {
        if (patterns == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (!SaRouter.isMatch(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(String[] patterns, String path) {
        if (patterns == null) {
            return false;
        }
        for (String pattern : patterns) {
            if (!SaRouter.isMatch(pattern, path)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatch(SaHttpMethod[] methods, String methodString) {
        if (methods == null) {
            return false;
        }
        for (SaHttpMethod method : methods) {
            if (method != SaHttpMethod.ALL && (method == null || !method.toString().equalsIgnoreCase(methodString))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMatchCurrURI(String pattern) {
        return SaRouter.isMatch(pattern, SaHolder.getRequest().getRequestPath());
    }

    public static boolean isMatchCurrURI(List<String> patterns) {
        return SaRouter.isMatch(patterns, SaHolder.getRequest().getRequestPath());
    }

    public static boolean isMatchCurrURI(String[] patterns) {
        return SaRouter.isMatch(patterns, SaHolder.getRequest().getRequestPath());
    }

    public static boolean isMatchCurrMethod(SaHttpMethod[] methods) {
        return SaRouter.isMatch(methods, SaHolder.getRequest().getMethod());
    }

    public static SaRouterStaff newMatch() {
        return new SaRouterStaff();
    }

    public static SaRouterStaff match(String ... patterns) {
        return new SaRouterStaff().match(patterns);
    }

    public static SaRouterStaff notMatch(String ... patterns) {
        return new SaRouterStaff().notMatch(patterns);
    }

    public static SaRouterStaff match(List<String> patterns) {
        return new SaRouterStaff().match(patterns);
    }

    public static SaRouterStaff notMatch(List<String> patterns) {
        return new SaRouterStaff().notMatch(patterns);
    }

    public static SaRouterStaff match(SaHttpMethod ... methods) {
        return new SaRouterStaff().match(methods);
    }

    public static SaRouterStaff notMatch(SaHttpMethod ... methods) {
        return new SaRouterStaff().notMatch(methods);
    }

    public static SaRouterStaff matchMethod(String ... methods) {
        return new SaRouterStaff().matchMethod(methods);
    }

    public static SaRouterStaff notMatchMethod(String ... methods) {
        return new SaRouterStaff().notMatchMethod(methods);
    }

    public static SaRouterStaff match(boolean flag) {
        return new SaRouterStaff().match(flag);
    }

    public static SaRouterStaff notMatch(boolean flag) {
        return new SaRouterStaff().notMatch(flag);
    }

    public static SaRouterStaff match(SaParamRetFunction<Object, Boolean> fun) {
        return new SaRouterStaff().match(fun);
    }

    public static SaRouterStaff notMatch(SaParamRetFunction<Object, Boolean> fun) {
        return new SaRouterStaff().notMatch(fun);
    }

    public static SaRouterStaff match(String pattern, SaFunction fun) {
        return new SaRouterStaff().match(pattern, fun);
    }

    public static SaRouterStaff match(String pattern, SaParamFunction<SaRouterStaff> fun) {
        return new SaRouterStaff().match(pattern, fun);
    }

    public static SaRouterStaff match(String pattern, String excludePattern, SaFunction fun) {
        return new SaRouterStaff().match(pattern, excludePattern, fun);
    }

    public static SaRouterStaff match(String pattern, String excludePattern, SaParamFunction<SaRouterStaff> fun) {
        return new SaRouterStaff().match(pattern, excludePattern, fun);
    }

    public static SaRouterStaff stop() {
        throw new StopMatchException();
    }

    public static SaRouterStaff back() {
        throw new BackResultException((Object)"");
    }

    public static SaRouterStaff back(Object result) {
        throw new BackResultException(result);
    }
}

