/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken;

import cn.dev33.satoken.config.SaTokenConfig;
import cn.dev33.satoken.config.SaTokenConfigFactory;
import cn.dev33.satoken.context.SaTokenContext;
import cn.dev33.satoken.context.SaTokenContextForThreadLocal;
import cn.dev33.satoken.dao.SaTokenDao;
import cn.dev33.satoken.dao.SaTokenDaoDefaultImpl;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.http.SaHttpTemplate;
import cn.dev33.satoken.http.SaHttpTemplateDefaultImpl;
import cn.dev33.satoken.json.SaJsonTemplate;
import cn.dev33.satoken.json.SaJsonTemplateDefaultImpl;
import cn.dev33.satoken.listener.SaTokenEventCenter;
import cn.dev33.satoken.log.SaLog;
import cn.dev33.satoken.log.SaLogForConsole;
import cn.dev33.satoken.same.SaSameTemplate;
import cn.dev33.satoken.secure.totp.SaTotpTemplate;
import cn.dev33.satoken.serializer.SaSerializerTemplate;
import cn.dev33.satoken.serializer.impl.SaSerializerTemplateForJson;
import cn.dev33.satoken.stp.StpInterface;
import cn.dev33.satoken.stp.StpInterfaceDefaultImpl;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.stp.StpUtil;
import cn.dev33.satoken.strategy.SaStrategy;
import cn.dev33.satoken.temp.SaTempTemplate;
import cn.dev33.satoken.util.SaFoxUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public class SaManager {
    public static volatile SaTokenConfig config;
    private static volatile SaTokenDao saTokenDao;
    private static volatile StpInterface stpInterface;
    private static volatile SaTokenContext saTokenContext;
    private static volatile SaTempTemplate saTempTemplate;
    private static volatile SaJsonTemplate saJsonTemplate;
    private static volatile SaHttpTemplate saHttpTemplate;
    private static volatile SaSerializerTemplate saSerializerTemplate;
    private static volatile SaSameTemplate saSameTemplate;
    public static volatile SaLog log;
    private static volatile SaTotpTemplate totpTemplate;
    public static Map<String, StpLogic> stpLogicMap;

    public static void setConfig(SaTokenConfig config) {
        SaManager.setConfigMethod(config);
        if (config != null && config.getIsPrint().booleanValue()) {
            SaFoxUtil.printSaToken();
        }
        if (config != null && config.getIsLog() != null && config.getIsLog().booleanValue() && config.getIsColorLog() == null) {
            config.setIsColorLog(SaFoxUtil.isCanColorLog());
        }
        SaTokenEventCenter.doSetConfig(config);
        StpUtil.getLoginType();
    }

    private static void setConfigMethod(SaTokenConfig config) {
        SaManager.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaTokenConfig getConfig() {
        if (config != null) return config;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (config != null) return config;
            SaManager.setConfigMethod(SaTokenConfigFactory.createConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return config;
        }
    }

    public static void setSaTokenDao(SaTokenDao saTokenDao) {
        SaManager.setSaTokenDaoMethod(saTokenDao);
        SaTokenEventCenter.doRegisterComponent("SaTokenDao", saTokenDao);
    }

    private static void setSaTokenDaoMethod(SaTokenDao saTokenDao) {
        if (SaManager.saTokenDao != null) {
            SaManager.saTokenDao.destroy();
        }
        if ((SaManager.saTokenDao = saTokenDao) != null) {
            SaManager.saTokenDao.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaTokenDao getSaTokenDao() {
        if (saTokenDao != null) return saTokenDao;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saTokenDao != null) return saTokenDao;
            SaManager.setSaTokenDaoMethod(new SaTokenDaoDefaultImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return saTokenDao;
        }
    }

    public static void setStpInterface(StpInterface stpInterface) {
        SaManager.stpInterface = stpInterface;
        SaTokenEventCenter.doRegisterComponent("StpInterface", stpInterface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StpInterface getStpInterface() {
        if (stpInterface != null) return stpInterface;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (stpInterface != null) return stpInterface;
            stpInterface = new StpInterfaceDefaultImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return stpInterface;
        }
    }

    public static void setSaTokenContext(SaTokenContext saTokenContext) {
        SaManager.saTokenContext = saTokenContext;
        SaTokenEventCenter.doRegisterComponent("SaTokenContext", saTokenContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaTokenContext getSaTokenContext() {
        if (saTokenContext != null) return saTokenContext;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saTokenContext != null) return saTokenContext;
            saTokenContext = new SaTokenContextForThreadLocal();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saTokenContext;
        }
    }

    public static void setSaTempTemplate(SaTempTemplate saTempTemplate) {
        SaManager.saTempTemplate = saTempTemplate;
        SaTokenEventCenter.doRegisterComponent("SaTempTemplate", saTempTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaTempTemplate getSaTempTemplate() {
        if (saTempTemplate != null) return saTempTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saTempTemplate != null) return saTempTemplate;
            saTempTemplate = new SaTempTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saTempTemplate;
        }
    }

    public static void setSaJsonTemplate(SaJsonTemplate saJsonTemplate) {
        SaManager.saJsonTemplate = saJsonTemplate;
        SaTokenEventCenter.doRegisterComponent("SaJsonTemplate", saJsonTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaJsonTemplate getSaJsonTemplate() {
        if (saJsonTemplate != null) return saJsonTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saJsonTemplate != null) return saJsonTemplate;
            saJsonTemplate = new SaJsonTemplateDefaultImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saJsonTemplate;
        }
    }

    public static void setSaHttpTemplate(SaHttpTemplate saHttpTemplate) {
        SaManager.saHttpTemplate = saHttpTemplate;
        SaTokenEventCenter.doRegisterComponent("SaHttpTemplate", saHttpTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaHttpTemplate getSaHttpTemplate() {
        if (saHttpTemplate != null) return saHttpTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saHttpTemplate != null) return saHttpTemplate;
            saHttpTemplate = new SaHttpTemplateDefaultImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saHttpTemplate;
        }
    }

    public static void setSaSerializerTemplate(SaSerializerTemplate saSerializerTemplate) {
        SaManager.saSerializerTemplate = saSerializerTemplate;
        SaTokenEventCenter.doRegisterComponent("SaSerializerTemplate", saSerializerTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaSerializerTemplate getSaSerializerTemplate() {
        if (saSerializerTemplate != null) return saSerializerTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saSerializerTemplate != null) return saSerializerTemplate;
            saSerializerTemplate = new SaSerializerTemplateForJson();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saSerializerTemplate;
        }
    }

    public static void setSaSameTemplate(SaSameTemplate saSameTemplate) {
        SaManager.saSameTemplate = saSameTemplate;
        SaTokenEventCenter.doRegisterComponent("SaSameTemplate", saSameTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaSameTemplate getSaSameTemplate() {
        if (saSameTemplate != null) return saSameTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (saSameTemplate != null) return saSameTemplate;
            saSameTemplate = new SaSameTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return saSameTemplate;
        }
    }

    public static void setLog(SaLog log) {
        SaManager.log = log;
        SaTokenEventCenter.doRegisterComponent("SaLog", log);
    }

    public static SaLog getLog() {
        return log;
    }

    public static void setSaTotpTemplate(SaTotpTemplate totpTemplate) {
        SaManager.totpTemplate = totpTemplate;
        SaTokenEventCenter.doRegisterComponent("SaTotpTemplate", totpTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SaTotpTemplate getSaTotpTemplate() {
        if (totpTemplate != null) return totpTemplate;
        Class<SaManager> clazz = SaManager.class;
        synchronized (SaManager.class) {
            if (totpTemplate != null) return totpTemplate;
            totpTemplate = new SaTotpTemplate();
            // ** MonitorExit[var0] (shouldn't be in output)
            return totpTemplate;
        }
    }

    public static void putStpLogic(StpLogic stpLogic) {
        stpLogicMap.put(stpLogic.getLoginType(), stpLogic);
    }

    public static void removeStpLogic(String loginType) {
        stpLogicMap.remove(loginType);
    }

    public static StpLogic getStpLogic(String loginType) {
        return SaManager.getStpLogic(loginType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StpLogic getStpLogic(String loginType, boolean isCreate) {
        if (loginType == null || loginType.isEmpty()) {
            return StpUtil.stpLogic;
        }
        StpLogic stpLogic = stpLogicMap.get(loginType);
        if (stpLogic == null) {
            if (isCreate) {
                Class<SaManager> clazz = SaManager.class;
                synchronized (SaManager.class) {
                    stpLogic = stpLogicMap.get(loginType);
                    if (stpLogic == null) {
                        stpLogic = (StpLogic)SaStrategy.instance.createStpLogic.apply(loginType);
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            } else {
                throw new SaTokenException("\u672a\u80fd\u83b7\u53d6\u5bf9\u5e94StpLogic\uff0ctype=" + loginType).setCode(10002);
            }
        }
        return stpLogic;
    }

    static {
        log = new SaLogForConsole();
        stpLogicMap = new LinkedHashMap<String, StpLogic>();
    }
}

