package cn.authing.sdk.java.dto;

import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;


public class SendEmailDto {
    /**
     * 短信通道，指定发送此短信的目的：
     * - `CHANNEL_LOGIN`: 用于用户登录
     * - `CHANNEL_REGISTER`: 用于用户注册
     * - `CHANNEL_RESET_PASSWORD`: 用于重置密码
     * - `CHANNEL_VERIFY_EMAIL_LINK`: 用于验证邮箱地址
     * - `CHANNEL_UPDATE_EMAIL`: 用于修改邮箱
     * - `CHANNEL_BIND_EMAIL`: 用于绑定邮箱
     * - `CHANNEL_UNBIND_EMAIL`: 用于解绑邮箱
     * - `CHANNEL_VERIFY_MFA`: 用于验证 MFA
     * - `CHANNEL_UNLOCK_ACCOUNT`: 用于自助解锁
     * - `CHANNEL_COMPLETE_EMAIL`: 用于注册/登录时补全邮箱信息
     * - `CHANNEL_DELETE_ACCOUNT`: 用于注销账号
     *
     */
    @JsonProperty("channel")
    private Channel channel;
    /**
     * 邮箱，不区分大小写
     */
    @JsonProperty("email")
    private String email;

    public Channel getChannel() {
        return channel;
    }
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public String getEmail() {
        return email;
    }
    public void setEmail(String email) {
        this.email = email;
    }


    /**
     * 短信通道，指定发送此短信的目的：
     * - `CHANNEL_LOGIN`: 用于用户登录
     * - `CHANNEL_REGISTER`: 用于用户注册
     * - `CHANNEL_RESET_PASSWORD`: 用于重置密码
     * - `CHANNEL_VERIFY_EMAIL_LINK`: 用于验证邮箱地址
     * - `CHANNEL_UPDATE_EMAIL`: 用于修改邮箱
     * - `CHANNEL_BIND_EMAIL`: 用于绑定邮箱
     * - `CHANNEL_UNBIND_EMAIL`: 用于解绑邮箱
     * - `CHANNEL_VERIFY_MFA`: 用于验证 MFA
     * - `CHANNEL_UNLOCK_ACCOUNT`: 用于自助解锁
     * - `CHANNEL_COMPLETE_EMAIL`: 用于注册/登录时补全邮箱信息
     * - `CHANNEL_DELETE_ACCOUNT`: 用于注销账号
     *
     */
    public static enum Channel {

        @JsonProperty("CHANNEL_LOGIN")
        CHANNEL_LOGIN("CHANNEL_LOGIN"),

        @JsonProperty("CHANNEL_REGISTER")
        CHANNEL_REGISTER("CHANNEL_REGISTER"),

        @JsonProperty("CHANNEL_RESET_PASSWORD")
        CHANNEL_RESET_PASSWORD("CHANNEL_RESET_PASSWORD"),

        @JsonProperty("CHANNEL_VERIFY_EMAIL_LINK")
        CHANNEL_VERIFY_EMAIL_LINK("CHANNEL_VERIFY_EMAIL_LINK"),

        @JsonProperty("CHANNEL_UPDATE_EMAIL")
        CHANNEL_UPDATE_EMAIL("CHANNEL_UPDATE_EMAIL"),

        @JsonProperty("CHANNEL_BIND_EMAIL")
        CHANNEL_BIND_EMAIL("CHANNEL_BIND_EMAIL"),

        @JsonProperty("CHANNEL_UNBIND_EMAIL")
        CHANNEL_UNBIND_EMAIL("CHANNEL_UNBIND_EMAIL"),

        @JsonProperty("CHANNEL_VERIFY_MFA")
        CHANNEL_VERIFY_MFA("CHANNEL_VERIFY_MFA"),

        @JsonProperty("CHANNEL_UNLOCK_ACCOUNT")
        CHANNEL_UNLOCK_ACCOUNT("CHANNEL_UNLOCK_ACCOUNT"),

        @JsonProperty("CHANNEL_COMPLETE_EMAIL")
        CHANNEL_COMPLETE_EMAIL("CHANNEL_COMPLETE_EMAIL"),

        @JsonProperty("CHANNEL_DELETE_ACCOUNT")
        CHANNEL_DELETE_ACCOUNT("CHANNEL_DELETE_ACCOUNT"),
        ;

        private String value;

        Channel(String value) {
            this.value = value;
        }

        public String getValue() {
            return value;
        }
    }


}