/*
 * Decompiled with CFR 0.152.
 */
package cloud.piranha.http.impl;

import cloud.piranha.http.api.HttpServerResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultHttpServerResponse
implements HttpServerResponse {
    private static final Logger LOGGER = Logger.getLogger(DefaultHttpServerResponse.class.getPackageName());
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>(1);
    private OutputStream outputStream;
    private final Socket socket;
    private int status;

    public DefaultHttpServerResponse(Socket socket) {
        this.socket = socket;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public OutputStream getOutputStream() {
        if (this.outputStream == null) {
            try {
                this.outputStream = this.socket.getOutputStream();
            }
            catch (IOException exception) {
                LOGGER.log(Level.WARNING, exception, () -> "An I/O error occurred while acquiring the output stream");
            }
        }
        return this.outputStream;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void closeResponse() throws IOException {
        super.closeResponse();
        this.socket.close();
    }

    private void writeHeader(String name, boolean last) throws IOException {
        OutputStream output = this.getOutputStream();
        output.write(name.getBytes());
        output.write(": ".getBytes());
        output.write(this.headers.get(name).getBytes());
        if (!last) {
            output.write(",".getBytes());
        }
        output.write("\n".getBytes());
    }

    public void writeHeaders() throws IOException {
        for (String name : this.headers.keySet()) {
            this.writeHeader(name, true);
        }
        OutputStream output = this.getOutputStream();
        output.write("\n".getBytes());
    }

    public void writeStatusLine() throws IOException {
        OutputStream output = this.getOutputStream();
        output.write("HTTP/1.0".getBytes());
        output.write(" ".getBytes());
        output.write(Integer.toString(this.status).getBytes());
        output.write("\n".getBytes());
    }
}

