/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import mbanje.kurt.remote_service.IServiceClient;
import mbanje.kurt.remote_service.processor.ClassHelper;
import mbanje.kurt.remote_service.processor.Messenger;
import mbanje.kurt.remote_service.processor.internal.ParameterClient;

public class ServerHandlerGenerator {
    private final Element service;
    private final List<ParameterClient> clientMethods;
    private final String clazz;
    private final String packageName;
    private Element client;
    private ClassName clientInterface;
    private Messenger messenger;
    public static final String SUFFIX = "ServerHandler";
    public final ClassName ISERVICE_CLIENT;

    public ServerHandlerGenerator(String packageName, Element service, List<ParameterClient> clientMethods) {
        this.service = service;
        this.packageName = packageName;
        this.clientMethods = clientMethods;
        this.clazz = service.getSimpleName() + SUFFIX;
        this.ISERVICE_CLIENT = ClassName.get(IServiceClient.class);
    }

    public void generate(Messenger messenger, Filer filer) {
        this.client = this.clientMethods.get((int)0).variable.clazz;
        this.clientInterface = ClassName.get((TypeElement)((TypeElement)this.client));
        this.messenger = messenger;
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)this.generateClass()).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            messenger.error(this.service, "failed to generate class for %s: %s", this.clazz, e.getMessage());
        }
    }

    TypeSpec generateClass() {
        ParameterizedTypeName weakReferenceType = ParameterizedTypeName.get((ClassName)ClassHelper.WEAK_REFERENCE, (TypeName[])new TypeName[]{this.clientInterface});
        FieldSpec reference = FieldSpec.builder((TypeName)weakReferenceType, (String)"reference", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        ParameterizedTypeName clientsType = ParameterizedTypeName.get((ClassName)ClassHelper.ARRAY_LIST, (TypeName[])new TypeName[]{ClassHelper.MESSENGER});
        FieldSpec clients = FieldSpec.builder((TypeName)clientsType, (String)"clients", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>()", new Object[]{ClassHelper.ARRAY_LIST}).build();
        return TypeSpec.classBuilder((String)this.clazz).superclass((TypeName)ClassHelper.HANDLER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(reference).addField(clients).addMethod(this.getConstructor()).addMethod(this.getMessageHandler()).addMethod(this.getSendMsg()).addMethod(this.getClients()).build();
    }

    private MethodSpec getConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)this.client.asType()), "reference", new Modifier[0]).addStatement("this.reference = new $T<>(reference)", new Object[]{ClassHelper.WEAK_REFERENCE}).build();
    }

    private MethodSpec getMessageHandler() {
        StringBuffer buffer = new StringBuffer();
        for (ParameterClient param : this.clientMethods) {
            buffer.append("         case ").append(param.variable.message).append(":\n").append("            service.").append(param.variable.name).append("(");
            for (int index = 0; index < param.variable.params.size(); ++index) {
                ParameterClient parameter = param.variable.params.get(index);
                if (parameter != null && parameter.parameter) {
                    buffer.append("(").append(parameter.element.asType()).append(") msg.obj");
                } else {
                    buffer.append(param.variable.message);
                }
                if (index == param.variable.params.size() - 1) continue;
                buffer.append(",");
            }
            buffer.append(");\n");
            buffer.append("            break;\n");
        }
        return MethodSpec.methodBuilder((String)"handleMessage").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassHelper.MESSAGE, "msg", new Modifier[0]).addStatement("$T service = reference.get()", new Object[]{this.clientInterface}).addCode("if (service != null) {\n        switch (msg.what) {\n         case $T.CONNECT:\n            clients.add(msg.replyTo);\n            $L message  = $L.obtain(null, $T.CONNECT);\n            send(message);\n            break;\n         case $T.DISCONNECT:\n            clients.remove(msg.replyTo);\n            $L message1  = $L.obtain(null, $T.DISCONNECT);\n            send(message1);\n            break;\n         case $T.SHUTDOWN:\n            (($T)service).stopSelf();\n            break;\n", new Object[]{this.ISERVICE_CLIENT, ClassHelper.MESSAGE, ClassHelper.MESSAGE, this.ISERVICE_CLIENT, this.ISERVICE_CLIENT, ClassHelper.MESSAGE, ClassHelper.MESSAGE, this.ISERVICE_CLIENT, this.ISERVICE_CLIENT, ClassHelper.SERVICE}).addCode(buffer.toString(), new Object[0]).addCode("         default:\n            super.handleMessage(msg);\n        }\n       removeMessages(msg.what);\n }", new Object[0]).build();
    }

    private MethodSpec getSendMsg() {
        ClassName remoteExceptionClass = ClassName.get((String)"java.lang", (String)"Exception", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"send").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassHelper.MESSAGE, "message", new Modifier[0]).beginControlFlow("for (int i =0;i< clients.size();i++)", new Object[0]).addCode(" try {\n     clients.get(i).send(message);\n } catch ($T e) {\n      clients.remove(i);\n}", new Object[]{remoteExceptionClass}).endControlFlow().build();
    }

    private MethodSpec getClients() {
        ParameterizedTypeName clientsType = ParameterizedTypeName.get((ClassName)ClassHelper.ARRAY_LIST, (TypeName[])new TypeName[]{ClassHelper.MESSENGER});
        return MethodSpec.methodBuilder((String)"getClients").returns((TypeName)clientsType).addStatement("return clients", new Object[0]).build();
    }
}

