/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import mbanje.kurt.remote_service.processor.ClassHelper;
import mbanje.kurt.remote_service.processor.Messenger;
import mbanje.kurt.remote_service.processor.internal.ParameterClient;

public class ConnectorGenerator {
    private final Element service;
    private final List<ParameterClient> clientMethods;
    private final String clazz;
    private final String packageName;
    private Element client;
    private Element server;
    private ClassName clientInterface;
    private ClassName serverInterface;
    private Messenger messenger;

    public ConnectorGenerator(String packageName, Element service, List<ParameterClient> clientMethods) {
        this.service = service;
        this.packageName = packageName;
        this.serverInterface = ClassName.get((String)packageName, (String)(service.getSimpleName() + "ServerHandler"), (String[])new String[0]);
        this.clientMethods = clientMethods;
        this.clazz = service.getSimpleName() + "Connector";
    }

    public void generate(Messenger messenger, Filer filer) {
        this.client = this.clientMethods.get((int)0).variable.clazz;
        this.clientInterface = ClassName.get((TypeElement)((TypeElement)this.client));
        this.messenger = messenger;
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)this.generateClass()).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            messenger.error(this.service, "failed to generate class for %s: %s", this.clazz, e.getMessage());
        }
    }

    TypeSpec generateClass() {
        FieldSpec handler = FieldSpec.builder((TypeName)this.serverInterface, (String)"handler", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
        FieldSpec messenger = FieldSpec.builder((TypeName)ClassHelper.MESSENGER, (String)"messenger", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.clazz).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(handler).addField(messenger).addMethod(this.getConstructor()).addMethod(this.getBinder()).addMethod(this.getSend()).addMethod(this.getClients());
        return builder.build();
    }

    private MethodSpec getConstructor() {
        ClassName clientHandlerClass = ClassName.get((String)this.packageName, (String)(this.service.getSimpleName() + "ClientHandler"), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.clientInterface, "client", new Modifier[0]).addStatement("handler = new $T(client)", new Object[]{this.serverInterface}).addStatement("messenger = new $T(handler)", new Object[]{ClassHelper.MESSENGER}).build();
    }

    private MethodSpec getBinder() {
        return MethodSpec.methodBuilder((String)"getBinder").returns((TypeName)ClassHelper.IBINDER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return messenger.getBinder()", new Object[0]).build();
    }

    private MethodSpec getSend() {
        return MethodSpec.methodBuilder((String)"send").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Integer.TYPE, "id", new Modifier[0]).addParameter(Object.class, "object", new Modifier[0]).addStatement("$T message = $T.obtain(null,id)", new Object[]{ClassHelper.MESSAGE, ClassHelper.MESSAGE}).addStatement("message.obj = object", new Object[0]).addStatement("handler.send(message)", new Object[0]).build();
    }

    private MethodSpec getClients() {
        ParameterizedTypeName clientsType = ParameterizedTypeName.get((ClassName)ClassHelper.ARRAY_LIST, (TypeName[])new TypeName[]{ClassHelper.MESSENGER});
        return MethodSpec.methodBuilder((String)"getClients").returns((TypeName)clientsType).addStatement("return handler.getClients()", new Object[0]).build();
    }
}

