/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import mbanje.kurt.remote_service.IServiceClient;
import mbanje.kurt.remote_service.processor.ClassHelper;
import mbanje.kurt.remote_service.processor.Messenger;
import mbanje.kurt.remote_service.processor.internal.ParameterServer;

public class ClientHandlerGenerator {
    private final Element service;
    private final List<ParameterServer> serverMethods;
    private final String clazz;
    private final String thePackage;
    private Element server;
    private ClassName serverInterface;
    public static final String SUFFIX = "ClientHandler";
    public final ClassName ISERVICE_CLIENT;

    public ClientHandlerGenerator(String thePackage, Element service, List<ParameterServer> serverMethods) {
        this.service = service;
        this.thePackage = thePackage;
        this.serverMethods = serverMethods;
        this.clazz = service.getSimpleName() + SUFFIX;
        this.ISERVICE_CLIENT = ClassName.get(IServiceClient.class);
    }

    public void generate(Messenger messenger, Filer filer) {
        this.server = this.serverMethods.get((int)0).variable.clazz;
        this.serverInterface = ClassName.get((TypeElement)((TypeElement)this.server));
        JavaFile javaFile = JavaFile.builder((String)this.thePackage, (TypeSpec)this.generateClass()).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            messenger.error(this.service, "failed to generate class for %s: %s", this.clazz, e.getMessage());
        }
    }

    TypeSpec generateClass() {
        ParameterizedTypeName weakReferenceType = ParameterizedTypeName.get((ClassName)ClassHelper.WEAK_REFERENCE, (TypeName[])new TypeName[]{this.serverInterface});
        FieldSpec reference = FieldSpec.builder((TypeName)weakReferenceType, (String)"reference", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        return TypeSpec.classBuilder((String)this.clazz).superclass((TypeName)ClassHelper.HANDLER).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(reference).addMethod(this.getConstructor()).addMethod(this.getMessageHandler()).build();
    }

    private MethodSpec getConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)this.server.asType()), "reference", new Modifier[0]).addStatement("this.reference = new $T<>(reference)", new Object[]{ClassHelper.WEAK_REFERENCE}).build();
    }

    private MethodSpec getMessageHandler() {
        StringBuffer buffer = new StringBuffer();
        for (ParameterServer param : this.serverMethods) {
            int[] cases = param.variable.messages;
            int max = cases.length;
            for (int i = 0; i < max; ++i) {
                buffer.append("         case ").append(cases[i]).append(":\n").append("            stub.").append(param.variable.name).append("(");
                for (int index = 0; index < param.variable.params.size(); ++index) {
                    ParameterServer parameter = param.variable.params.get(index);
                    if (parameter.parameter) {
                        buffer.append("(").append(parameter.element.asType()).append(") msg.obj");
                    } else {
                        buffer.append(cases[i]);
                    }
                    if (index == param.variable.params.size() - 1) continue;
                    buffer.append(",");
                }
                buffer.append(");\n");
                buffer.append("            break;\n");
            }
        }
        return MethodSpec.methodBuilder((String)"handleMessage").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassHelper.MESSAGE, "msg", new Modifier[0]).addStatement("$T stub = reference.get()", new Object[]{this.serverInterface}).addCode("if (stub != null) {\n        switch (msg.what) {\n         case $T.CONNECT:\n            stub.onBoundServiceConnectionChanged(true);\n            break;\n         case $T.DISCONNECT:\n            stub.onBoundServiceConnectionChanged(false);\n            break;\n         case $T.SHUTDOWN:\n            stub.onBoundServiceConnectionChanged(false);\n            break;\n", new Object[]{this.ISERVICE_CLIENT, this.ISERVICE_CLIENT, this.ISERVICE_CLIENT}).addCode(buffer.toString(), new Object[0]).addCode("         default:\n            super.handleMessage(msg);\n        }\n        removeMessages(msg.what);\n }", new Object[0]).build();
    }
}

