/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor.generators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import mbanje.kurt.remote_service.processor.ClassHelper;
import mbanje.kurt.remote_service.processor.Messenger;
import mbanje.kurt.remote_service.processor.internal.ParameterClient;
import mbanje.kurt.remote_service.processor.internal.ParameterServer;

public class ClientGenerator {
    private final Element service;
    private final List<ParameterClient> clientMethods;
    private final List<ParameterServer> serverMethods;
    private final String clazz;
    private final String packageName;
    private Element client;
    private Element server;
    private ClassName clientInterface;
    private ClassName serverInterface;
    private Messenger messenger;

    public ClientGenerator(String packageName, Element service, List<ParameterClient> clientMethods, List<ParameterServer> serverMethods) {
        this.service = service;
        this.packageName = packageName;
        this.clientMethods = clientMethods;
        this.serverMethods = serverMethods;
        this.clazz = service.getSimpleName() + "Client";
    }

    public void generate(Messenger messenger, Filer filer) {
        this.client = this.clientMethods.get((int)0).variable.clazz;
        this.server = this.serverMethods.get((int)0).variable.clazz;
        this.clientInterface = ClassName.get((TypeElement)((TypeElement)this.client));
        this.serverInterface = ClassName.get((TypeElement)((TypeElement)this.server));
        this.messenger = messenger;
        JavaFile javaFile = JavaFile.builder((String)this.packageName, (TypeSpec)this.generateClass()).build();
        try {
            javaFile.writeTo(filer);
        }
        catch (IOException e) {
            messenger.error(this.service, "failed to generate class for %s: %s", this.clazz, e.getMessage());
        }
    }

    TypeSpec generateClass() {
        FieldSpec activity = FieldSpec.builder((TypeName)ClassHelper.ACTIVITY, (String)"parent", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        FieldSpec messenger = FieldSpec.builder((TypeName)ClassHelper.MESSENGER, (String)"messenger", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        FieldSpec serviceMessenger = FieldSpec.builder((TypeName)ClassHelper.MESSENGER, (String)"serviceMessenger", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).initializer("null", new Object[0]).build();
        FieldSpec tag = FieldSpec.builder(String.class, (String)"TAG", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).initializer(this.clazz + ".class.getSimpleName();", new Object[0]).build();
        FieldSpec connection = FieldSpec.builder((TypeName)ClassHelper.SERVICECONNECTION, (String)"connection", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).initializer("new $T() {\n public void onServiceConnected($T className, $T service) {\n           serviceMessenger = new $T(service);\n           bound=true;\n           Log.d(TAG, \"service connected\");\n           send($T.obtain(null, $T.CONNECT));\n}\n \n public void onServiceDisconnected($T className) {\n          serviceMessenger = null;\n          $T.d(TAG, \"service disconnected\");\n}\n};", new Object[]{ClassHelper.SERVICECONNECTION, ClassHelper.COMPONENT, ClassHelper.IBINDER, ClassHelper.MESSENGER, ClassHelper.MESSAGE, this.clientInterface, ClassHelper.COMPONENT, ClassHelper.LOG}).build();
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.clazz).addSuperinterface((TypeName)this.clientInterface).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(tag).addField(activity).addField(messenger).addField(serviceMessenger).addField(Boolean.TYPE, "bound", new Modifier[]{Modifier.PRIVATE}).addField(connection).addMethod(this.getConstructor()).addMethod(this.getStub()).addMethod(this.getDisconnect()).addMethod(this.getConnect()).addMethod(this.getSendMsg());
        for (MethodSpec spec : this.getMethods()) {
            builder.addMethod(spec);
        }
        return builder.build();
    }

    private MethodSpec getConstructor() {
        ClassName clientHandlerClass = ClassName.get((String)this.packageName, (String)(this.service.getSimpleName() + "ClientHandler"), (String[])new String[0]);
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ClassHelper.ACTIVITY, "activity", new Modifier[0]).addParameter((TypeName)this.serverInterface, "stub", new Modifier[0]).addStatement("this.parent = activity", new Object[0]).addStatement("messenger = new $T(new $T(stub))", new Object[]{ClassHelper.MESSENGER, clientHandlerClass}).build();
    }

    private MethodSpec getStub() {
        ClassName returnType = ClassName.get((String)this.packageName, (String)this.clazz, (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"createStub").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter((TypeName)ClassHelper.ACTIVITY, "parent", new Modifier[0]).addParameter((TypeName)this.serverInterface, "stub", new Modifier[0]).addStatement("return new $T(parent,stub)", new Object[]{returnType}).build();
    }

    private List<MethodSpec> getMethods() {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        for (ParameterClient method : this.clientMethods) {
            MethodSpec.Builder builder = MethodSpec.methodBuilder((String)method.variable.name);
            builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
            builder.returns(Void.TYPE);
            int paramCount = method.variable.params.size();
            String paramname = null;
            for (int index = 0; index < paramCount; ++index) {
                ParameterClient parameter = method.variable.params.get(index);
                paramname = parameter.element.getSimpleName().toString();
                ParameterSpec arg = ParameterSpec.builder((TypeName)ClassName.get((TypeMirror)parameter.element.asType()), (String)paramname, (Modifier[])new Modifier[0]).build();
                builder.addParameter(arg);
            }
            builder.addStatement("send($T.obtain(null,$L,$L))", new Object[]{ClassHelper.MESSAGE, method.variable.message, paramname});
            methods.add(builder.build());
        }
        return methods;
    }

    private MethodSpec getConnect() {
        ClassName serviceClass = ClassName.get((TypeElement)((TypeElement)this.service));
        return MethodSpec.methodBuilder((String)"connect").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("if (!bound) {\n   //if(!$T.serviceRunning) {\n     //  parent.startService(new $T(parent.getApplicationContext(),$T.class));\n   //}\n   parent.bindService(new $T(parent,$T.class),connection,$T.BIND_AUTO_CREATE);\n   $T.d(TAG,\"connecting..\");\n}else{\n   $T.d(TAG,\"not bound not connecting..\");\n}", new Object[]{serviceClass, ClassHelper.INTENT, serviceClass, ClassHelper.INTENT, serviceClass, ClassHelper.CONTEXT, ClassHelper.LOG, ClassHelper.LOG}).build();
    }

    private MethodSpec getDisconnect() {
        return MethodSpec.methodBuilder((String)"disconnect").returns(Void.TYPE).addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode("if (bound) {\n   if(serviceMessenger != null) {\nsend($T.obtain(null,$T.DISCONNECT));\n}\nparent.unbindService(connection);\nbound = false;\n$T.d(TAG,\"disconnecting..\");\n}", new Object[]{ClassHelper.MESSAGE, this.clientInterface, ClassHelper.LOG}).build();
    }

    private MethodSpec getSendMsg() {
        ClassName remoteExceptionClass = ClassName.get((String)"android.os", (String)"RemoteException", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"send").returns(Boolean.TYPE).addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)ClassHelper.MESSAGE, "message", new Modifier[0]).addCode(" if(bound) {\n     try {\n       message.replyTo = messenger;\n       serviceMessenger.send(message);\n       return true;\n     }catch ($T e) {\n       $T.e(TAG,\"error sending message: \",e);     }\n  }\n return false;\n", new Object[]{remoteExceptionClass, ClassHelper.LOG}).build();
    }
}

