/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor;

import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import mbanje.kurt.remote_service.IServiceClient;
import mbanje.kurt.remote_service.RemoteMessageClient;
import mbanje.kurt.remote_service.RemoteMessageServer;
import mbanje.kurt.remote_service.RemoteService;
import mbanje.kurt.remote_service.RemoteServiceClient;
import mbanje.kurt.remote_service.RemoteServiceServer;
import mbanje.kurt.remote_service.processor.ClassHelper;
import mbanje.kurt.remote_service.processor.Messenger;
import mbanje.kurt.remote_service.processor.generators.ClientGenerator;
import mbanje.kurt.remote_service.processor.generators.ClientHandlerGenerator;
import mbanje.kurt.remote_service.processor.generators.ConnectorGenerator;
import mbanje.kurt.remote_service.processor.generators.ServerHandlerGenerator;
import mbanje.kurt.remote_service.processor.internal.ClientMethod;
import mbanje.kurt.remote_service.processor.internal.ParameterClient;
import mbanje.kurt.remote_service.processor.internal.ParameterServer;
import mbanje.kurt.remote_service.processor.internal.ServerMethod;
import mbanje.kurt.remote_service.processor.internal.UnnamedPackageException;

public class RemoteServiceProcessor
extends AbstractProcessor {
    private final Messenger messenger = new Messenger();
    private ClassHelper helper;
    private Filer filer;
    private Elements elementUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messenger.init(processingEnv);
        this.helper = new ClassHelper();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(RemoteService.class.getCanonicalName());
        annotations.add(RemoteServiceClient.class.getCanonicalName());
        annotations.add(RemoteServiceServer.class.getCanonicalName());
        annotations.add(RemoteMessageServer.class.getCanonicalName());
        annotations.add(RemoteMessageClient.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment environment) {
        ArrayList<Element> services = new ArrayList<Element>();
        HashMap<String, List<ParameterClient>> clients = new HashMap<String, List<ParameterClient>>();
        HashMap<String, List<ParameterServer>> servers = new HashMap<String, List<ParameterServer>>();
        this.parseServices(environment, services);
        this.parseClients(environment, clients);
        this.parseServers(environment, servers);
        ClassName serviceClientClass = ClassName.get(IServiceClient.class);
        for (Element service : services) {
            String servicename = service.getSimpleName().toString();
            TypeElement typeElement = (TypeElement)service;
            String packageName = "";
            try {
                packageName = ClassHelper.getPackageName(this.elementUtils, typeElement);
            }
            catch (UnnamedPackageException e) {
                this.messenger.error(typeElement, "failed to determine package of this class", new Object[0]);
            }
            ClientHandlerGenerator serviceClientGenerator = new ClientHandlerGenerator(packageName, service, (List)servers.get(servicename));
            serviceClientGenerator.generate(this.messenger, this.filer);
            ServerHandlerGenerator serviceServerGenerator = new ServerHandlerGenerator(packageName, service, (List)clients.get(servicename));
            serviceServerGenerator.generate(this.messenger, this.filer);
            ClientGenerator clientGenerator = new ClientGenerator(packageName, service, (List)clients.get(servicename), (List)servers.get(servicename));
            clientGenerator.generate(this.messenger, this.filer);
            ConnectorGenerator connectorGenerator = new ConnectorGenerator(packageName, service, (List)clients.get(servicename));
            connectorGenerator.generate(this.messenger, this.filer);
        }
        return true;
    }

    private void parseServices(RoundEnvironment environment, List<Element> services) {
        for (Element element : environment.getElementsAnnotatedWith(RemoteService.class)) {
            if (!this.helper.isValidService(element.asType())) {
                this.messenger.error(element, "@RemoteService can only be used on subclasses of Service class", new Object[0]);
                continue;
            }
            services.add(element);
        }
    }

    private void parseClients(RoundEnvironment environment, Map<String, List<ParameterClient>> clients) {
        for (Element element : environment.getElementsAnnotatedWith(RemoteServiceClient.class)) {
            RemoteServiceClient clientAnnotation = element.getAnnotation(RemoteServiceClient.class);
            TypeMirror client = this.helper.clientValue(clientAnnotation);
            String service = ((DeclaredType)client).asElement().getSimpleName().toString();
            ArrayList<ParameterClient> methods = new ArrayList<ParameterClient>();
            if (!this.helper.isInterface(element.asType())) {
                this.messenger.error(element, "%s can only be applied on interfaces, class %s is not an interface", clientAnnotation, element.getSimpleName());
            }
            if (!this.helper.isValidServiceClientClass(element.asType())) {
                this.messenger.error(element, "%s: should extend from  %s", element.getClass().getCanonicalName(), ClassHelper.SERVICE_CLIENT_INTERFACE);
            }
            for (Element element2 : element.getEnclosedElements()) {
                RemoteMessageClient messageAnnotation = element2.getAnnotation(RemoteMessageClient.class);
                ExecutableElement executable = (ExecutableElement)element2;
                List<? extends VariableElement> parameters = executable.getParameters();
                TypeMirror returnType = executable.getReturnType();
                if (returnType.getKind() != TypeKind.VOID) {
                    this.messenger.error(element2, "%s method should return void", element2.getSimpleName());
                }
                ClientMethod method = new ClientMethod(service, element, element2.getSimpleName().toString(), messageAnnotation.value());
                ParameterClient parameterClient = null;
                if (parameters.size() == 0) {
                    parameterClient = new ParameterClient(method, null, true);
                }
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement param = parameters.get(i);
                    if (!this.helper.isValidParameter(param.asType())) {
                        this.messenger.error(param, "%s cannot be used, parameters should be primitives or implement Parcelable", param.asType());
                        continue;
                    }
                    parameterClient = new ParameterClient(method, param, true);
                    method.params.add(parameterClient);
                }
                if (parameterClient == null) continue;
                methods.add(parameterClient);
            }
            clients.put(service, methods);
        }
    }

    private void parseServers(RoundEnvironment environment, Map<String, List<ParameterServer>> servers) {
        for (Element element : environment.getElementsAnnotatedWith(RemoteServiceServer.class)) {
            RemoteServiceServer serverAnnotation = element.getAnnotation(RemoteServiceServer.class);
            TypeMirror server = this.helper.serverValue(serverAnnotation);
            String service = ((DeclaredType)server).asElement().getSimpleName().toString();
            ArrayList<ParameterServer> methods = new ArrayList<ParameterServer>();
            if (!this.helper.isInterface(element.asType())) {
                this.messenger.error(element, "%s can only be applied on interfaces, class %s is not an interface", serverAnnotation, element.getSimpleName());
            }
            if (!this.helper.isValidServiceServerClass(element.asType())) {
                this.messenger.error(element, "%s: should extend from  %s", element.getClass().getCanonicalName(), ClassHelper.SERVICE_SERVER_INTERFACE);
            }
            for (Element element2 : element.getEnclosedElements()) {
                RemoteMessageServer messageAnnotation = element2.getAnnotation(RemoteMessageServer.class);
                ExecutableElement executable = (ExecutableElement)element2;
                List<? extends VariableElement> parameters = executable.getParameters();
                TypeMirror returnType = executable.getReturnType();
                if (returnType.getKind() != TypeKind.VOID) {
                    this.messenger.error(element2, "%s method should return void", element2.getSimpleName());
                }
                ServerMethod method = new ServerMethod(service, element, element2.getSimpleName().toString(), messageAnnotation.value());
                ParameterServer paramserver = null;
                if (parameters.size() == 0) {
                    paramserver = new ParameterServer(method, null, true);
                }
                for (int i = 0; i < parameters.size(); ++i) {
                    VariableElement param = parameters.get(i);
                    if (!this.helper.isValidParameter(param.asType())) {
                        this.messenger.error(param, "%s cannot be used, parameters should be primitives or implement Parcelable", param.asType());
                        continue;
                    }
                    paramserver = new ParameterServer(method, param, i == parameters.size() - 1);
                    method.params.add(paramserver);
                }
                if (paramserver == null) continue;
                methods.add(paramserver);
            }
            servers.put(service, methods);
        }
    }
}

