/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor;

import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;

public final class Messenger {
    private Messager messager;

    public void init(ProcessingEnvironment processingEnvironment) {
        this.messager = processingEnvironment.getMessager();
    }

    public void note(Element e, String msg, Object ... args) {
        this.checkInitialized();
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format(msg, args), e);
    }

    public void warn(Element e, String msg, Object ... args) {
        this.checkInitialized();
        this.messager.printMessage(Diagnostic.Kind.WARNING, String.format(msg, args), e);
    }

    public void error(Element e, String msg, Object ... args) {
        this.checkInitialized();
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(msg, args), e);
    }

    private void checkInitialized() {
        if (this.messager == null) {
            throw new IllegalStateException("Messager not ready. Have you called init()?");
        }
    }
}

