/*
 * Decompiled with CFR 0.152.
 */
package mbanje.kurt.remote_service.processor;

import com.squareup.javapoet.ClassName;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import mbanje.kurt.remote_service.IServiceClient;
import mbanje.kurt.remote_service.IServiceServer;
import mbanje.kurt.remote_service.RemoteServiceClient;
import mbanje.kurt.remote_service.RemoteServiceServer;
import mbanje.kurt.remote_service.processor.internal.UnnamedPackageException;

public class ClassHelper {
    public final String PARCELABLE = "android.os.Parcelable";
    public final String SERVICE_CLASS = "android.app.Service";
    public static final String SERVICE_CLIENT_INTERFACE = IServiceClient.class.getCanonicalName();
    public static final String SERVICE_SERVER_INTERFACE = IServiceServer.class.getCanonicalName();
    public static final ClassName MESSAGE = ClassName.get((String)"android.os", (String)"Message", (String[])new String[0]);
    public static final ClassName WEAK_REFERENCE = ClassName.get((String)"java.lang.ref", (String)"WeakReference", (String[])new String[0]);
    public static final ClassName HANDLER = ClassName.get((String)"android.os", (String)"Handler", (String[])new String[0]);
    public static final ClassName ARRAY_LIST = ClassName.get((String)"java.util", (String)"ArrayList", (String[])new String[0]);
    public static final ClassName SERVICE = ClassName.get((String)"android.app", (String)"Service", (String[])new String[0]);
    public static final ClassName MESSENGER = ClassName.get((String)"android.os", (String)"Messenger", (String[])new String[0]);
    public static final ClassName ACTIVITY = ClassName.get((String)"android.app", (String)"Activity", (String[])new String[0]);
    public static final ClassName COMPONENT = ClassName.get((String)"android.content", (String)"ComponentName", (String[])new String[0]);
    public static final ClassName CONTEXT = ClassName.get((String)"android.content", (String)"Context", (String[])new String[0]);
    public static final ClassName INTENT = ClassName.get((String)"android.content", (String)"Intent", (String[])new String[0]);
    public static final ClassName SERVICECONNECTION = ClassName.get((String)"android.content", (String)"ServiceConnection", (String[])new String[0]);
    public static final ClassName IBINDER = ClassName.get((String)"android.os", (String)"IBinder", (String[])new String[0]);
    public static final ClassName LOG = ClassName.get((String)"android.util", (String)"Log", (String[])new String[0]);

    boolean isPublic(TypeElement annotatedClass) {
        return annotatedClass.getModifiers().contains((Object)Modifier.PUBLIC);
    }

    public boolean isInterface(TypeMirror typeMirror) {
        if (!(typeMirror instanceof DeclaredType)) {
            return false;
        }
        return ((DeclaredType)typeMirror).asElement().getKind() == ElementKind.INTERFACE;
    }

    public boolean isValidParameter(TypeMirror element) {
        if (element.getKind() == TypeKind.ARRAY) {
            ArrayType arrayType = (ArrayType)element;
            return this.isValidParameter(arrayType.getComponentType());
        }
        return element.getKind().isPrimitive() || this.isSubtypeOfType(element, "android.os.Parcelable") || element.toString().equals(Number.class.getCanonicalName()) || element.toString().equals(String.class.getCanonicalName()) || element.toString().equals(Integer.class.getCanonicalName()) || element.toString().equals(Long.class.getCanonicalName()) || element.toString().equals(Short.class.getCanonicalName()) || element.toString().equals(Float.class.getCanonicalName()) || element.toString().equals(Double.class.getCanonicalName());
    }

    public boolean isValidService(TypeMirror element) {
        return this.isSubtypeOfType(element, "android.app.Service");
    }

    public boolean isValidServiceClientClass(TypeMirror element) {
        return this.isSubtypeOfType(element, SERVICE_CLIENT_INTERFACE);
    }

    public boolean isValidServiceServerClass(TypeMirror element) {
        return this.isSubtypeOfType(element, SERVICE_SERVER_INTERFACE);
    }

    public boolean isSubtypeOfType(TypeMirror typeMirror, String otherType) {
        Element element;
        if (otherType.equals(typeMirror.toString())) {
            return true;
        }
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return false;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            StringBuilder typeString = new StringBuilder(declaredType.asElement().toString());
            typeString.append('<');
            for (int i = 0; i < typeArguments.size(); ++i) {
                if (i > 0) {
                    typeString.append(',');
                }
                typeString.append('?');
            }
            typeString.append('>');
            if (typeString.toString().equals(otherType)) {
                return true;
            }
        }
        if (!((element = declaredType.asElement()) instanceof TypeElement)) {
            return false;
        }
        TypeElement typeElement = (TypeElement)element;
        TypeMirror superType = typeElement.getSuperclass();
        if (this.isSubtypeOfType(superType, otherType)) {
            return true;
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            if (!this.isSubtypeOfType(typeMirror2, otherType)) continue;
            return true;
        }
        return false;
    }

    public static String getPackageName(Elements elementUtils, TypeElement type) throws UnnamedPackageException {
        PackageElement pkg = elementUtils.getPackageOf(type);
        if (pkg.isUnnamed()) {
            throw new UnnamedPackageException(type);
        }
        return pkg.getQualifiedName().toString();
    }

    public boolean isValidClass(TypeElement annotatedClass) {
        return this.isPublic(annotatedClass);
    }

    public TypeMirror clientValue(RemoteServiceClient annotation) {
        try {
            annotation.value();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }

    public TypeMirror serverValue(RemoteServiceServer annotation) {
        try {
            annotation.value();
        }
        catch (MirroredTypeException mte) {
            return mte.getTypeMirror();
        }
        return null;
    }
}

