/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser;

import ch.randelshofer.fastdoubleparser.ConfigurableDoubleBitsFromByteArrayAscii;
import ch.randelshofer.fastdoubleparser.ConfigurableDoubleBitsFromByteArrayUtf8;
import ch.randelshofer.fastdoubleparser.ConfigurableDoubleBitsFromCharArray;
import ch.randelshofer.fastdoubleparser.ConfigurableDoubleBitsFromCharSequence;
import ch.randelshofer.fastdoubleparser.NumberFormatSymbols;
import ch.randelshofer.fastdoubleparser.Utf8Decoder;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Objects;

public final class ConfigurableDoubleParser {
    private final NumberFormatSymbols symbols;
    private ConfigurableDoubleBitsFromCharSequence charSequenceParser;
    private ConfigurableDoubleBitsFromCharArray charArrayParser;
    private final boolean ignoreCase;
    private final boolean isAllSingleCharSymbolsAscii;
    private final boolean isDigitsAscii;
    private final boolean isAscii;
    private ConfigurableDoubleBitsFromByteArrayAscii byteArrayAsciiParser;
    private ConfigurableDoubleBitsFromByteArrayUtf8 byteArrayUtf8Parser;

    public ConfigurableDoubleParser(NumberFormatSymbols symbols) {
        this(symbols, false);
    }

    public ConfigurableDoubleParser(DecimalFormatSymbols symbols) {
        this(symbols, false);
    }

    public ConfigurableDoubleParser(NumberFormatSymbols symbols, boolean ignoreCase) {
        Objects.requireNonNull(symbols, "symbols");
        this.symbols = symbols;
        this.ignoreCase = ignoreCase;
        this.isAllSingleCharSymbolsAscii = this.isMostlyAscii(symbols);
        this.isDigitsAscii = this.isDigitsTokensAscii(symbols);
        this.isAscii = this.isAscii(symbols);
    }

    public NumberFormatSymbols getNumberFormatSymbols() {
        return this.symbols;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    private boolean isAscii(NumberFormatSymbols symbols) {
        return this.isAsciiCharCollection(symbols.decimalSeparator()) && this.isAsciiCharCollection(symbols.groupingSeparator()) && this.isAsciiStringCollection(symbols.exponentSeparator()) && this.isAsciiCharCollection(symbols.minusSign()) && this.isAsciiCharCollection(symbols.plusSign()) && this.isAsciiStringCollection(symbols.infinity()) && this.isAsciiStringCollection(symbols.nan()) && this.isAsciiCharCollection(symbols.digits());
    }

    private boolean isMostlyAscii(NumberFormatSymbols symbols) {
        return this.isAsciiCharCollection(symbols.decimalSeparator()) && this.isAsciiCharCollection(symbols.groupingSeparator()) && this.isAsciiCharCollection(symbols.minusSign()) && this.isAsciiCharCollection(symbols.plusSign()) && this.isAsciiCharCollection(symbols.digits());
    }

    private boolean isDigitsTokensAscii(NumberFormatSymbols symbols) {
        return this.isAsciiCharCollection(symbols.digits());
    }

    private boolean isAsciiStringCollection(Collection<String> collection) {
        for (String str : collection) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (ch <= '\u007f') continue;
                return false;
            }
        }
        return true;
    }

    private boolean isAsciiCharCollection(Collection<Character> collection) {
        for (char ch : collection) {
            if (ch <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public ConfigurableDoubleParser(DecimalFormatSymbols symbols, boolean ignoreCase) {
        this(NumberFormatSymbols.fromDecimalFormatSymbols(symbols), ignoreCase);
    }

    public ConfigurableDoubleParser() {
        this(NumberFormatSymbols.fromDefault(), false);
    }

    private ConfigurableDoubleBitsFromCharArray getCharArrayParser() {
        if (this.charArrayParser == null) {
            this.charArrayParser = new ConfigurableDoubleBitsFromCharArray(this.symbols, this.ignoreCase);
        }
        return this.charArrayParser;
    }

    private ConfigurableDoubleBitsFromByteArrayAscii getByteArrayAsciiParser() {
        if (this.byteArrayAsciiParser == null) {
            this.byteArrayAsciiParser = new ConfigurableDoubleBitsFromByteArrayAscii(this.symbols, this.ignoreCase);
        }
        return this.byteArrayAsciiParser;
    }

    private ConfigurableDoubleBitsFromByteArrayUtf8 getByteArrayUtf8Parser() {
        if (this.byteArrayUtf8Parser == null) {
            this.byteArrayUtf8Parser = new ConfigurableDoubleBitsFromByteArrayUtf8(this.symbols, this.ignoreCase);
        }
        return this.byteArrayUtf8Parser;
    }

    private ConfigurableDoubleBitsFromCharSequence getCharSequenceParser() {
        if (this.charSequenceParser == null) {
            this.charSequenceParser = new ConfigurableDoubleBitsFromCharSequence(this.symbols, this.ignoreCase);
        }
        return this.charSequenceParser;
    }

    public double parseDouble(CharSequence str) {
        return this.parseDouble(str, 0, str.length());
    }

    public double parseDouble(CharSequence str, int offset, int length) {
        long bitPattern = this.getCharSequenceParser().parseFloatingPointLiteral(str, offset, length);
        if (bitPattern == 9221120237041090561L) {
            throw new NumberFormatException("illegal syntax");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public double parseDouble(char[] str) {
        return this.parseDouble(str, 0, str.length);
    }

    public double parseDouble(char[] str, int offset, int length) {
        long bitPattern = this.getCharArrayParser().parseFloatingPointLiteral(str, offset, length);
        if (bitPattern == 9221120237041090561L) {
            throw new NumberFormatException("illegal syntax");
        }
        return Double.longBitsToDouble(bitPattern);
    }

    public double parseDouble(byte[] str) {
        return this.parseDouble(str, 0, str.length);
    }

    public double parseDouble(byte[] str, int offset, int length) {
        long bitPattern;
        if (this.isAscii || !this.ignoreCase && this.isAllSingleCharSymbolsAscii) {
            bitPattern = this.getByteArrayAsciiParser().parseFloatingPointLiteral(str, offset, length);
        } else if (this.isDigitsAscii) {
            bitPattern = this.getByteArrayUtf8Parser().parseFloatingPointLiteral(str, offset, length);
        } else {
            Utf8Decoder.Result result = Utf8Decoder.decode(str, offset, length);
            bitPattern = this.getCharArrayParser().parseFloatingPointLiteral(result.chars(), 0, result.length());
        }
        if (bitPattern == 9221120237041090561L) {
            throw new NumberFormatException("illegal syntax");
        }
        return Double.longBitsToDouble(bitPattern);
    }
}

