/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.Accessor;

public class LayeredAccessor<T extends AbstractIdentifiableObject>
implements Accessor<T> {
    private final List<Accessor<T>> accessors = new ArrayList<Accessor<T>>();

    public LayeredAccessor() {
    }

    public LayeredAccessor(List<? extends Accessor<T>> accessors) {
        this.accessors.addAll(accessors);
    }

    public void addAccessor(Accessor<T> accessor) {
        this.accessors.add(accessor);
    }

    public void pushAccessor(Accessor<T> accessor) {
        this.accessors.add(0, accessor);
    }

    @Override
    public T get(ObjectId id) {
        return (T)this.layeredLookup(a -> a.get(id));
    }

    protected <V> V layeredLookup(Function<Accessor<T>, V> f) {
        for (Accessor<T> Accessor2 : this.accessors) {
            V result = f.apply(Accessor2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public T get(String id) {
        return this.get(new ObjectId(id));
    }

    @Override
    public T findByAttributes(Map<String, String> attributes) {
        return (T)this.layeredLookup(a -> a.findByAttributes(attributes));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes) {
        return this.layeredMerge(a -> a.findManyByAttributes(attributes));
    }

    protected <V> Spliterator<V> layeredMerge(Function<Accessor<T>, Spliterator<V>> f) {
        ArrayList result = new ArrayList();
        this.accessors.forEach(a -> ((Spliterator)f.apply((Accessor)a)).forEachRemaining(result::add));
        return result.spliterator();
    }

    @Override
    public Iterator<T> getAll() {
        Iterator<Accessor<T>> accessorIterator = this.accessors.iterator();
        return new MergeIterator<T>(accessorIterator);
    }

    @Override
    public T findByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return (T)this.layeredLookup(a -> a.findByAttributes(attributes, attributesMapKey));
    }

    @Override
    public Spliterator<T> findManyByAttributes(Map<String, String> attributes, String attributesMapKey) {
        return this.layeredMerge(a -> a.findManyByAttributes(attributes, attributesMapKey));
    }

    @Override
    public List<T> getRange(int skip, int limit) {
        List all = Streams.stream(this.getAll()).collect(Collectors.toList());
        return all.subList(skip, Math.min(all.size(), skip + limit));
    }

    @Override
    public void remove(ObjectId id) {
        for (Accessor<T> Accessor2 : this.accessors) {
            T e = Accessor2.get(id);
            if (e == null) continue;
            Accessor2.remove(id);
        }
    }

    @Override
    public T save(T entity) {
        return this.getAccessorForPersistence().save(entity);
    }

    @Override
    public void save(Iterable<T> entities) {
        this.getAccessorForPersistence().save(entities);
    }

    protected Accessor<T> getAccessorForPersistence() {
        return this.accessors.get(0);
    }

    private static final class MergeIterator<T extends AbstractIdentifiableObject>
    implements Iterator<T> {
        private final Iterator<Accessor<T>> accessorIterator;
        private Iterator<T> currentIterator;

        private MergeIterator(Iterator<Accessor<T>> accessorIterator) {
            this.accessorIterator = accessorIterator;
            this.nextAccessor();
        }

        @Override
        public boolean hasNext() {
            if (this.currentIterator != null) {
                boolean hasNext = this.currentIterator.hasNext();
                if (hasNext) {
                    return true;
                }
                this.nextAccessor();
                return this.hasNext();
            }
            return false;
        }

        protected void nextAccessor() {
            if (this.accessorIterator.hasNext()) {
                Accessor<T> currentAccessor = this.accessorIterator.next();
                this.currentIterator = currentAccessor.getAll();
            } else {
                this.currentIterator = null;
            }
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                return (T)((AbstractIdentifiableObject)this.currentIterator.next());
            }
            throw new NoSuchElementException();
        }
    }
}

