/*
 * Decompiled with CFR 0.152.
 */
package step.core.accessors;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.bson.types.ObjectId;
import org.junit.Assert;
import org.junit.Test;
import step.core.accessors.AbstractIdentifiableObject;
import step.core.accessors.AbstractOrganizableObject;
import step.core.accessors.InMemoryAccessor;
import step.core.accessors.LayeredAccessor;

public class LayeredAccessorTest {
    private ObjectId entity1_1;
    private ObjectId entity2_1;
    private ObjectId entity2_2;
    private InMemoryAccessor<AbstractOrganizableObject> accessor1 = new InMemoryAccessor();
    private InMemoryAccessor<AbstractOrganizableObject> accessor2 = new InMemoryAccessor();

    public LayeredAccessorTest() {
        this.entity1_1 = this.addEntity(this.accessor1, "entity 1");
        this.entity2_1 = this.addEntity(this.accessor2, "entity 1");
        this.entity2_2 = this.addEntity(this.accessor2, "entity 2");
    }

    @Test
    public void test() {
        LayeredAccessor accessor = new LayeredAccessor();
        accessor.pushAccessor(this.accessor2);
        accessor.pushAccessor(this.accessor1);
        this.performTests((LayeredAccessor<AbstractOrganizableObject>)accessor);
    }

    @Test
    public void test2() {
        LayeredAccessor accessor = new LayeredAccessor();
        accessor.addAccessor(this.accessor1);
        accessor.addAccessor(this.accessor2);
        this.performTests((LayeredAccessor<AbstractOrganizableObject>)accessor);
    }

    @Test
    public void test3() {
        ArrayList<InMemoryAccessor<AbstractOrganizableObject>> list = new ArrayList<InMemoryAccessor<AbstractOrganizableObject>>();
        list.add(this.accessor1);
        list.add(this.accessor2);
        LayeredAccessor accessor = new LayeredAccessor(list);
        this.performTests((LayeredAccessor<AbstractOrganizableObject>)accessor);
    }

    protected void performTests(LayeredAccessor<AbstractOrganizableObject> accessor) {
        this.testGet(this.entity1_1, accessor);
        this.testGet(this.entity2_1, accessor);
        this.testGet(this.entity2_2, accessor);
        AbstractOrganizableObject[] all = (AbstractOrganizableObject[])Iterators.toArray((Iterator)accessor.getAll(), AbstractOrganizableObject.class);
        Assert.assertEquals((long)3L, (long)all.length);
        AbstractOrganizableObject entity = this.findByName("entity 1", accessor);
        Assert.assertEquals((Object)this.entity1_1, (Object)entity.getId());
        entity = this.findByName("entity 2", accessor);
        Assert.assertEquals((Object)this.entity2_2, (Object)entity.getId());
        entity = (AbstractOrganizableObject)accessor.findByAttributes(this.newAttributes("entity 1"), "attributes");
        Assert.assertEquals((Object)this.entity1_1, (Object)entity.getId());
        ArrayList entities = new ArrayList();
        accessor.findManyByAttributes(this.newAttributes("entity 1")).forEachRemaining(entities::add);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)this.entity1_1, (Object)((AbstractOrganizableObject)entities.get(0)).getId());
        Assert.assertEquals((Object)this.entity2_1, (Object)((AbstractOrganizableObject)entities.get(1)).getId());
        entities = new ArrayList();
        accessor.findManyByAttributes(this.newAttributes("entity 1"), "attributes").forEachRemaining(entities::add);
        Assert.assertEquals((long)2L, (long)entities.size());
        Assert.assertEquals((Object)this.entity1_1, (Object)((AbstractOrganizableObject)entities.get(0)).getId());
        Assert.assertEquals((Object)this.entity2_1, (Object)((AbstractOrganizableObject)entities.get(1)).getId());
        AbstractOrganizableObject entity1_3 = this.newEntity("entity 3");
        accessor.save((AbstractIdentifiableObject)entity1_3);
        entity = (AbstractOrganizableObject)this.accessor1.get(entity1_3.getId());
        Assert.assertNotNull((Object)entity);
        entity = (AbstractOrganizableObject)this.accessor2.get(entity1_3.getId());
        Assert.assertNull((Object)entity);
        accessor.remove(entity1_3.getId());
        entity = (AbstractOrganizableObject)this.accessor1.get(entity1_3.getId());
        Assert.assertNull((Object)entity);
        entity = (AbstractOrganizableObject)accessor.get(new ObjectId());
        Assert.assertNull((Object)entity);
        List range = accessor.getRange(0, 1);
        Assert.assertEquals((Object)this.entity1_1, (Object)((AbstractOrganizableObject)range.get(0)).getId());
    }

    protected AbstractOrganizableObject findByName(String name, LayeredAccessor<AbstractOrganizableObject> accessor) {
        HashMap<String, String> attributes = this.newAttributes(name);
        AbstractOrganizableObject entity = (AbstractOrganizableObject)accessor.findByAttributes(attributes);
        return entity;
    }

    protected HashMap<String, String> newAttributes(String name) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("name", name);
        return attributes;
    }

    protected void testGet(ObjectId entity1_1, LayeredAccessor<AbstractOrganizableObject> accessor) {
        AbstractOrganizableObject result = (AbstractOrganizableObject)accessor.get(entity1_1);
        Assert.assertEquals((Object)entity1_1, (Object)result.getId());
        accessor.get(entity1_1.toString());
        Assert.assertEquals((Object)entity1_1, (Object)result.getId());
    }

    protected ObjectId addEntity(InMemoryAccessor<AbstractOrganizableObject> accessor1, String name) {
        AbstractOrganizableObject entity = this.newEntity(name);
        accessor1.save((AbstractIdentifiableObject)entity);
        return entity.getId();
    }

    protected AbstractOrganizableObject newEntity(String name) {
        AbstractOrganizableObject entity = new AbstractOrganizableObject();
        entity.setAttributes(new HashMap());
        entity.getAttributes().put("name", name);
        return entity;
    }
}

