/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.services.login;

import cc.protea.foundation.integrations.FacebookUtil;
import cc.protea.foundation.integrations.GoogleUtil;
import cc.protea.foundation.integrations.LinkedInUtil;
import cc.protea.foundation.integrations.TwitterUtil;
import cc.protea.foundation.utility.ProfoundConfiguration;
import cc.protea.foundation.utility.SessionUtil;
import cc.protea.foundation.utility.UserUtil;
import cc.protea.foundation.utility.services.login.AuthenticationController;
import cc.protea.foundation.utility.services.login.AuthenticationRequest;
import cc.protea.foundation.utility.services.login.AuthenticationResponse;
import org.apache.commons.lang3.StringUtils;

public class SessionController {
    public static AuthenticationResponse login(AuthenticationRequest request, Integer userId, String sessionToken) {
        if (userId != null && sessionToken != null) {
            return SessionController.addSocialNetwork(request, userId, sessionToken);
        }
        AuthenticationResponse response = AuthenticationController.authenticate(request);
        if (response.success) {
            return response;
        }
        if (!ProfoundConfiguration.createSocialAccounts) {
            return response;
        }
        if (response.facebookUser == null && response.googleUser == null && response.linkedInUser == null && response.twitterUser == null) {
            return response;
        }
        userId = UserUtil.add(request, response);
        if (userId != null) {
            return AuthenticationResponse.success(SessionUtil.create(userId));
        }
        return response;
    }

    public static void logout(String sessionToken) {
        if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
            SessionUtil.remove(sessionToken);
        }
    }

    static AuthenticationResponse addSocialNetwork(AuthenticationRequest request, Integer userId, String sessionToken) {
        AuthenticationResponse response = new AuthenticationResponse();
        if (request.facebookAccessToken != null) {
            response.facebookUser = FacebookUtil.me((String)request.facebookAccessToken);
            if (response.facebookUser != null) {
                UserUtil.setFacebookId(userId, response.facebookUser.getId());
            }
        }
        if (request.linkedInAccessToken != null) {
            response.linkedInUser = LinkedInUtil.me((String)request.linkedInAccessToken);
            if (response.linkedInUser != null) {
                UserUtil.setLinkedInId(userId, response.linkedInUser.id);
            }
        }
        if (request.googlePlusAccessToken != null) {
            response.googleUser = GoogleUtil.me((String)request.googlePlusAccessToken);
            if (response.googleUser != null) {
                UserUtil.setGoogleId(userId, response.googleUser.getId());
            }
        }
        if (request.twitterAccessToken != null) {
            response.twitterUser = TwitterUtil.me((String)request.twitterAccessToken);
            if (response.twitterUser != null) {
                UserUtil.setTwitterId(userId, response.twitterUser.getId());
            }
        }
        response.success = true;
        response.sessionToken = sessionToken;
        return response;
    }
}

