/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.example;

import cc.protea.foundation.integrations.RedisUtil;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.math.NumberUtils;
import redis.clients.jedis.Jedis;

@Path(value="/redis")
@Api(value="/redis", description="Redis Sample")
@Produces(value={"application/json"})
public class RedisExample {
    @GET
    @Path(value="/{id}")
    @ApiOperation(value="View the value stored at a key", response=Response.class)
    public Response view(@PathParam(value="id") String id) {
        Response response = new Response();
        response.id = id;
        response.newValue = NumberUtils.toLong((String)RedisUtil.get((String)id));
        return response;
    }

    @POST
    @Path(value="/{id}/increment")
    @ApiOperation(value="Increase the value stored at a key by 1", response=String.class)
    public Response increment(final @PathParam(value="id") String id) {
        Response response = new Response();
        response.id = id;
        response.newValue = (Long)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Long>(){

            public Long process(Jedis jedis) {
                return jedis.incr(id);
            }
        });
        return response;
    }

    @POST
    @Path(value="/{id}/decrement")
    @ApiOperation(value="Decrease the value stored at a key by 1", response=String.class)
    public Response decrement(final @PathParam(value="id") String id) {
        Response response = new Response();
        response.id = id;
        response.newValue = (Long)RedisUtil.execute((RedisUtil.WithJedis)new RedisUtil.WithJedis<Long>(){

            public Long process(Jedis jedis) {
                return jedis.incrBy(id, -1L);
            }
        });
        return response;
    }

    public static class Response {
        public String id;
        public long newValue;
    }
}

