/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.example;

import cc.protea.foundation.integrations.DatabaseUtil;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.LongMapper;

@Path(value="/database")
@Api(value="/database", description="Database Sample")
@Produces(value={"application/json"})
public class DatabaseExample {
    @GET
    @Path(value="/view")
    @ApiOperation(value="View the value stored at a key", response=Response.class)
    public Response view(final @ApiParam(value="Column to adjust", required=true) Request request) {
        Response response = new Response();
        response.id = request.table + "." + request.column;
        response.newValue = (Long)DatabaseUtil.single((DatabaseUtil.ItemReturn)new DatabaseUtil.ItemReturn<Long>(){

            public Long process(Handle h) {
                return DatabaseExample.this.getValue(h, request.table, request.column);
            }
        });
        return response;
    }

    @POST
    @Path(value="/increment")
    @ApiOperation(value="Increase the value stored at a key by 1", response=Response.class)
    public Response increment(@ApiParam(value="Column to adjust", required=true) Request request) {
        return this.adjust(request.table, request.column, 1);
    }

    @POST
    @Path(value="/decrement")
    @ApiOperation(value="Decrease the value stored at a key by 1", response=Response.class)
    public Response decrement(@ApiParam(value="Column to adjust", required=true) Request request) {
        return this.adjust(request.table, request.column, -1);
    }

    Response adjust(final String table, final String column, final int by) {
        Response response = new Response();
        response.id = table + "." + column;
        response.newValue = (Long)DatabaseUtil.single((DatabaseUtil.ItemReturn)new DatabaseUtil.ItemReturn<Long>(){

            public Long process(Handle h) {
                ((Update)((Update)h.createStatement("UPDATE :table SET :column = :column + (" + by + ")").bind("table", table)).bind("column", column)).execute();
                return DatabaseExample.this.getValue(h, table, column);
            }
        });
        return response;
    }

    long getValue(Handle h, String table, String column) {
        return (Long)((Query)((Query)h.createQuery("SELECT :column FROM :table").bind("table", table)).bind("column", column)).map((ResultSetMapper)LongMapper.FIRST).first();
    }

    public static class Response {
        public String id;
        public long newValue;
    }

    public static class Request {
        public String table;
        public String column;
    }
}

