/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.services.login;

import cc.protea.foundation.integrations.LinkedInUtil;
import cc.protea.foundation.model.Pojo;
import com.google.api.services.plus.model.Person;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import twitter4j.User;

public class AuthenticationResponse
extends Pojo {
    public boolean success;
    public String sessionToken;
    public String message;
    @XmlTransient
    public LinkedInUtil.LinkedInUser linkedInUser = null;
    @XmlTransient
    public com.restfb.types.User facebookUser = null;
    @XmlTransient
    public Person googleUser = null;
    @XmlTransient
    public User twitterUser = null;

    public static AuthenticationResponse success(String sessionToken) {
        AuthenticationResponse response = new AuthenticationResponse();
        response.success = true;
        response.sessionToken = sessionToken;
        return response;
    }

    public static AuthenticationResponse failure(String message) {
        AuthenticationResponse response = new AuthenticationResponse();
        response.success = false;
        response.message = message;
        return response;
    }

    @XmlTransient
    public String getFirstName() {
        if (this.facebookUser != null && this.facebookUser.getFirstName() != null) {
            return this.facebookUser.getFirstName();
        }
        if (this.googleUser != null && this.googleUser.getName() != null) {
            return this.googleUser.getName().getGivenName();
        }
        if (this.twitterUser != null && StringUtils.isNotBlank((CharSequence)this.twitterUser.getName())) {
            String[] arr = this.twitterUser.getName().split(this.twitterUser.getName(), 2);
            return arr.length == 2 ? arr[0] : null;
        }
        if (this.linkedInUser != null && this.linkedInUser.formattedName != null) {
            return this.linkedInUser.firstName;
        }
        return null;
    }

    @XmlTransient
    public String getLastName() {
        if (this.facebookUser != null && this.facebookUser.getLastName() != null) {
            return this.facebookUser.getLastName();
        }
        if (this.googleUser != null && this.googleUser.getName() != null) {
            return this.googleUser.getName().getFamilyName();
        }
        if (this.twitterUser != null && StringUtils.isNotBlank((CharSequence)this.twitterUser.getName())) {
            String[] arr = this.twitterUser.getName().split(this.twitterUser.getName(), 2);
            return arr.length == 2 ? arr[1] : null;
        }
        if (this.linkedInUser != null && this.linkedInUser.formattedName != null) {
            return this.linkedInUser.lastName;
        }
        return null;
    }

    @XmlTransient
    public String getName() {
        String name = null;
        if (name == null && this.linkedInUser != null && this.linkedInUser.formattedName != null) {
            name = this.linkedInUser.formattedName;
        }
        if (name == null && this.googleUser != null && this.googleUser.getName() != null) {
            name = this.googleUser.getName().getFormatted();
        }
        if (name == null && this.facebookUser != null && this.facebookUser.getName() != null) {
            name = this.facebookUser.getName();
        }
        if (name == null && this.twitterUser != null) {
            name = this.twitterUser.getName();
        }
        if (StringUtils.equals((CharSequence)(this.getFirstName() + " " + this.getLastName()), (CharSequence)name)) {
            return null;
        }
        return name;
    }
}

