/*
 * Decompiled with CFR 0.152.
 */
package cc.protea.foundation.utility.providers;

import cc.protea.foundation.util.BasicAuthenticationUtil;
import cc.protea.foundation.utility.SessionUtil;
import cc.protea.foundation.utility.providers.ProteaSecurityContext;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang3.StringUtils;

@Provider
@PreMatching
@Priority(value=1000)
public class SecurityContextFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext requestContext) throws IOException {
        String token = this.getSessionToken(requestContext);
        if (token == null) {
            return;
        }
        requestContext.setProperty("sessionToken", (Object)token);
        Integer userId = SessionUtil.getUserId(token);
        requestContext.setSecurityContext((SecurityContext)new ProteaSecurityContext(userId, requestContext));
    }

    String getSessionToken(ContainerRequestContext requestContext) {
        BasicAuthenticationUtil.BasicIdentification identification = BasicAuthenticationUtil.getIdentification((ContainerRequestContext)requestContext);
        if (identification == null || StringUtils.isBlank((CharSequence)identification.getUsername())) {
            return null;
        }
        return identification.getUsername();
    }
}

