/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath;

import java.io.IOException;
import jsonij.ConstantUtility;
import jsonij.parser.BaseJSONReader;
import jsonij.parser.JSONReader;
import jsonij.parser.ParserException;

public class JPathReader
extends BaseJSONReader
implements JSONReader {
    String jPathString;
    int index;

    public JPathReader(String jpathString) {
        this.jPathString = jpathString;
        this.index = 0;
    }

    public String getJPath() {
        return this.jPathString;
    }

    @Override
    public int readNext() throws ParserException {
        if (this.index < this.jPathString.length()) {
            return this.jPathString.charAt(this.index++);
        }
        return -1;
    }

    public void skipWhitepace() throws IOException, ParserException {
        while (ConstantUtility.isWhiteSpace(this.peek())) {
            this.read();
        }
    }

    public void skipWhitepace(StringBuilder appender) throws ParserException {
        while (ConstantUtility.isWhiteSpace(this.peek())) {
            appender.append((char)this.read());
        }
    }

    @Override
    public JSONReader getStringReader(JSONReader.Mode mode) {
        throw new UnsupportedOperationException();
    }
}

