/*
 * Decompiled with CFR 0.152.
 */
package jsonij.jpath;

import java.lang.reflect.Array;
import java.util.ArrayList;
import jsonij.JSON;
import jsonij.Value;
import jsonij.jpath.Component;
import jsonij.jpath.JPathRuntimeException;
import jsonij.jpath.SearchComponent;

public class JPathImp<C extends Component>
extends ArrayList<C> {
    private static final long serialVersionUID = 3165927117307054584L;
    boolean recordEvaluateTime = false;
    long lastEvaluateTime = -1L;

    public Value evaluate(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluate(value);
    }

    public Value[] evaluateAll(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluateAll(value);
    }

    public Value evaluate(Value value) throws JPathRuntimeException {
        Value[] returnValues = this.evaluateAll(value);
        if (Array.getLength(returnValues) > 0) {
            return returnValues[0];
        }
        return null;
    }

    public Value[] evaluateAll(Value value) throws JPathRuntimeException {
        long startTime = 0L;
        long finishTime = -1L;
        if (this.recordEvaluateTime) {
            startTime = System.nanoTime();
        }
        ArrayList<Value> currentValues = new ArrayList<Value>();
        ArrayList<Value> nextValues = null;
        currentValues.add(value);
        for (int i = 0; i < this.size(); ++i) {
            Component c = (Component)this.get(i);
            nextValues = new ArrayList<Value>();
            if (c.getClass() == SearchComponent.class) {
                throw new JPathRuntimeException("notSupported", SearchComponent.class);
            }
            c.evaluate(currentValues, nextValues);
            currentValues = nextValues;
        }
        if (this.recordEvaluateTime) {
            finishTime = System.nanoTime();
            this.lastEvaluateTime = finishTime - startTime;
        }
        int size = currentValues.size();
        Value[] returnValues = new Value[size];
        for (int i = 0; i < size; ++i) {
            returnValues[i] = currentValues.get(i);
        }
        return returnValues;
    }

    public boolean isRecordEvaluateTime() {
        return this.recordEvaluateTime;
    }

    public void setRecordEvaluateTime(boolean recordEvaluateTime) {
        this.recordEvaluateTime = recordEvaluateTime;
    }

    public long getLastEvaluateTime() {
        return this.lastEvaluateTime / 1000L;
    }
}

