/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.nio.ByteBuffer;
import jsonij.ArrayImp;
import jsonij.NumericImp;
import jsonij.ObjectImp;
import jsonij.StringImp;
import jsonij.Value;
import jsonij.ValueType;

public class JSON {
    protected Value root;
    public static final True TRUE = new True();
    public static final False FALSE = new False();
    public static final Null NULL = new Null();

    public JSON(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.internalType() != ValueType.ARRAY && root.internalType() != ValueType.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public Value getRoot() {
        return this.root;
    }

    void setRoot(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.internalType() != ValueType.ARRAY && root.internalType() != ValueType.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public int size() {
        return this.getRoot().size();
    }

    public boolean isNull() {
        return this.getRoot().isNull();
    }

    public boolean getBoolean() {
        return this.getRoot().getBoolean();
    }

    public int getInt() {
        return this.getRoot().getInt();
    }

    public double getDouble() {
        return this.getRoot().getDouble();
    }

    public java.lang.String getString() {
        return this.getRoot().getString();
    }

    public Value get(int i) {
        return this.getRoot().get(i);
    }

    public Value get(java.lang.String key) {
        return this.getRoot().get(key);
    }

    public java.lang.String toJSON() {
        return this.getRoot().toJSON();
    }

    public java.lang.String toString() {
        return "JSON@" + Integer.toHexString(this.hashCode()) + ":" + this.getRoot().toString();
    }

    public boolean equals(java.lang.Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.getRoot().equals(((JSON)o).getRoot());
    }

    public int hashCode() {
        if (this.root == null) {
            return 0;
        }
        return this.root.hashCode();
    }

    public static final class Null
    extends Value {
        private static final long serialVersionUID = -2323485713422970959L;
        public static final java.lang.String VALUE = "null";

        private Null() {
        }

        @Override
        public ValueType internalType() {
            return ValueType.NULL;
        }

        @Override
        public int nestedSize() {
            return 0;
        }

        @Override
        public java.lang.String toJSON() {
            return VALUE;
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            buffer.put((byte)90);
            return buffer;
        }

        @Override
        public int hashCode() {
            int hash = 7 + this.toJSON().hashCode();
            return hash;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            return obj instanceof Null;
        }
    }

    public static final class False
    extends Boolean {
        private static final long serialVersionUID = -8602585595611232921L;
        public static final java.lang.String VALUE = "false";

        private False() {
        }

        @Override
        public ValueType internalType() {
            return ValueType.FALSE;
        }

        @Override
        public boolean getBoolean() {
            return false;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public java.lang.String toJSON() {
            return VALUE;
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)0);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            buffer.put((byte)70);
            return buffer;
        }

        @Override
        public int hashCode() {
            int hash = 3 + this.toJSON().hashCode();
            return hash;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            return obj instanceof False;
        }
    }

    public static final class True
    extends Boolean {
        private static final long serialVersionUID = 9058009765879934009L;
        public static final java.lang.String VALUE = "true";

        private True() {
        }

        @Override
        public ValueType internalType() {
            return ValueType.TRUE;
        }

        @Override
        public boolean getBoolean() {
            return true;
        }

        @Override
        public int nestedSize() {
            return 1;
        }

        @Override
        public java.lang.String toJSON() {
            return VALUE;
        }

        @Override
        public ByteBuffer toBSON(ByteBuffer buffer) {
            buffer.put((byte)1);
            return buffer;
        }

        @Override
        public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
            buffer.put((byte)84);
            return buffer;
        }

        @Override
        public int hashCode() {
            int hash = 5 + this.toJSON().hashCode();
            return hash;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            return obj instanceof True;
        }
    }

    public static abstract class Boolean
    extends Value {
        private static final long serialVersionUID = 2008468998971968312L;

        public static Boolean getValue(boolean bool) {
            if (bool) {
                return TRUE;
            }
            return FALSE;
        }
    }

    public static final class String
    extends StringImp {
        private static final long serialVersionUID = -2499952452764709487L;

        public String(java.lang.String s) {
            super(s);
        }

        public static String getValue(java.lang.String string) {
            return new String(string);
        }
    }

    public static final class Numeric
    extends NumericImp {
        private static final long serialVersionUID = -5098879252150523422L;

        public Numeric(int value) {
            super(value);
        }

        public Numeric(long value) {
            super(value);
        }

        public Numeric(float value) {
            super(value);
        }

        public Numeric(double value) {
            super(value);
        }

        public Numeric(Number numberValue) {
            super(numberValue);
        }

        public Numeric(java.lang.String numberString) {
            super(numberString);
        }
    }

    public static final class Array<E extends Value>
    extends ArrayImp<E> {
        private static final long serialVersionUID = -4044562650881178384L;

        public void add(java.lang.String s) {
            this.add(new String(s));
        }

        public void add(byte n) {
            this.add(new Numeric(n));
        }

        public void add(short n) {
            this.add(new Numeric(n));
        }

        public void add(int n) {
            this.add(new Numeric(n));
        }

        public void add(double n) {
            this.add(new Numeric(n));
        }

        public void add(float n) {
            this.add(new Numeric(n));
        }

        public void add(boolean b) {
            if (b) {
                this.add(TRUE);
            } else {
                this.add(FALSE);
            }
        }

        public void addNull() {
            this.add(NULL);
        }
    }

    public static final class Object<K extends CharSequence, V extends Value>
    extends ObjectImp<K, V> {
        private static final long serialVersionUID = -6693177054713276130L;

        @Override
        public void put(K k, java.lang.String s) {
            this.put(k, new String(s));
        }

        @Override
        public void put(K k, byte n) {
            this.put(k, new Numeric(n));
        }

        @Override
        public void put(K k, short n) {
            this.put(k, new Numeric(n));
        }

        @Override
        public void put(K k, int n) {
            this.put(k, new Numeric(n));
        }

        @Override
        public void put(K k, double n) {
            this.put(k, new Numeric(n));
        }

        @Override
        public void put(K k, float n) {
            this.put(k, new Numeric(n));
        }

        @Override
        public void put(K k, boolean b) {
            if (b) {
                this.put(k, TRUE);
            } else {
                this.put(k, FALSE);
            }
        }

        public void putNull(K k) {
            this.put(k, NULL);
        }
    }
}

