/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassProperty {
    private Class<?> klass = null;
    private String propertyName = null;
    private ClassPropertyAccessor accessor = null;
    private ClassPropertyMutator mutator = null;
    private boolean collector = false;

    public ClassPropertyAccessor getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ClassPropertyAccessor accessor) {
        this.accessor = accessor;
    }

    public Class<?> getKlass() {
        return this.klass;
    }

    public void setKlass(Class<?> klass) {
        this.klass = klass;
    }

    public ClassPropertyMutator getMutator() {
        return this.mutator;
    }

    public void setMutator(ClassPropertyMutator mutator) {
        this.mutator = mutator;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public void registerAccessor(Field field) {
        if (this.accessor == null) {
            this.accessor = new ClassPropertyAccessor();
            this.accessor.field = field;
            this.accessor.klass = field.getDeclaringClass();
            this.accessor.type = field.getType();
            this.accessor.genericType = field.getGenericType();
        } else if (this.accessor.field == null) {
            this.accessor.field = field;
        }
    }

    public void registorMutator(Field field) {
        if (this.mutator == null) {
            this.mutator = new ClassPropertyMutator();
            this.mutator.field = field;
            this.mutator.klass = field.getDeclaringClass();
            this.mutator.type = field.getType();
            this.mutator.genericType = field.getGenericType();
        } else if (this.mutator.field == null) {
            this.mutator.field = field;
        }
    }

    public void registerAccessor(Method method) {
        if (this.accessor == null) {
            this.accessor = new ClassPropertyAccessor();
            this.accessor.method = method;
            this.accessor.klass = method.getDeclaringClass();
            this.accessor.type = method.getReturnType();
            this.accessor.genericType = method.getGenericReturnType();
        } else if (this.accessor.method == null) {
            this.accessor.method = method;
        }
    }

    public void registorMutator(Method method) {
        if (this.mutator == null) {
            Class<?>[] argumentTypes = method.getParameterTypes();
            Type[] argumentGenericTypes = method.getGenericParameterTypes();
            if (argumentTypes.length == 1) {
                this.mutator = new ClassPropertyMutator();
                this.mutator.method = method;
                this.mutator.klass = method.getDeclaringClass();
                this.mutator.type = argumentTypes[0];
                this.mutator.genericType = argumentGenericTypes[0];
            }
        } else if (this.mutator.method == null) {
            this.mutator.method = method;
        }
    }

    public boolean isValid() {
        return this.mutator != null && this.accessor != null && this.mutator.canAccess() && this.accessor.canAccess();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassProperty other = (ClassProperty)obj;
        return Objects.equals(this.propertyName, other.propertyName);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + Objects.hashCode(this.klass);
        hash = 67 * hash + Objects.hashCode(this.propertyName);
        return hash;
    }

    public String toString() {
        return this.klass.getSimpleName() + "." + this.propertyName + "(" + this.mutator + "): " + this.accessor;
    }

    public static String getModifierString(int modifiers) {
        String modifier = null;
        modifier = Modifier.isPublic(modifiers) ? "+" : (Modifier.isPrivate(modifiers) ? "-" : (Modifier.isProtected(modifiers) ? "#" : "%"));
        return modifier;
    }

    public static String getTypeString(Type genericType) {
        StringBuilder builder = new StringBuilder();
        if (genericType instanceof Class) {
            Class genericTypeClass = (Class)genericType;
            builder.append(genericTypeClass.getSimpleName());
        } else if (genericType instanceof ParameterizedType) {
            ParameterizedType genericParameterizedType = (ParameterizedType)genericType;
            builder.append(ClassProperty.getTypeString(genericParameterizedType.getRawType()));
            Type[] innerTypes = genericParameterizedType.getActualTypeArguments();
            builder.append('<');
            if (innerTypes.length > 0) {
                for (int i = 0; i < innerTypes.length - 1; ++i) {
                    builder.append(ClassProperty.getTypeString(innerTypes[i])).append(',');
                }
                builder.append(ClassProperty.getTypeString(innerTypes[innerTypes.length - 1]));
            }
            builder.append('>');
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassPropertyMutator {
        private Class<?> klass;
        private Class<?> type;
        private Type genericType;
        private Method method;
        private Field field;

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public void setKlass(Class<?> klass) {
            this.klass = klass;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public void setGenericType(Type genericType) {
            this.genericType = genericType;
        }

        public String toString() {
            int modifiers;
            StringBuilder builder = new StringBuilder();
            if (this.field != null) {
                modifiers = this.field.getModifiers();
                builder.append(ClassProperty.getModifierString(modifiers));
                builder.append('f');
            }
            if (this.method != null) {
                modifiers = this.method.getModifiers();
                builder.append(ClassProperty.getModifierString(modifiers));
                builder.append('m');
            }
            builder.append('[');
            builder.append(ClassProperty.getTypeString(this.type));
            builder.append(']');
            return builder.toString();
        }

        public boolean canAccess() {
            if (this.field != null && Modifier.isPublic(this.field.getModifiers())) {
                return true;
            }
            return this.method != null && Modifier.isPublic(this.method.getModifiers());
        }

        public boolean fieldType() {
            return this.field != null && Modifier.isPublic(this.field.getModifiers());
        }

        public boolean methodType() {
            return this.method != null && Modifier.isPublic(this.method.getModifiers());
        }

        public void fire(Object object, boolean bool) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, bool);
            }
            if (this.fieldType()) {
                this.field.set(object, bool);
            }
        }

        public void fire(Object object, byte byteValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, byteValue);
            }
            if (this.fieldType()) {
                this.field.set(object, byteValue);
            }
        }

        public void fire(Object object, short shortValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, shortValue);
            }
            if (this.fieldType()) {
                this.field.set(object, shortValue);
            }
        }

        public void fire(Object object, float floatValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, Float.valueOf(floatValue));
            }
            if (this.fieldType()) {
                this.field.set(object, Float.valueOf(floatValue));
            }
        }

        public void fire(Object object, int intValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, intValue);
            }
            if (this.fieldType()) {
                this.field.set(object, intValue);
            }
        }

        public void fire(Object object, long longValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, longValue);
            }
            if (this.fieldType()) {
                this.field.set(object, longValue);
            }
        }

        public void fire(Object object, String string) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, string);
            }
            if (this.fieldType()) {
                this.field.set(object, string);
            }
        }

        public void fire(Object object, Object propertyObject) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (this.methodType()) {
                this.method.invoke(object, propertyObject);
            }
            if (this.fieldType()) {
                this.field.set(object, propertyObject);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassPropertyAccessor {
        private Class<?> klass;
        private Class<?> type;
        private Type genericType;
        private Method method;
        private Field field;

        public Field getField() {
            return this.field;
        }

        public void setField(Field field) {
            this.field = field;
        }

        public Class<?> getKlass() {
            return this.klass;
        }

        public void setKlass(Class<?> klass) {
            this.klass = klass;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public Class<?> getType() {
            return this.type;
        }

        public void setType(Class<?> type) {
            this.type = type;
        }

        public Type getGenericType() {
            return this.genericType;
        }

        public void setGenericType(Type genericType) {
            this.genericType = genericType;
        }

        public String toString() {
            int modifiers;
            StringBuilder builder = new StringBuilder();
            if (this.field != null) {
                modifiers = this.field.getModifiers();
                builder.append(ClassProperty.getModifierString(modifiers));
                builder.append('f');
            }
            if (this.method != null) {
                modifiers = this.method.getModifiers();
                builder.append(ClassProperty.getModifierString(modifiers));
                builder.append('m');
            }
            builder.append('[');
            builder.append(ClassProperty.getTypeString(this.type));
            builder.append(']');
            return builder.toString();
        }

        public boolean canAccess() {
            if (this.field != null && Modifier.isPublic(this.field.getModifiers())) {
                return true;
            }
            return this.method != null && Modifier.isPublic(this.method.getModifiers());
        }

        public boolean fieldType() {
            return this.field != null && Modifier.isPublic(this.field.getModifiers());
        }

        public boolean methodType() {
            return this.method != null && Modifier.isPublic(this.method.getModifiers());
        }
    }
}

