/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import jsonij.json.ArrayImp;
import jsonij.json.JSONParser;
import jsonij.json.NumericImp;
import jsonij.json.ObjectImp;
import jsonij.json.StringImp;
import jsonij.json.Value;
import jsonij.parser.ParserException;

public class JSON {
    Value root;
    public static final True TRUE = new True();
    public static final False FALSE = new False();
    public static final Null NULL = new Null();
    static final JSONParser parser = new JSONParser();

    public JSON(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.internalType() != Value.TYPE.ARRAY && root.internalType() != Value.TYPE.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public Value getRoot() {
        return this.root;
    }

    void setRoot(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.internalType() != Value.TYPE.ARRAY && root.internalType() != Value.TYPE.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public int size() {
        return this.getRoot().size();
    }

    public boolean isNull() {
        return this.getRoot().isNull();
    }

    public boolean getBoolean() {
        return this.getRoot().getBoolean();
    }

    public int getInt() {
        return this.getRoot().getInt();
    }

    public double getDouble() {
        return this.getRoot().getDouble();
    }

    public java.lang.String getString() {
        return this.getRoot().getString();
    }

    public Value get(int i) {
        return this.getRoot().get(i);
    }

    public Value get(java.lang.String key) {
        return this.getRoot().get(key);
    }

    public java.lang.String toJSON() {
        return this.getRoot().toJSON();
    }

    public java.lang.String toString() {
        return java.lang.String.format("JSON@%s:%s", this.hashCode(), this.getRoot().toString());
    }

    public boolean equals(java.lang.Object o) {
        if (o == null) {
            return false;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        return this.getRoot().equals(((JSON)o).getRoot());
    }

    public int hashCode() {
        Value root = this.getRoot();
        if (root == null) {
            return 0;
        }
        return root.hashCode();
    }

    public static JSON parse(java.lang.String document) throws ParserException, IOException {
        return new JSON(parser.parse(document));
    }

    public static JSON parse(Reader documentReader) throws ParserException, IOException {
        return new JSON(parser.parse(documentReader));
    }

    public static class Null
    extends Value {
        public static final java.lang.String VALUE = "null";

        private Null() {
        }

        protected Value.TYPE internalType() {
            return Value.TYPE.NULL;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 7 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof Null;
        }
    }

    public static class False
    extends Boolean {
        public static final java.lang.String VALUE = "false";

        private False() {
        }

        protected Value.TYPE internalType() {
            return Value.TYPE.FALSE;
        }

        public boolean getBoolean() {
            return false;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 3 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof False;
        }
    }

    public static class True
    extends Boolean {
        public static final java.lang.String VALUE = "true";

        private True() {
        }

        protected Value.TYPE internalType() {
            return Value.TYPE.TRUE;
        }

        public boolean getBoolean() {
            return true;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 5 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof True;
        }
    }

    public static abstract class Boolean
    extends Value {
        public static Boolean getValue(boolean bool) {
            if (bool) {
                return TRUE;
            }
            return FALSE;
        }
    }

    public static class String
    extends StringImp {
        public String(java.lang.String s) {
            super(s);
        }

        public static String getValue(java.lang.String string) {
            return new String(string);
        }
    }

    public static class Numeric
    extends NumericImp {
        public Numeric(int value) {
            super(value);
        }

        public Numeric(long value) {
            super(value);
        }

        public Numeric(double value) {
            super(value);
        }

        public Numeric(Number numberValue) {
            super(numberValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array<E extends Value>
    extends ArrayImp<E> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Object<K extends String, V extends Value>
    extends ObjectImp<K, V> {
    }
}

